/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.scheduler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLoopTask;
import heronarts.lx.LXSerializable;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.scheduler.LXScheduledProject;
import heronarts.lx.utils.LXUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class LXScheduler
extends LXComponent
implements LXLoopTask {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private File file;
    private LXScheduledProject transitionEntry = null;
    private double transitionProgress = 0.0;
    private double brightnessLerp = 0.0;
    private final List<LXScheduledProject> mutableEntries = new ArrayList<LXScheduledProject>();
    public final List<LXScheduledProject> entries = Collections.unmodifiableList(this.mutableEntries);
    public final BooleanParameter enabled = new BooleanParameter("Enabled", false).setDescription("Whether the scheduler is currently enabled");
    public final BooleanParameter fade = new BooleanParameter("Fade", true).setDescription("Whether to fade in and out on project transitions");
    public final BoundedParameter fadeTimeSecs = new BoundedParameter("Fade Time", 5.0, 0.0, 60.0).setDescription("Fade time in seconds").setUnits(LXParameter.Units.SECONDS);
    public final BooleanParameter dirty = new BooleanParameter("Dirty", false).setDescription("Whether the schedule has been modified");
    private final Calendar calendar = Calendar.getInstance();
    private static final String KEY_VERSION = "version";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_ENTRIES = "entries";

    public LXScheduler(LX lx) {
        super(lx);
        this.addParameter("enabled", this.enabled);
        this.addParameter("fade", this.fade);
        this.addParameter("fadeTimeSecs", this.fadeTimeSecs);
        this.addArray("projects", this.entries);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.fade && !this.fade.isOn() && this.transitionEntry != null) {
            this.finishTransition();
        }
        this.dirty.setValue(true);
    }

    public LXScheduler addListener(Listener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXScheduler.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public LXScheduler removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXScheduler.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    private void _reindexEntries() {
        int i = 0;
        for (LXScheduledProject entry : this.entries) {
            entry.setIndex(i++);
        }
    }

    public LXScheduledProject addEntry() {
        return this.addEntry(null);
    }

    public LXScheduledProject addEntry(File projectFile) {
        LXScheduledProject entry = new LXScheduledProject(this);
        this.mutableEntries.add(entry);
        this._reindexEntries();
        if (projectFile != null) {
            entry.setProject(projectFile);
        }
        for (Listener listener : this.listeners) {
            listener.entryAdded(this, entry);
        }
        this.dirty.setValue(true);
        return entry;
    }

    public LXScheduler removeEntry(LXScheduledProject entry) {
        if (!this.mutableEntries.contains(entry)) {
            throw new IllegalStateException("Cannot remove non-existent entry: " + String.valueOf(entry));
        }
        this.mutableEntries.remove(entry);
        this._reindexEntries();
        for (Listener listener : this.listeners) {
            listener.entryRemoved(this, entry);
        }
        this.dirty.setValue(true);
        LX.dispose(entry);
        return this;
    }

    public LXScheduler moveEntry(LXScheduledProject entry, int index) {
        if (!this.mutableEntries.contains(entry)) {
            throw new IllegalStateException("Cannot move non-existent entry: " + String.valueOf(entry));
        }
        this.mutableEntries.remove(entry);
        this.mutableEntries.add(index, entry);
        for (Listener listener : this.listeners) {
            listener.entryMoved(this, entry);
        }
        this.dirty.setValue(true);
        return this;
    }

    private int getTimeSecsOfDay(long millis) {
        this.calendar.setTimeInMillis(millis);
        return 3600 * this.calendar.get(11) + 60 * this.calendar.get(12) + this.calendar.get(13);
    }

    public boolean isInTransition() {
        return this.transitionEntry != null;
    }

    public double getTransitionProgress() {
        return this.transitionEntry != null ? this.transitionProgress : 0.0;
    }

    @Override
    public void loop(double deltaMs) {
        if (!this.lx.preferences.schedulerEnabled.isOn()) {
            return;
        }
        if (!this.enabled.isOn()) {
            return;
        }
        if (this.transitionEntry != null) {
            double newProgress = this.transitionProgress + deltaMs / (1000.0 * this.fadeTimeSecs.getValue());
            if (newProgress < 0.5) {
                this.transitionProgress = newProgress;
                this.lx.engine.output.brightness.setValue(LXUtils.lerp(this.brightnessLerp, 0.0, 2.0 * newProgress));
            } else if (newProgress < 1.0) {
                if (this.transitionProgress < 0.5) {
                    this.switchTransitionProject();
                }
                this.lx.engine.output.brightness.setValue(LXUtils.lerp(0.0, this.brightnessLerp, 2.0 * (newProgress - 0.5)));
                this.transitionProgress = newProgress;
            } else {
                this.finishTransition();
            }
        }
        long thisFrameSecsOfDay = this.getTimeSecsOfDay(this.lx.engine.nowMillis);
        long prevFrameSecsOfDay = this.getTimeSecsOfDay(this.lx.engine.nowMillis - (long)Math.ceil(deltaMs));
        for (LXScheduledProject entry : this.entries) {
            if (!entry.enabled.isOn()) continue;
            int thresholdSecsOfDay = 3600 * entry.hours.getValuei() + 60 * entry.minutes.getValuei() + entry.seconds.getValuei();
            if (thresholdSecsOfDay == 0) {
                if (thisFrameSecsOfDay < (long)thresholdSecsOfDay || prevFrameSecsOfDay <= thisFrameSecsOfDay) continue;
                this.openEntry(entry);
                continue;
            }
            if (prevFrameSecsOfDay >= (long)thresholdSecsOfDay || (long)thresholdSecsOfDay > thisFrameSecsOfDay) continue;
            this.openEntry(entry);
        }
    }

    private void startTransition(LXScheduledProject entry) {
        this.transitionEntry = entry;
        this.transitionProgress = 0.0;
        this.brightnessLerp = this.lx.engine.output.brightness.getValue();
    }

    private void switchTransitionProject() {
        this.lx.openProject(this.lx.getMediaFile(LX.Media.PROJECTS, this.transitionEntry.projectFile.getString(), false));
        this.brightnessLerp = this.lx.engine.output.brightness.getValue();
    }

    private void finishTransition() {
        if (this.transitionProgress < 0.5) {
            this.switchTransitionProject();
        } else {
            this.lx.engine.output.brightness.setValue(this.brightnessLerp);
        }
        this.transitionEntry = null;
        this.transitionProgress = 0.0;
    }

    protected void openEntry(LXScheduledProject entry) {
        String fileName = entry.projectFile.getString();
        if (fileName != null) {
            if (this.transitionEntry == entry) {
                this.finishTransition();
            } else if (this.enabled.isOn() && this.fade.isOn() && this.fadeTimeSecs.getValue() > 0.0) {
                this.startTransition(entry);
            } else {
                this.lx.openProject(this.lx.getMediaFile(LX.Media.PROJECTS, fileName, false));
            }
        }
    }

    protected void setSchedule(File file, Listener.Change change) {
        this.file = file;
        this.dirty.setValue(false);
        this.lx.preferences.setSchedule(file);
        for (Listener listener : this.listeners) {
            listener.scheduleChanged(file, change);
        }
    }

    public void newSchedule() {
        this.closeSchedule();
        this.load(this.lx, new JsonObject());
        this.setSchedule(null, Listener.Change.NEW);
    }

    public void openSchedule(File file) {
        this.openSchedule(file, false);
    }

    /*
     * WARNING - void declaration
     */
    public void openSchedule(File file, boolean openInitialProject) {
        for (Listener listener : this.listeners) {
            listener.scheduleChanged(file, Listener.Change.TRY);
        }
        try {
            Throwable throwable = null;
            Iterator<Listener> iterator = null;
            try (FileReader fr = new FileReader(file);){
                JsonObject obj = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
                this.closeSchedule();
                this.lx.setScheduleLoadingFlag(true);
                this.load(this.lx, obj);
                this.setSchedule(file, Listener.Change.OPEN);
                LX.log("Schedule loaded successfully from " + file.toString());
            }
            catch (Throwable throwable2) {
                void var3_9;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var3_9;
            }
        }
        catch (IOException iOException) {
            LX.error("Could not load project file: " + iOException.getLocalizedMessage());
            this.lx.pushError(iOException, "Could not load schedule file: " + iOException.getLocalizedMessage());
        }
        catch (Exception exception) {
            LX.error(exception, "Exception in openProject: " + exception.getLocalizedMessage());
            this.lx.pushError(exception, "Exception in openSchedule: " + exception.getLocalizedMessage());
        }
        this.lx.setScheduleLoadingFlag(false);
        if (openInitialProject) {
            this.openInitialProject();
        }
    }

    private void openInitialProject() {
        ArrayList<LXScheduledProject> validEntries = new ArrayList<LXScheduledProject>();
        for (LXScheduledProject entry : this.entries) {
            if (!entry.enabled.isOn() || entry.projectFile.getString() == null) continue;
            validEntries.add(entry);
        }
        if (validEntries.isEmpty()) {
            LX.error("Schedule file has no enabled entries, no project to load: " + String.valueOf(this.file));
            return;
        }
        Collections.sort(validEntries, new Comparator<LXScheduledProject>(){

            @Override
            public int compare(LXScheduledProject p1, LXScheduledProject p2) {
                int t2;
                int t1 = 3600 * p1.hours.getValuei() + 60 * p1.minutes.getValuei() + p1.seconds.getValuei();
                return t1 < (t2 = 3600 * p2.hours.getValuei() + 60 * p2.minutes.getValuei() + p2.seconds.getValuei()) ? -1 : (t1 > t2 ? 1 : 0);
            }
        });
        LXScheduledProject candidate = (LXScheduledProject)validEntries.get(validEntries.size() - 1);
        long nowSecsOfDay = this.getTimeSecsOfDay(System.currentTimeMillis());
        for (LXScheduledProject project : validEntries) {
            int projectSecsOfDay = 3600 * project.hours.getValuei() + 60 * project.minutes.getValuei() + project.seconds.getValuei();
            if (nowSecsOfDay < (long)projectSecsOfDay) break;
            candidate = project;
        }
        this.lx.openProject(this.lx.getMediaFile(LX.Media.PROJECTS, candidate.projectFile.getString(), false));
    }

    private void closeSchedule() {
    }

    public void saveSchedule() {
        if (this.file != null) {
            this.saveSchedule(this.file);
        }
    }

    public void saveSchedule(File file) {
        if (!this.lx.permissions.canSave()) {
            return;
        }
        JsonObject obj = new JsonObject();
        this.save(this.lx, obj);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
                writer.setIndent("  ");
                new GsonBuilder().create().toJson((JsonElement)obj, writer);
                LX.log("Schedule saved successfully to " + file.toString());
                this.setSchedule(file, Listener.Change.SAVE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iox) {
            LX.error(iox, "Could not write schedule to output file: " + file.toString());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.listeners.forEach(listener -> LX.warning("Stranded LXScheduler.Listener: " + String.valueOf(listener)));
        this.listeners.clear();
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        int i = this.entries.size() - 1;
        while (i >= 0) {
            this.removeEntry(this.entries.get(i));
            --i;
        }
        if (obj.has(KEY_ENTRIES)) {
            JsonArray entryArr = obj.get(KEY_ENTRIES).getAsJsonArray();
            for (JsonElement entryElem : entryArr) {
                JsonObject entryObj = entryElem.getAsJsonObject();
                this.addEntry().load(lx, entryObj);
            }
        }
        super.load(lx, obj);
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        obj.addProperty(KEY_VERSION, "1.1.0");
        obj.addProperty(KEY_TIMESTAMP, (Number)System.currentTimeMillis());
        obj.add(KEY_ENTRIES, (JsonElement)LXSerializable.Utils.toArray(lx, this.entries));
        super.save(lx, obj);
    }

    public static interface Listener {
        public void scheduleChanged(File var1, Change var2);

        public void entryAdded(LXScheduler var1, LXScheduledProject var2);

        public void entryRemoved(LXScheduler var1, LXScheduledProject var2);

        public void entryMoved(LXScheduler var1, LXScheduledProject var2);

        public static enum Change {
            TRY,
            NEW,
            SAVE,
            OPEN;

        }
    }
}

