/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.snapshot;

import heronarts.lx.LX;
import heronarts.lx.LXLoopTask;
import heronarts.lx.clip.LXClip;
import heronarts.lx.command.LXCommand;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.snapshot.LXSnapshot;
import heronarts.lx.utils.LXUtils;
import java.util.List;

public class LXClipSnapshot
extends LXSnapshot
implements LXOscComponent,
LXLoopTask {
    private boolean inTransition = false;
    private double transitionProgress = 0.0;
    public final LXClip clip;

    public LXClipSnapshot(LX lx, LXClip clip) {
        super(lx, clip.bus);
        this.clip = clip;
    }

    public LXClip getClip() {
        return this.clip;
    }

    public LXBus getBus() {
        return this.clip.bus;
    }

    @Override
    public LXChannel getClipChannel() {
        return this.clip.bus instanceof LXChannel ? (LXChannel)this.clip.bus : null;
    }

    @Override
    protected void initializeViews() {
        this.initializeClipBus(this.clip.bus);
    }

    public boolean isInTransition() {
        return this.inTransition;
    }

    public double getTransitionProgress() {
        return this.transitionProgress;
    }

    public void getCommands(List<LXCommand> commands) {
        for (LXSnapshot.View view : this.views) {
            commands.add(view.getCommand());
        }
    }

    public BooleanParameter getSnapshotTransitionEnabledParameter() {
        return this.clip.customSnapshotTransition.isOn() ? this.clip.snapshotTransitionEnabled : this.lx.engine.clips.snapshotTransitionEnabled;
    }

    public BoundedParameter getSnapshotTransitionTimeParameter() {
        return this.clip.customSnapshotTransition.isOn() ? this.clip.snapshot.transitionTimeSecs : this.lx.engine.clips.snapshotTransitionTimeSecs;
    }

    public void recallImmediate() {
        this.recallImmediate(null);
    }

    public void recallImmediate(List<LXCommand> commands) {
        if (this.isInTransition()) {
            this.stopTransition();
        }
        this._recall(false, commands);
    }

    public void recall() {
        this._recall(this.getSnapshotTransitionEnabledParameter().isOn(), null);
    }

    private void _recall(boolean transitionEnabled, List<LXCommand> commands) {
        for (LXSnapshot.View view : this.views) {
            if (commands != null) {
                commands.add(view.getCommand());
            }
            if (transitionEnabled) {
                view.startTransition();
                continue;
            }
            view.recall();
        }
        if (transitionEnabled) {
            this.inTransition = true;
            this.transitionProgress = 0.0;
        }
    }

    @Override
    public void loop(double deltaMs) {
        if (this.inTransition) {
            BoundedParameter transitionTimeSecs = this.clip.customSnapshotTransition.isOn() ? this.clip.snapshot.transitionTimeSecs : this.lx.engine.clips.snapshotTransitionTimeSecs;
            double increment = deltaMs / (1000.0 * transitionTimeSecs.getValue());
            this.transitionProgress = LXUtils.min(1.0, this.transitionProgress + increment);
            if (this.transitionProgress == 1.0) {
                for (LXSnapshot.View view : this.views) {
                    view.finishTransition();
                }
                this.inTransition = false;
            } else {
                for (LXSnapshot.View view : this.views) {
                    view.interpolate(this.transitionProgress);
                }
            }
        }
    }

    public void stopTransition() {
        this.inTransition = false;
    }

    @Override
    public String getPath() {
        return "snapshot";
    }
}

