/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.snapshot;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.snapshot.LXSnapshot;

public class LXGlobalSnapshot
extends LXSnapshot
implements LXComponent.Renamable,
LXOscComponent {
    private int index = -1;
    public final TriggerParameter recall = new TriggerParameter("Recall", () -> this.lx.engine.snapshots.recall(this)).setDescription("Restores the values of this snapshot");
    public final BooleanParameter autoCycleEligible = new BooleanParameter("Cycle", true).setDescription("Whether the snapshot is eligible for auto-cycle");
    public final BoundedParameter cycleTimeSecs = new BoundedParameter("Cycle Time", 60.0, 0.1, 86400.0).setDescription("Sets the number of seconds after which the engine cycles to the next snapshot").setUnits(LXParameter.Units.SECONDS);
    public final BooleanParameter hasCustomCycleTime = new BooleanParameter("Custom Cycle", false).setDescription("When enabled, this snapshot uses its own custom duration rather than the default cycle time");
    public final BooleanParameter hasCustomTransitionTime = new BooleanParameter("Custom Transition", false).setDescription("When enabled, this snapshot uses its own custom transition rather than the default transition time");

    public LXGlobalSnapshot(LX lx) {
        super(lx, (LXComponent)null);
        this.setParent(lx.engine.snapshots);
        this.addParameter("recall", this.recall);
        this.addParameter("autoCycleEligible", this.autoCycleEligible);
        this.addParameter("hasCustomCycleTime", this.hasCustomCycleTime);
        this.addParameter("cycleTimeSecs", this.cycleTimeSecs);
        this.addParameter("hasCustomTransitionTime", this.hasCustomTransitionTime);
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPath() {
        return "snapshot/" + (this.index + 1);
    }

    @Override
    public String getOscPath() {
        String path = super.getOscPath();
        if (path != null) {
            return path;
        }
        return this.getOscLabel();
    }

    @Override
    public String getOscAddress() {
        LXComponent parent = this.getParent();
        if (parent instanceof LXOscComponent) {
            return parent.getOscAddress() + "/" + this.getOscPath();
        }
        return null;
    }

    @Override
    public void initializeViews() {
        this.addParameterView(LXSnapshot.ViewScope.OUTPUT, this.lx.engine.output.brightness);
        this.addParameterView(LXSnapshot.ViewScope.MIXER, this.lx.engine.mixer.crossfader);
        for (LXAbstractChannel bus : this.lx.engine.mixer.channels) {
            this.initializeGlobalBus(bus);
        }
        this.initializeGlobalBus(this.lx.engine.mixer.masterBus);
        for (LXModulator modulator : this.lx.engine.modulation.getModulators()) {
            for (LXParameter p : modulator.getParameters()) {
                this.addParameterView(LXSnapshot.ViewScope.MODULATION, p);
            }
        }
        for (LXComponent global : this.lx.engine.snapshots.globalComponents) {
            for (LXParameter p : global.getParameters()) {
                if (p == global.label) continue;
                this.addParameterView(LXSnapshot.ViewScope.GLOBAL, p);
            }
        }
    }
}

