/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.snapshot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.LXLayer;
import heronarts.lx.LXLayeredComponent;
import heronarts.lx.LXPath;
import heronarts.lx.LXSerializable;
import heronarts.lx.command.LXCommand;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXMasterBus;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.snapshot.LXClipSnapshot;
import heronarts.lx.snapshot.LXGlobalSnapshot;
import heronarts.lx.snapshot.LXSnapshotEngine;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class LXSnapshot
extends LXComponent {
    private final List<View> mutableViews = new ArrayList<View>();
    public final List<View> views = Collections.unmodifiableList(this.mutableViews);
    private final LXComponent snapshotParameterScope;
    private boolean isInitialized = false;
    public final BoundedParameter transitionTimeSecs = new BoundedParameter("Transition Time", 1.0, 0.1, 180.0).setDescription("Sets the duration of interpolated transitions between snapshots").setUnits(LXParameter.Units.SECONDS);
    private static final String KEY_VIEWS = "views";

    protected LXSnapshot(LX lx, LXComponent snapshotParameterScope) {
        super(lx, "Snapshot");
        this.snapshotParameterScope = snapshotParameterScope;
        this.addParameter("transitionTimeSecs", this.transitionTimeSecs);
    }

    public boolean isGlobalSnapshot() {
        return this instanceof LXGlobalSnapshot;
    }

    public boolean isClipSnapshot() {
        return this instanceof LXClipSnapshot;
    }

    public LXChannel getClipChannel() {
        return null;
    }

    public final void initialize() {
        if (!this.isInitialized) {
            this.initializeViews();
            this.isInitialized = true;
        }
    }

    public void update() {
        this.clearViews();
        this.initializeViews();
        this.isInitialized = true;
    }

    protected abstract void initializeViews();

    protected void initializeGlobalBus(LXBus bus) {
        if (bus instanceof LXMasterBus) {
            this.addParameterView(ViewScope.MASTER, bus.fader);
        }
        if (bus instanceof LXAbstractChannel) {
            LXAbstractChannel channel = (LXAbstractChannel)bus;
            this.addView(new ChannelFaderView(channel));
            this.addParameterView(ViewScope.MIXER, channel.crossfadeGroup);
        }
        if (bus instanceof LXChannel) {
            this.addParameterView(ViewScope.PATTERNS, ((LXChannel)bus).compositeMode);
        }
        this.initializeClipBus(bus);
    }

    protected void initializeClipBus(LXBus bus) {
        if (bus instanceof LXChannel) {
            LXChannel channel = (LXChannel)bus;
            if (channel.compositeMode.getEnum() == LXChannel.CompositeMode.PLAYLIST) {
                LXPattern pattern = channel.getActivePattern();
                if (pattern != null) {
                    this.addView(new ActivePatternView(channel));
                    this.addPatternView(pattern);
                }
            } else {
                for (LXPattern pattern : channel.patterns) {
                    if (pattern.enabled.isOn()) {
                        this.addParameterView(ViewScope.PATTERNS, pattern.enabled);
                        this.addPatternView(pattern);
                        continue;
                    }
                    this.addParameterView(ViewScope.PATTERNS, pattern.enabled);
                }
            }
        }
        for (LXEffect effect : bus.effects) {
            this.addEffectView(effect);
        }
    }

    protected void addEffectView(LXEffect effect) {
        if (effect.enabled.isOn()) {
            this.addDeviceView(ViewScope.EFFECTS, effect);
        } else {
            this.addParameterView(ViewScope.EFFECTS, effect.enabled);
        }
    }

    protected void addPatternView(LXPattern pattern) {
        this.addDeviceView(ViewScope.PATTERNS, pattern);
        for (LXEffect effect : pattern.effects) {
            this.addEffectView(effect);
        }
    }

    protected void addDeviceView(ViewScope scope, LXDeviceComponent device) {
        for (LXParameter p : device.getParameters()) {
            LXParameter check;
            AggregateParameter ap = p.getParentParameter();
            LXParameter lXParameter = check = ap != null ? ap : p;
            if (!device.isSnapshotControl(check)) continue;
            this.addParameterView(scope, p);
        }
        for (LXLayer layer : device.getLayers()) {
            this.addLayeredView(scope, layer);
        }
        for (LXComponent child : device.automationChildren.values()) {
            this.addDeviceChildView(scope, child);
        }
    }

    protected void addLayeredView(ViewScope scope, LXLayeredComponent component) {
        for (LXParameter p : component.getParameters()) {
            if (p == component.label) continue;
            this.addParameterView(scope, p);
        }
        for (LXLayer layer : component.getLayers()) {
            this.addLayeredView(scope, layer);
        }
    }

    protected void addDeviceChildView(ViewScope scope, LXComponent component) {
        for (LXParameter p : component.getParameters()) {
            if (p == component.label) continue;
            this.addParameterView(scope, p);
        }
    }

    protected void addParameterView(ViewScope scope, LXParameter p) {
        if (p instanceof AggregateParameter) {
            return;
        }
        this.addView(new ParameterView(scope, p));
    }

    public View addView(JsonObject viewObj) {
        ViewType type = ViewType.valueOf(viewObj.get("type").getAsString());
        View view = null;
        switch (type) {
            case PARAMETER: {
                view = new ParameterView(this.getLX(), viewObj);
                break;
            }
            case ACTIVE_PATTERN: {
                view = new ActivePatternView(this.getLX(), viewObj);
                break;
            }
            case CHANNEL_FADER: {
                view = new ChannelFaderView(this.getLX(), viewObj);
            }
        }
        if (view == null) {
            LX.error("Invalid serialized LXSnapshot.View type: " + viewObj.get("type").getAsString());
        } else {
            this.addView(view);
        }
        return view;
    }

    public void addView(View view) {
        Objects.requireNonNull(view, "May not LXShapshot.addView(null)");
        if (this.views.contains(view)) {
            throw new IllegalStateException("May not add same view instance twice: " + String.valueOf(this) + " " + String.valueOf(view));
        }
        this.mutableViews.add(view);
    }

    public void removeView(View view) {
        if (!this.views.contains(view)) {
            throw new IllegalStateException("Cannot remove View that doesn't belong to snapshot: " + String.valueOf(view));
        }
        this.mutableViews.remove(view);
        view.dispose();
    }

    private void clearViews() {
        int i = this.views.size() - 1;
        while (i >= 0) {
            this.removeView(this.views.get(i));
            --i;
        }
    }

    boolean hasChannelFaderView(LXAbstractChannel channel) {
        for (View view : this.views) {
            if (!(view instanceof ChannelFaderView) || ((ChannelFaderView)view).channel != channel) continue;
            return true;
        }
        return false;
    }

    ChannelFaderView getMissingChannelView(LXAbstractChannel channel) {
        return new ChannelFaderView(channel, false, 0.0);
    }

    @Override
    public void dispose() {
        for (View view : this.views) {
            view.dispose();
        }
        this.mutableViews.clear();
        super.dispose();
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_VIEWS, (JsonElement)LXSerializable.Utils.toArray(lx, this.views));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        this.clearViews();
        if (obj.has(KEY_VIEWS)) {
            JsonArray viewsArray = obj.getAsJsonArray(KEY_VIEWS);
            for (JsonElement viewElement : viewsArray) {
                try {
                    this.addView(viewElement.getAsJsonObject());
                }
                catch (Exception x) {
                    LX.error(x, "Invalid view in snapshot: " + viewElement.toString());
                }
            }
        }
        this.isInitialized = true;
    }

    public class ActivePatternView
    extends View {
        private final LXChannel channel;
        private final LXPattern pattern;
        private static final String KEY_CHANNEL_PATH = "channelPath";
        private static final String KEY_ACTIVE_PATTERN_INDEX = "activePatternIndex";

        private ActivePatternView(LXChannel channel) {
            super(ViewScope.PATTERNS, ViewType.ACTIVE_PATTERN);
            this.channel = channel;
            this.pattern = channel.getActivePattern();
        }

        private ActivePatternView(LX lx, JsonObject obj) {
            super(lx, obj);
            String channelPath = "";
            if (LXSnapshot.this.isClipSnapshot()) {
                this.channel = LXSnapshot.this.getClipChannel();
            } else {
                channelPath = obj.get(KEY_CHANNEL_PATH).getAsString();
                this.channel = (LXChannel)LXPath.get(lx, channelPath);
            }
            if (this.channel == null) {
                throw new IllegalStateException("Cannot restore ActivePatternView for non-existent channel: " + channelPath);
            }
            int patternIndex = obj.get(KEY_ACTIVE_PATTERN_INDEX).getAsInt();
            this.pattern = this.channel.patterns.get(patternIndex);
            if (this.pattern == null) {
                throw new IllegalStateException("Cannot restore ActivePatternView for missing pattern index: " + channelPath + "/pattern/" + patternIndex);
            }
        }

        @Override
        public LXCommand getCommand() {
            return new LXCommand.Channel.GoPattern(this.channel, this.pattern);
        }

        @Override
        protected boolean isDependentOf(LXComponent component) {
            return component.contains(this.pattern);
        }

        @Override
        protected void recall() {
            this.channel.goPattern(this.pattern);
        }

        @Override
        public void save(LX lx, JsonObject obj) {
            super.save(lx, obj);
            if (LXSnapshot.this.isGlobalSnapshot()) {
                obj.addProperty(KEY_CHANNEL_PATH, this.channel.getCanonicalPath(LXSnapshot.this.snapshotParameterScope));
            }
            obj.addProperty(KEY_ACTIVE_PATTERN_INDEX, (Number)this.pattern.getIndex());
        }
    }

    public class ChannelFaderView
    extends View {
        private final LXAbstractChannel channel;
        private final boolean enabled;
        private final double fader;
        private double fromFader;
        private double toFader;
        private boolean wasEnabled;
        private static final String KEY_CHANNEL_PATH = "channelPath";
        private static final String KEY_CHANNEL_ENABLED = "channelEnabled";
        private static final String KEY_CHANNEL_FADER = "channelFader";

        private ChannelFaderView(LXAbstractChannel channel) {
            this(channel, channel.enabled.isOn(), channel.fader.getBaseValue());
        }

        protected ChannelFaderView(LXAbstractChannel channel, boolean enabled, double fader) {
            super(ViewScope.MIXER, ViewType.CHANNEL_FADER);
            this.channel = channel;
            this.enabled = enabled;
            this.fader = fader;
        }

        private ChannelFaderView(LX lx, JsonObject obj) {
            super(ViewScope.MIXER, ViewType.CHANNEL_FADER);
            String channelPath = "";
            if (LXSnapshot.this.isClipSnapshot()) {
                this.channel = LXSnapshot.this.getClipChannel();
            } else {
                channelPath = obj.get(KEY_CHANNEL_PATH).getAsString();
                this.channel = (LXAbstractChannel)LXPath.get(lx, channelPath);
            }
            if (this.channel == null) {
                throw new IllegalStateException("Cannot create ChannelFaderView of non-existent channel: " + channelPath);
            }
            this.enabled = obj.get(KEY_CHANNEL_ENABLED).getAsBoolean();
            this.fader = obj.get(KEY_CHANNEL_FADER).getAsDouble();
        }

        @Override
        public LXCommand getCommand() {
            return new LXCommand.Channel.SetFader(this.channel, this.enabled, this.fader);
        }

        @Override
        protected boolean isDependentOf(LXComponent component) {
            return component.contains(this.channel);
        }

        @Override
        protected void recall() {
            this.channel.enabled.setValue(this.enabled);
            this.channel.fader.setValue(this.fader);
        }

        @Override
        protected void startTransition() {
            this.wasEnabled = this.channel.enabled.isOn();
            if (this.wasEnabled != this.enabled && ((LXSnapshot)LXSnapshot.this).lx.engine.snapshots.channelMode.getEnum() == LXSnapshotEngine.ChannelMode.FADE) {
                if (this.enabled) {
                    this.fromFader = 0.0;
                    this.channel.fader.setValue(0.0);
                    this.toFader = this.fader;
                    this.channel.enabled.setValue(true);
                } else {
                    this.fromFader = this.channel.fader.getBaseValue();
                    this.toFader = 0.0;
                }
            } else {
                this.channel.enabled.setValue(this.enabled);
                this.fromFader = this.channel.fader.getBaseValue();
                this.toFader = this.fader;
            }
        }

        @Override
        protected void interpolate(double amount) {
            this.channel.fader.setValue(LXUtils.lerp(this.fromFader, this.toFader, amount));
        }

        @Override
        protected void finishTransition() {
            this.recall();
        }

        @Override
        public void save(LX lx, JsonObject obj) {
            super.save(lx, obj);
            if (LXSnapshot.this.isGlobalSnapshot()) {
                obj.addProperty(KEY_CHANNEL_PATH, this.channel.getCanonicalPath());
            }
            obj.addProperty(KEY_CHANNEL_ENABLED, Boolean.valueOf(this.enabled));
            obj.addProperty(KEY_CHANNEL_FADER, (Number)this.fader);
        }
    }

    public class ParameterView
    extends View {
        private final LXComponent component;
        private final LXParameter parameter;
        private final double value;
        private final int intValue;
        private final String stringValue;
        private final double normalizedValue;
        private double fromNormalized;
        private double fromValue;
        private int fromInt;
        private static final String KEY_PARAMETER_PATH = "parameterPath";
        private static final String KEY_VALUE = "value";
        private static final String KEY_NORMALIZED_VALUE = "normalizedValue";

        private ParameterView(ViewScope scope, LXParameter parameter) {
            super(scope, ViewType.PARAMETER);
            this.component = parameter.getParent();
            if (this.component == null) {
                throw new IllegalStateException("Cannot store a snapshot view of a parameter with no parent");
            }
            if (parameter instanceof AggregateParameter) {
                throw new IllegalStateException("Cannot store a snapshot view of an AggregateParameter");
            }
            this.parameter = parameter;
            this.value = this.parameter.getBaseValue();
            if (parameter instanceof DiscreteParameter) {
                this.intValue = ((DiscreteParameter)parameter).getBaseValuei();
                this.stringValue = null;
            } else if (parameter instanceof StringParameter) {
                this.intValue = 0;
                this.stringValue = ((StringParameter)parameter).getString();
            } else {
                this.intValue = 0;
                this.stringValue = null;
            }
            this.normalizedValue = parameter instanceof LXNormalizedParameter ? ((LXNormalizedParameter)parameter).getBaseNormalized() : 0.0;
        }

        private ParameterView(LX lx, JsonObject obj) {
            super(lx, obj);
            String path = obj.get(KEY_PARAMETER_PATH).getAsString();
            this.parameter = LXSnapshot.this.isGlobalSnapshot() || path.startsWith("/lx/") ? (LXParameter)LXPath.get(lx, path) : (LXParameter)LXPath.get(LXSnapshot.this.snapshotParameterScope, path);
            if (this.parameter == null) {
                throw new IllegalStateException("Cannot create snapshot view of non-existent parameter: " + path);
            }
            this.component = this.parameter.getParent();
            if (this.component == null) {
                throw new IllegalStateException("Cannot restore a snapshot view of a parameter with no parent");
            }
            if (this.parameter instanceof AggregateParameter) {
                throw new IllegalStateException("Cannot restore a snapshot view of an AggregateParameter");
            }
            if (this.parameter instanceof DiscreteParameter) {
                this.intValue = obj.get(KEY_VALUE).getAsInt();
                this.value = this.intValue;
                this.stringValue = null;
                obj.addProperty(KEY_VALUE, (Number)this.intValue);
            } else if (this.parameter instanceof StringParameter) {
                JsonElement value = obj.get(KEY_VALUE);
                this.stringValue = value instanceof JsonNull ? null : value.getAsString();
                this.intValue = 0;
                this.value = 0.0;
            } else {
                this.value = obj.get(KEY_VALUE).getAsDouble();
                this.intValue = 0;
                this.stringValue = null;
            }
            this.normalizedValue = obj.get(KEY_NORMALIZED_VALUE).getAsDouble();
        }

        @Override
        public LXCommand getCommand() {
            if (this.parameter instanceof DiscreteParameter) {
                return new LXCommand.Parameter.SetValue((DiscreteParameter)this.parameter, this.intValue);
            }
            if (this.parameter instanceof StringParameter) {
                return new LXCommand.Parameter.SetString((StringParameter)this.parameter, this.stringValue);
            }
            return new LXCommand.Parameter.SetValue(this.parameter, this.value);
        }

        public LXParameter getParameter() {
            return this.parameter;
        }

        @Override
        protected boolean isDependentOf(LXComponent component) {
            return component.contains(this.parameter);
        }

        @Override
        protected void recall() {
            if (this.parameter instanceof DiscreteParameter) {
                ((DiscreteParameter)this.parameter).setValue(this.intValue);
            } else if (this.parameter instanceof StringParameter) {
                ((StringParameter)this.parameter).setValue(this.stringValue);
            } else {
                this.parameter.setValue(this.value);
            }
        }

        @Override
        protected void startTransition() {
            if (this.parameter instanceof StringParameter) {
                this.recall();
            } else if (this.parameter instanceof LXNormalizedParameter) {
                this.fromNormalized = ((LXNormalizedParameter)this.parameter).getBaseNormalized();
            } else if (this.parameter instanceof DiscreteParameter) {
                this.fromInt = ((DiscreteParameter)this.parameter).getBaseValuei();
            } else {
                this.fromValue = this.parameter.getValue();
            }
        }

        @Override
        protected void interpolate(double amount) {
            if (!(this.parameter instanceof StringParameter)) {
                if (this.parameter instanceof LXNormalizedParameter) {
                    ((LXNormalizedParameter)this.parameter).setNormalized(LXUtils.lerp(this.fromNormalized, this.normalizedValue, amount));
                } else if (this.parameter instanceof DiscreteParameter) {
                    ((DiscreteParameter)this.parameter).setValue(LXUtils.lerpi(this.fromInt, this.intValue, (float)amount));
                } else {
                    this.parameter.setValue(LXUtils.lerp(this.fromValue, this.value, amount));
                }
            }
        }

        @Override
        protected void finishTransition() {
            this.recall();
        }

        @Override
        public void save(LX lx, JsonObject obj) {
            super.save(lx, obj);
            obj.addProperty(KEY_PARAMETER_PATH, this.parameter.getCanonicalPath(LXSnapshot.this.snapshotParameterScope));
            if (this.parameter instanceof DiscreteParameter) {
                obj.addProperty(KEY_VALUE, (Number)this.intValue);
            } else if (this.parameter instanceof StringParameter) {
                obj.addProperty(KEY_VALUE, this.stringValue);
            } else {
                obj.addProperty(KEY_VALUE, (Number)this.value);
            }
            obj.addProperty(KEY_NORMALIZED_VALUE, (Number)this.normalizedValue);
        }
    }

    public abstract class View
    implements LXSerializable {
        public final ViewScope scope;
        private final ViewType type;
        boolean activeFlag = false;
        public final BooleanParameter enabled = new BooleanParameter("Enabled", true).setMappable(false).setDescription("Whether this view is enabled in the snapshot");
        private static final String KEY_SCOPE = "scope";
        private static final String KEY_TYPE = "type";
        private static final String KEY_ENABLED = "enabled";

        private View(ViewScope scope, ViewType type) {
            this.scope = scope;
            this.type = type;
        }

        private View(LX lx, JsonObject obj) {
            LXSerializable.Utils.loadBoolean(this.enabled, obj, KEY_ENABLED);
            this.scope = ViewScope.valueOf(obj.get(KEY_SCOPE).getAsString());
            this.type = ViewType.valueOf(obj.get(KEY_TYPE).getAsString());
        }

        public LXSnapshot getSnapshot() {
            return LXSnapshot.this;
        }

        public abstract LXCommand getCommand();

        protected abstract boolean isDependentOf(LXComponent var1);

        protected abstract void recall();

        protected void startTransition() {
            this.recall();
        }

        protected void interpolate(double amount) {
        }

        protected void finishTransition() {
        }

        @Override
        public void save(LX lx, JsonObject obj) {
            obj.addProperty(KEY_SCOPE, this.scope.name());
            obj.addProperty(KEY_TYPE, this.type.name());
            obj.addProperty(KEY_ENABLED, Boolean.valueOf(this.enabled.isOn()));
        }

        @Override
        public void load(LX lx, JsonObject obj) {
            throw new UnsupportedOperationException("LXSnapshot.View classes do not support loading");
        }

        public void dispose() {
        }
    }

    public static enum ViewScope {
        MIXER,
        PATTERNS,
        EFFECTS,
        OUTPUT,
        MODULATION,
        GLOBAL,
        MASTER;

    }

    public static enum ViewType {
        PARAMETER,
        CHANNEL_FADER,
        ACTIVE_PATTERN;

    }
}

