/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.structure.LXBasicFixture;
import heronarts.lx.transform.LXMatrix;
import java.util.List;
import java.util.Map;

@LXCategory(value="Core")
public class ArcFixture
extends LXBasicFixture {
    public static final int MAX_POINTS = 4096;
    public final DiscreteParameter numPoints = new DiscreteParameter("Num", 10, 1, 4097).setUnits(LXParameter.Units.INTEGER).setDescription("Number of points in the arc");
    public final BoundedParameter radius = new BoundedParameter("Radius", 100.0, 0.0, 1000000.0).setDescription("Radius of the arc");
    public final BoundedParameter degrees = new BoundedParameter("Degrees", 90.0, 0.0, 360.0).setUnits(LXParameter.Units.DEGREES).setDescription("Number of degrees the arc covers");
    public final EnumParameter<PositionMode> positionMode = new EnumParameter<PositionMode>("Mode", PositionMode.ORIGIN).setDescription("Whether the arc is positioned by its starting point or center");

    public ArcFixture(LX lx) {
        super(lx, "Arc");
        this.addMetricsParameter("numPoints", this.numPoints);
        this.addGeometryParameter("radius", this.radius);
        this.addGeometryParameter("degrees", this.degrees);
        this.addGeometryParameter("positionMode", this.positionMode);
    }

    @Override
    protected void computePointGeometry(LXMatrix transform, List<LXPoint> points) {
        float radius = this.radius.getValuef();
        float degrees = this.degrees.getValuef();
        float rotation = (float)((double)(degrees / (float)(this.points.size() - 1)) * Math.PI / 180.0);
        switch (this.positionMode.getEnum()) {
            case CENTER: {
                for (LXPoint p : this.points) {
                    transform.translateY(-radius);
                    p.set(transform);
                    transform.translateY(radius);
                    transform.rotateZ(rotation);
                }
                break;
            }
            case ORIGIN: {
                for (LXPoint p : this.points) {
                    p.set(transform);
                    transform.translateY(radius);
                    transform.rotateZ(rotation);
                    transform.translateY(-radius);
                }
                break;
            }
        }
    }

    @Override
    protected int size() {
        return this.numPoints.getValuei();
    }

    @Override
    protected String[] getDefaultTags() {
        return new String[]{"strip", "arc"};
    }

    @Override
    public void addModelMetaData(Map<String, String> metaData) {
        metaData.put("numPoints", String.valueOf(this.numPoints.getValuei()));
        metaData.put("radius", String.valueOf(this.radius.getValue()));
        metaData.put("degrees", String.valueOf(this.degrees.getValue()));
        metaData.put("positionMode", this.positionMode.getEnum().toString());
    }

    public static enum PositionMode {
        ORIGIN("Origin"),
        CENTER("Center");

        private final String str;

        private PositionMode(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

