/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.output.KinetDatagram;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXOutput;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.structure.LXFixtureContainer;
import heronarts.lx.structure.LXStructure;
import heronarts.lx.transform.LXMatrix;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class LXFixture
extends LXComponent
implements LXFixtureContainer,
LXComponent.Renamable {
    public static final int DEFAULT_OUTPUT_STRIDE = 1;
    public static final int DEFAULT_OUTPUT_REPEAT = 1;
    public static final double POSITION_RANGE = 1000000.0;
    public final BooleanParameter selected = new BooleanParameter("Selected", false).setDescription("Whether this fixture is selected for editing");
    public final BooleanParameter identify = new BooleanParameter("Identify", false).setDescription("Causes the fixture to flash red for identification");
    public final BoundedParameter x = new BoundedParameter("X", 0.0, -1000000.0, 1000000.0).setDescription("Base X position of the fixture in space");
    public final BoundedParameter y = new BoundedParameter("Y", 0.0, -1000000.0, 1000000.0).setDescription("Base Y position of the fixture in space");
    public final BoundedParameter z = new BoundedParameter("Z", 0.0, -1000000.0, 1000000.0).setDescription("Base Z position of the fixture in space");
    public final BoundedParameter yaw = new BoundedParameter("Yaw", 0.0, -360.0, 360.0).setDescription("Rotation of the fixture about the vertical axis").setUnits(LXParameter.Units.DEGREES);
    public final BoundedParameter pitch = new BoundedParameter("Pitch", 0.0, -360.0, 360.0).setDescription("Rotation of the fixture about the horizontal plane").setUnits(LXParameter.Units.DEGREES);
    public final BoundedParameter roll = new BoundedParameter("Roll", 0.0, -360.0, 360.0).setDescription("Rotation of the fixture about its normal vector").setUnits(LXParameter.Units.DEGREES);
    public final BoundedParameter scale = new BoundedParameter("Scale", 1.0, 0.0, 1000.0).setDescription("Scale the size of the fixture");
    public final BooleanParameter deactivate = new BooleanParameter("Deactivate", false).setDescription("Whether to deactivate this fixture");
    public final BooleanParameter enabled = new BooleanParameter("Enabled", false).setDescription("Whether output to this fixture is enabled");
    public final BoundedParameter brightness = new BoundedParameter("Brightness", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Brightness level of this fixture");
    public final BooleanParameter mute = new BooleanParameter("Mute", false).setDescription("Mutes this fixture, sending all black pixels");
    public final BooleanParameter solo = new BooleanParameter("Solo", false).setDescription("Solos this fixture, no other fixtures illuminated");
    public final StringParameter tags = new StringParameter("Tags", "").setDescription("Tags to be applied to the fixture in model");
    final List<LXFixture> mutableChildren = new ArrayList<LXFixture>();
    protected final List<LXFixture> children = Collections.unmodifiableList(this.mutableChildren);
    private final List<LXOutput> mutableOutputsDirect = new ArrayList<LXOutput>();
    public final List<LXOutput> outputsDirect = Collections.unmodifiableList(this.mutableOutputsDirect);
    protected final List<OutputDefinition> outputDefinitions = new ArrayList<OutputDefinition>();
    private final List<String> mutableTagList = new ArrayList<String>();
    public final List<String> tagList = Collections.unmodifiableList(this.mutableTagList);
    protected final Map<String, String> metaData = new HashMap<String, String>();
    private final List<Transform> transforms = new ArrayList<Transform>();
    private final LXMatrix parentTransformMatrix = new LXMatrix();
    private final LXMatrix geometryMatrix = new LXMatrix();
    private final List<LXPoint> mutablePoints = new ArrayList<LXPoint>();
    private LXModel model = null;
    private LXFixtureContainer container = null;
    public final List<LXPoint> points = Collections.unmodifiableList(this.mutablePoints);
    private final List<LXPoint> modelPoints = new ArrayList<LXPoint>();
    private final Set<LXParameter> metricsParameters = new HashSet<LXParameter>();
    private final Set<LXParameter> geometryParameters = new HashSet<LXParameter>();
    private final Set<LXParameter> outputParameters = new HashSet<LXParameter>();
    private final Set<LXParameter> tagParameters = new HashSet<LXParameter>();
    private int index = 0;
    private int firstPointIndex = -1;
    private boolean isInBuildOutputs = false;
    private final LXMatrix _computePointGeometryMatrix = new LXMatrix();
    protected static final Submodel[] NO_SUBMODELS = new Submodel[0];
    boolean isLoading = false;

    protected LXFixture(LX lx) {
        this(lx, "Fixture");
    }

    protected LXFixture(LX lx, String label) {
        super(lx, label);
        this.tags.setValue(String.join((CharSequence)" ", this.getDefaultTags()));
        this.addGeometryParameter("x", this.x);
        this.addGeometryParameter("y", this.y);
        this.addGeometryParameter("z", this.z);
        this.addGeometryParameter("yaw", this.yaw);
        this.addGeometryParameter("pitch", this.pitch);
        this.addGeometryParameter("roll", this.roll);
        this.addGeometryParameter("scale", this.scale);
        this.addParameter("selected", this.selected);
        this.addParameter("deactivate", this.deactivate);
        this.addParameter("enabled", this.enabled);
        this.addParameter("brightness", this.brightness);
        this.addParameter("identify", this.identify);
        this.addParameter("mute", this.mute);
        this.addParameter("solo", this.solo);
        this.addTagParameter("tags", this.tags);
        this.brightness.setMappable(true);
        this.enabled.setMappable(true);
        this.identify.setMappable(true);
        this.mute.setMappable(true);
        this.solo.setMappable(true);
    }

    @Override
    protected LXComponent addParameter(String path, LXParameter parameter) {
        parameter.setMappable(false);
        return super.addParameter(path, parameter);
    }

    @Override
    public String getPath() {
        return "fixture/" + (this.index + 1);
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    protected int getFirstPointIndex() {
        return this.firstPointIndex;
    }

    private LXFixture getParentFixture() {
        if (this.container instanceof LXFixture) {
            return (LXFixture)this.container;
        }
        return null;
    }

    private void setContainer(LXFixtureContainer container) {
        Objects.requireNonNull(container, "Cannot set null on LXFixture.setContainer");
        if (this.container != null) {
            throw new IllegalStateException("LXFixture already has container set: " + String.valueOf(this) + " " + String.valueOf(this.container));
        }
        this.container = container;
    }

    protected void setStructure(LXStructure structure) {
        this.setParent(structure);
        this.setContainer(structure);
        this.regenerate();
    }

    private void _reindexChildren() {
        int i = 0;
        for (LXFixture child : this.children) {
            child.setIndex(i++);
        }
    }

    protected void addChild(LXFixture child) {
        this.addChild(child, false);
    }

    void addChild(LXFixture child, boolean generateFirst) {
        Objects.requireNonNull(child, "Cannot add null child to LXFixture");
        if (this.children.contains(child)) {
            throw new IllegalStateException("Cannot add duplicate child to LXFixture: " + String.valueOf(child));
        }
        this.mutableChildren.add(child);
        this._reindexChildren();
        child.parentTransformMatrix.set(this.geometryMatrix);
        if (generateFirst) {
            child.regenerate();
        }
        if (child.container != this) {
            child.setParent(this);
            child.setContainer(this);
        }
        if (!generateFirst) {
            child.regenerate();
        }
    }

    protected void removeChild(LXFixture child) {
        if (!this.children.contains(child)) {
            throw new IllegalStateException("Cannot remove non-existent child from LXFixture: " + String.valueOf(this) + " " + String.valueOf(child));
        }
        this.mutableChildren.remove(child);
        this._reindexChildren();
        this.fixtureGenerationChanged(this);
    }

    @Override
    public final void fixtureGenerationChanged(LXFixture fixture) {
        if (this.container != null) {
            this.container.fixtureGenerationChanged(fixture);
        }
    }

    @Override
    public final void fixtureGeometryChanged(LXFixture fixture) {
        if (this.container != null) {
            this.container.fixtureGeometryChanged(fixture);
        }
    }

    @Override
    public final void fixtureOutputChanged(LXFixture fixture) {
        if (this.container != null) {
            this.container.fixtureOutputChanged(fixture);
        }
    }

    @Override
    public final void fixtureTagsChanged(LXFixture fixture) {
        if (this.container != null) {
            this.container.fixtureTagsChanged(fixture);
        }
    }

    protected LXFixture addMetricsParameter(String path, LXParameter parameter) {
        this.addParameter(path, parameter);
        this.metricsParameters.add(parameter);
        return this;
    }

    protected LXFixture addGeometryParameter(String path, LXParameter parameter) {
        this.addParameter(path, parameter);
        this.geometryParameters.add(parameter);
        return this;
    }

    protected LXFixture addOutputParameter(String path, LXParameter parameter) {
        this.addParameter(path, parameter);
        this.outputParameters.add(parameter);
        return this;
    }

    protected LXFixture addTagParameter(String path, LXParameter parameter) {
        this.addParameter(path, parameter);
        this.tagParameters.add(parameter);
        return this;
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (this.container != null && !this.isLoading) {
            if (this.metricsParameters.contains(p)) {
                this.regenerate();
            } else if (this.geometryParameters.contains(p)) {
                this.regenerateGeometry();
            } else if (this.outputParameters.contains(p)) {
                this.regenerateOutputs();
                if (this.enabled.isOn()) {
                    this.container.fixtureOutputChanged(this);
                }
            } else if (this.enabled == p) {
                if (!this.outputDefinitions.isEmpty()) {
                    this.container.fixtureOutputChanged(this);
                }
            } else if (this.deactivate == p) {
                this.container.fixtureGenerationChanged(this);
            } else if (this.tagParameters.contains(p)) {
                this.container.fixtureTagsChanged(this);
            }
        }
        if (p == this.solo && this.solo.isOn()) {
            this.lx.structure.soloFixture(this);
        }
    }

    protected void regenerateOutputs() {
        this.outputDefinitions.clear();
        for (LXOutput output : this.outputsDirect) {
            LX.dispose(output);
        }
        this.mutableOutputsDirect.clear();
        this.isInBuildOutputs = true;
        this.buildOutputs();
        this.isInBuildOutputs = false;
    }

    protected abstract void buildOutputs();

    protected void reindexOutputs() {
    }

    protected void addOutputDefinition(OutputDefinition output) {
        if (!this.isInBuildOutputs) {
            throw new IllegalStateException("May not add outputs from outside buildOutputs() method");
        }
        Objects.requireNonNull(output, "Cannot add null output to LXFixture.addOutputDefinition");
        if (this.outputDefinitions.contains(output)) {
            throw new IllegalStateException("May not add duplicate LXOutput to LXFixture: " + String.valueOf(output));
        }
        this.outputDefinitions.add(output);
    }

    protected void removeOutputDefinition(OutputDefinition output) {
        if (!this.isInBuildOutputs) {
            throw new IllegalStateException("May not remove outputs from outside reindexOutputs() method");
        }
        if (!this.outputDefinitions.contains(output)) {
            throw new IllegalStateException("May not remove non-existent OutputDefinition from LXFixture: " + String.valueOf(output) + " " + String.valueOf(this));
        }
        this.outputDefinitions.remove(output);
    }

    protected void addOutputDirect(LXOutput output) {
        if (!this.isInBuildOutputs) {
            throw new IllegalStateException("May not add outputs from outside buildOutputs() method");
        }
        Objects.requireNonNull(output, "Cannot add null output to LXFixture.addOutputDirect");
        if (this.mutableOutputsDirect.contains(output)) {
            throw new IllegalStateException("May not add duplicate LXOutput to LXFixture: " + String.valueOf(output));
        }
        this.mutableOutputsDirect.add(output);
    }

    protected void removeOutputDirect(LXOutput output) {
        if (!this.isInBuildOutputs) {
            throw new IllegalStateException("May not remove outputs from outside reindexOutputs() method");
        }
        if (!this.mutableOutputsDirect.contains(output)) {
            throw new IllegalStateException("May not remove non-existent LXOutput from LXFixture: " + String.valueOf(output) + " " + String.valueOf(this));
        }
        this.mutableOutputsDirect.remove(output);
    }

    protected void clearTransforms() {
        this.transforms.clear();
    }

    protected void addTransform(Transform transform) {
        this.transforms.add(transform);
    }

    protected final void regenerate() {
        int numPoints = this.size();
        this.mutablePoints.clear();
        int i = 0;
        while (i < numPoints) {
            LXPoint p = this.constructPoint(i);
            p.index = this.firstPointIndex + i;
            this.mutablePoints.add(p);
            ++i;
        }
        this.model = null;
        this.modelPoints.clear();
        this.beforeRegenerate();
        this._regenerateGeometry();
        this.regenerateOutputs();
        if (this.container != null) {
            this.container.fixtureGenerationChanged(this);
        }
    }

    protected void beforeRegenerate() {
    }

    private void regenerateGeometry() {
        this._regenerateGeometry();
        if (this.container != null) {
            this.container.fixtureGeometryChanged(this);
        }
    }

    protected void computeGeometryMatrix(LXMatrix geometryMatrix) {
        geometryMatrix.translate(this.x.getValuef(), this.y.getValuef(), this.z.getValuef());
        geometryMatrix.rotateY(Math.toRadians(this.yaw.getValue()));
        geometryMatrix.rotateX(Math.toRadians(this.pitch.getValue()));
        geometryMatrix.rotateZ(Math.toRadians(this.roll.getValue()));
        geometryMatrix.scale(this.scale.getValuef());
        for (Transform transform : this.transforms) {
            switch (transform.type) {
                case TRANSLATE_X: {
                    geometryMatrix.translateX(transform.value);
                    break;
                }
                case TRANSLATE_Y: {
                    geometryMatrix.translateY(transform.value);
                    break;
                }
                case TRANSLATE_Z: {
                    geometryMatrix.translateZ(transform.value);
                    break;
                }
                case ROTATE_X: {
                    geometryMatrix.rotateX((float)Math.toRadians(transform.value));
                    break;
                }
                case ROTATE_Y: {
                    geometryMatrix.rotateY((float)Math.toRadians(transform.value));
                    break;
                }
                case ROTATE_Z: {
                    geometryMatrix.rotateZ((float)Math.toRadians(transform.value));
                    break;
                }
                case SCALE_X: {
                    geometryMatrix.scaleX(transform.value);
                    break;
                }
                case SCALE_Y: {
                    geometryMatrix.scaleY(transform.value);
                    break;
                }
                case SCALE_Z: {
                    geometryMatrix.scaleZ(transform.value);
                    break;
                }
                case SCALE: {
                    geometryMatrix.scale(transform.value);
                }
            }
        }
    }

    private void _regenerateGeometry() {
        this.geometryMatrix.set(this.parentTransformMatrix);
        this.computeGeometryMatrix(this.geometryMatrix);
        this.regeneratePointGeometry();
        if (this.model != null) {
            this.model.transform.set(this.geometryMatrix);
        }
        if (!this.modelPoints.isEmpty()) {
            int i = 0;
            for (LXPoint p : this.points) {
                this.modelPoints.get(i++).set(p);
            }
        }
    }

    private void regeneratePointGeometry() {
        this._computePointGeometryMatrix.set(this.geometryMatrix);
        this.computePointGeometry(this._computePointGeometryMatrix, this.points);
        for (LXFixture child : this.children) {
            child.parentTransformMatrix.set(this.geometryMatrix);
            child._regenerateGeometry();
        }
    }

    protected abstract void computePointGeometry(LXMatrix var1, List<LXPoint> var2);

    final void reindex(int startIndex) {
        this._reindex(startIndex);
    }

    private boolean _reindex(int startIndex) {
        boolean somethingChanged = false;
        if (this.firstPointIndex != startIndex) {
            somethingChanged = true;
            this.firstPointIndex = startIndex;
            for (LXPoint p : this.points) {
                p.index = startIndex++;
            }
        }
        startIndex = this.firstPointIndex + this.points.size();
        for (LXFixture child : this.children) {
            if (child._reindex(startIndex)) {
                somethingChanged = true;
            }
            startIndex += child.totalSize();
        }
        if (somethingChanged) {
            this.reindexOutputs();
        }
        return somethingChanged;
    }

    final LXModel toModel() {
        this.modelPoints.clear();
        for (LXPoint p : this.points) {
            this.modelPoints.add(this.copyPoint(p));
        }
        ArrayList<LXModel> childModels = new ArrayList<LXModel>();
        for (LXFixture child : this.children) {
            LXModel childModel = child.toModel();
            LXPoint[] lXPointArray = childModel.points;
            int n = childModel.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                this.modelPoints.add(p);
                ++n2;
            }
            childModels.add(childModel);
        }
        Submodel[] submodelArray = this.toSubmodels();
        int n = submodelArray.length;
        int n3 = 0;
        while (n3 < n) {
            Submodel submodel = submodelArray[n3];
            childModels.add(submodel);
            ++n3;
        }
        LXModel model = this.constructModel(this.modelPoints, childModels, this.getModelTags());
        model.transform.set(this.geometryMatrix);
        this.model = model;
        return this.model;
    }

    protected LXModel constructModel(List<LXPoint> modelPoints, List<? extends LXModel> childModels, List<String> tags) {
        return new LXModel(modelPoints, childModels.toArray(new LXModel[0]), this.getMetaData(), tags, this.getModelMeshes());
    }

    protected LXPoint constructPoint(int localIndex) {
        return new LXPoint();
    }

    protected LXPoint copyPoint(LXPoint copy) {
        return new LXPoint(copy);
    }

    private final Map<String, String> getMetaData() {
        this.addModelMetaData(this.metaData);
        return this.metaData;
    }

    protected void addModelMetaData(Map<String, String> metaData) {
    }

    private List<LXPoint> subpoints(int start, int n, int stride) {
        ArrayList<LXPoint> subpoints = new ArrayList<LXPoint>(n);
        int i = 0;
        while (i < n) {
            subpoints.add(this.modelPoints.get(start + i * stride));
            ++i;
        }
        return subpoints;
    }

    protected String[] getDefaultTags() {
        return new String[0];
    }

    protected LXFixture setTags(List<String> tags) {
        this.mutableTagList.clear();
        this.mutableTagList.addAll(tags);
        return this;
    }

    private List<String> getModelTags() {
        int n;
        ArrayList<String> modelTags = new ArrayList<String>(this.tagList);
        boolean hasExtra = false;
        String extraTags = this.tags.getString();
        if (extraTags != null && !extraTags.isEmpty()) {
            String[] tags;
            String[] stringArray = tags = extraTags.trim().replace(',', ' ').split("\\s+");
            int n2 = tags.length;
            n = 0;
            while (n < n2) {
                String tag = stringArray[n];
                if (!(tag = tag.trim()).isEmpty() && LXModel.Tag.isValid(tag)) {
                    hasExtra = true;
                    modelTags.add(tag);
                }
                ++n;
            }
        }
        if (this.tagList.isEmpty() && !hasExtra) {
            String[] stringArray = this.getDefaultTags();
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String tag = stringArray[n3];
                modelTags.add(tag);
                ++n3;
            }
        }
        return modelTags;
    }

    protected List<LXModel.Mesh> getModelMeshes() {
        return null;
    }

    protected Submodel[] toSubmodels() {
        return NO_SUBMODELS;
    }

    protected abstract int size();

    public final int getIndexBufferOffset() {
        return this.firstPointIndex;
    }

    public LXMatrix getGeometryMatrix() {
        return new LXMatrix(this.geometryMatrix);
    }

    public LXMatrix getGeometryMatrix(LXMatrix m) {
        return m.set(this.geometryMatrix);
    }

    public final int totalSize() {
        int sum = this.size();
        for (LXFixture child : this.children) {
            sum += child.totalSize();
        }
        return sum;
    }

    private LXPoint getPoint(int i) {
        if (i < this.points.size()) {
            return this.points.get(i);
        }
        int ci = i - this.points.size();
        for (LXFixture fixture : this.children) {
            int fixtureTotalSize = fixture.totalSize();
            if (ci < fixtureTotalSize) {
                return fixture.getPoint(ci);
            }
            ci -= fixtureTotalSize;
        }
        throw new IllegalArgumentException("Point index " + i + " exceeds fixture bounds: " + String.valueOf(this) + " (" + this.totalSize() + ")");
    }

    @Override
    public void dispose() {
        for (LXFixture child : this.children) {
            LX.dispose(child);
        }
        for (LXOutput output : this.outputsDirect) {
            LX.dispose(output);
        }
        this.mutableOutputsDirect.clear();
        this.outputDefinitions.clear();
        this.transforms.clear();
        super.dispose();
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.isLoading = true;
        super.load(lx, obj);
        this.isLoading = false;
        if (this.container != null) {
            this.regenerate();
        }
    }

    public static class OutputDefinition {
        protected static final float FPS_UNSPECIFIED = 0.0f;
        protected final Protocol protocol;
        protected final Transport transport;
        protected final InetAddress address;
        protected final int port;
        protected final int universe;
        protected final int channel;
        protected final int priority;
        protected final boolean sequenceEnabled;
        protected final KinetDatagram.Version kinetVersion;
        protected final float fps;
        protected final Segment[] segments;

        public OutputDefinition(Protocol protocol, Transport transport, InetAddress address, int port, int universe, int channel, int priority, boolean sequenceEnabled, KinetDatagram.Version kinetVersion, float fps, Segment ... segments) {
            this.protocol = protocol;
            this.transport = transport;
            this.address = address;
            this.port = port;
            this.universe = universe;
            this.channel = channel;
            this.priority = priority;
            this.kinetVersion = kinetVersion;
            this.sequenceEnabled = sequenceEnabled;
            this.fps = fps;
            this.segments = segments;
        }
    }

    public static enum Protocol {
        NONE("None", -1, -1),
        ARTNET("Art-Net", 6454, 512),
        SACN("E1.31 sACN", 5568, 512),
        OPC("OPC", 7890, 65535),
        DDP("DDP", 4048, 65535),
        KINET("KiNET", 6038, 512);

        private final String label;
        public final int defaultPort;
        public final int maxChannels;

        private Protocol(String label, int defaultPort, int maxChannels) {
            this.label = label;
            this.defaultPort = defaultPort;
            this.maxChannels = maxChannels;
        }

        public boolean isDMX() {
            switch (this) {
                case ARTNET: 
                case SACN: 
                case KINET: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.label;
        }
    }

    protected class Segment {
        protected final int[] indexBuffer;
        protected final LXBufferOutput.ByteEncoder byteEncoder;
        protected final int length;
        protected final int outputStride;
        protected final byte[] headerBytes;
        protected final byte[] footerBytes;
        private final FunctionalParameter brightness = new FunctionalParameter(){

            @Override
            public double getValue() {
                double brightness = 1.0;
                LXFixture fixture = LXFixture.this;
                while (fixture != null) {
                    brightness *= fixture.brightness.getValue();
                    fixture = fixture.getParentFixture();
                }
                return brightness;
            }
        };

        protected Segment(int start, int num) {
            this(start, num, 1);
        }

        protected Segment(int start, int num, int stride) {
            this(start, num, stride, 1);
        }

        protected Segment(int start, int num, int stride, int repeat) {
            this(start, num, stride, repeat, false);
        }

        protected Segment(int start, int num, int stride, int repeat, boolean reverse) {
            this(start, num, stride, repeat, reverse, LXBufferOutput.ByteOrder.RGB);
        }

        protected Segment(int start, int num, int stride, int repeat, boolean reverse, LXBufferOutput.ByteEncoder byteEncoder) {
            this(start, num, stride, repeat, 0, 0, reverse, byteEncoder);
        }

        protected Segment(int start, int num, int stride, int repeat, int padPre, int padPost, boolean reverse, LXBufferOutput.ByteEncoder byteEncoder) {
            this(start, num, stride, repeat, padPre, padPost, reverse, byteEncoder, null, null, byteEncoder.getNumBytes());
        }

        protected Segment(int start, int num, int stride, int repeat, int padPre, int padPost, boolean reverse, LXBufferOutput.ByteEncoder byteEncoder, byte[] headerBytes, byte[] footerBytes, int outputStride) {
            this.length = num * repeat + padPre + padPost;
            this.indexBuffer = new int[this.length];
            this.outputStride = outputStride;
            if (reverse) {
                start += stride * (num - 1);
                stride = -stride;
            }
            int i = 0;
            int p = 0;
            while (p < padPre) {
                this.indexBuffer[i++] = -1;
                ++p;
            }
            int s = 0;
            while (s < num) {
                int index = start + s * stride;
                int r = 0;
                while (r < repeat) {
                    this.indexBuffer[i++] = index;
                    ++r;
                }
                ++s;
            }
            p = 0;
            while (p < padPost) {
                this.indexBuffer[i++] = -1;
                ++p;
            }
            this.byteEncoder = byteEncoder;
            this.headerBytes = headerBytes;
            this.footerBytes = footerBytes;
        }

        protected Segment(int[] indexBuffer, LXBufferOutput.ByteEncoder byteEncoder) {
            this.indexBuffer = indexBuffer;
            this.length = indexBuffer.length;
            this.byteEncoder = byteEncoder;
            this.outputStride = byteEncoder.getNumBytes();
            this.headerBytes = null;
            this.footerBytes = null;
        }

        public int getRequiredBytes(int indexLength) {
            int requiredBytes = indexLength * this.outputStride;
            if (indexLength > 0) {
                requiredBytes -= this.outputStride - this.byteEncoder.getNumBytes();
            }
            return requiredBytes;
        }

        protected int[] toIndexBuffer(int start, int len) {
            int[] indices = new int[len];
            int i = 0;
            while (i < len) {
                int localIndex = this.indexBuffer[start + i];
                indices[i] = localIndex == -1 ? -1 : LXFixture.this.getPoint((int)localIndex).index;
                ++i;
            }
            return indices;
        }

        protected LXFixture getFixture() {
            return LXFixture.this;
        }

        protected LXParameter getBrightness() {
            return this.brightness;
        }
    }

    public class Submodel
    extends LXModel {
        public Submodel(int start, int n) {
            this(start, n, 1, new String[0]);
        }

        public Submodel(int start, int n, String ... tags) {
            this(start, n, 1, tags);
        }

        public Submodel(int start, int n, int stride, String ... tags) {
            this(start, n, stride, (Map<String, String>)null, tags);
        }

        public Submodel(int start, int n, Map<String, String> metaData, String ... tags) {
            this(start, n, 1, metaData, tags);
        }

        public Submodel(int start, int n, int stride, Map<String, String> metaData, String ... tags) {
            super(LXFixture.this.subpoints(start, n, stride), metaData, tags);
            this.transform.set(LXFixture.this.geometryMatrix);
        }
    }

    public static class Transform {
        public final Type type;
        public final float value;

        protected Transform(Type type, float value) {
            this.type = type;
            this.value = value;
        }

        public static enum Type {
            TRANSLATE_X,
            TRANSLATE_Y,
            TRANSLATE_Z,
            ROTATE_X,
            ROTATE_Y,
            ROTATE_Z,
            SCALE_X,
            SCALE_Y,
            SCALE_Z,
            SCALE;

        }
    }

    public static enum Transport {
        UDP,
        TCP;

    }
}

