/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import heronarts.lx.LX;
import heronarts.lx.output.ArtNetDatagram;
import heronarts.lx.output.DDPDatagram;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.KinetDatagram;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXOutput;
import heronarts.lx.output.OPCDatagram;
import heronarts.lx.output.OPCSocket;
import heronarts.lx.output.StreamingACNDatagram;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.structure.LXStructure;
import heronarts.lx.utils.LXUtils;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LXStructureOutput
extends LXOutput {
    private final LXStructure structure;
    private final List<LXOutput> generatedOutputs = new ArrayList<LXOutput>();
    private final List<String> outputErrors = new ArrayList<String>();
    private final List<Packet> packets = new ArrayList<Packet>();

    private Packet findPacket(LXFixture.Protocol protocol, LXFixture.Transport transport, InetAddress address, int port, int universe, int priority, boolean sequenceEnabled, KinetDatagram.Version kinetVersion) {
        Packet packet2;
        for (Packet packet2 : this.packets) {
            if (packet2.protocol != protocol || packet2.transport != transport || !packet2.address.equals(address) || packet2.port != port || packet2.universe != universe || packet2.kinetVersion != kinetVersion) continue;
            packet2.priority = LXUtils.max(packet2.priority, priority);
            packet2.sequenceEnabled = packet2.sequenceEnabled || sequenceEnabled;
            return packet2;
        }
        packet2 = new Packet(protocol, transport, address, port, universe, priority, sequenceEnabled, kinetVersion);
        this.packets.add(packet2);
        return packet2;
    }

    LXStructureOutput(LX lx, LXStructure structure) throws SocketException {
        super(lx);
        this.structure = structure;
        this.gammaMode.setValue((Object)LXOutput.GammaMode.DIRECT);
    }

    void clear() {
        this.packets.clear();
        for (LXOutput output : this.generatedOutputs) {
            LX.dispose(output);
        }
        this.generatedOutputs.clear();
        this.outputErrors.clear();
        this.structure.outputError.setValue(null);
    }

    void rebuildOutputs() {
        this.clear();
        for (LXFixture fixture : this.structure.fixtures) {
            this.rebuildFixtureOutputs(fixture);
        }
        for (Packet packet : this.packets) {
            this.generatedOutputs.add(packet.toOutput());
        }
        if (!this.outputErrors.isEmpty()) {
            Object str = "Output errors detected.";
            for (String err : this.outputErrors) {
                str = (String)str + "\n" + err;
            }
            this.structure.outputError.setValue((String)str);
        }
    }

    private void rebuildFixtureOutputs(LXFixture fixture) {
        if (fixture.deactivate.isOn() || !fixture.enabled.isOn()) {
            return;
        }
        for (LXFixture child : fixture.children) {
            this.rebuildFixtureOutputs(child);
        }
        for (LXFixture.OutputDefinition output : fixture.outputDefinitions) {
            try {
                this.rebuildFixtureOutput(fixture, output);
            }
            catch (FixtureOutputException fox) {
                this.outputErrors.add(fox.getMessage());
            }
        }
    }

    private void rebuildFixtureOutput(LXFixture fixture, LXFixture.OutputDefinition output) throws FixtureOutputException {
        if (output.segments.length == 0) {
            return;
        }
        FixtureOutputState state = new FixtureOutputState(output);
        LXFixture.Segment[] segmentArray = output.segments;
        int n = output.segments.length;
        int n2 = 0;
        while (n2 < n) {
            LXFixture.Segment segment = segmentArray[n2];
            state.addStaticBytes(segment.headerBytes);
            state.addDynamicSegment(segment);
            state.addStaticBytes(segment.footerBytes);
            ++n2;
        }
    }

    @Override
    protected void onSend(int[] colors, LXOutput.GammaTable glut, double brightness) {
        for (LXOutput output : this.generatedOutputs) {
            output.setGammaDelegate(this);
            output.send(colors, brightness);
        }
        for (LXFixture fixture : this.structure.fixtures) {
            this.onSendFixture(fixture, colors, brightness);
        }
    }

    private void onSendFixture(LXFixture fixture, int[] colors, double brightness) {
        if (!fixture.deactivate.isOn() && fixture.enabled.isOn()) {
            brightness *= fixture.brightness.getValue();
            for (LXFixture child : fixture.children) {
                this.onSendFixture(child, colors, brightness);
            }
            for (LXOutput output : fixture.outputsDirect) {
                output.setGammaDelegate(this);
                output.send(colors, brightness);
            }
        }
    }

    private static class FixtureOutputException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FixtureOutputException(String str) {
            super(str);
        }
    }

    private class FixtureOutputState {
        private final LXFixture.OutputDefinition output;
        private int universe;
        private int channel;
        private Packet packet;

        private FixtureOutputState(LXFixture.OutputDefinition output) throws FixtureOutputException {
            this.output = output;
            this.universe = output.universe;
            this.channel = output.channel;
            if (this.channel >= output.protocol.maxChannels) {
                throw new FixtureOutputException(output.protocol.toString() + output.address.toString() + " - invalid channel " + this.channel + " > " + output.protocol.maxChannels);
            }
            this.packet = this._findPacket();
        }

        private int availableBytes() {
            return this.output.protocol.maxChannels - this.channel;
        }

        private void checkUniverseOverflow(int overflowChannel, boolean force) throws FixtureOutputException {
            if (force || this.channel >= this.output.protocol.maxChannels) {
                switch (this.output.protocol) {
                    case ARTNET: 
                    case SACN: {
                        if (this.universe < 32768) break;
                        throw new FixtureOutputException(this.output.protocol.toString() + this.output.address.toString() + " - overflow univ " + this.universe);
                    }
                    case KINET: {
                        if (this.universe < 255) break;
                        throw new FixtureOutputException(this.output.protocol.toString() + this.output.address.toString() + " - overflow port" + this.output.universe);
                    }
                    default: {
                        throw new FixtureOutputException(this.output.protocol.toString() + this.output.address.toString() + " - data length overflow");
                    }
                }
                ++this.universe;
                this.channel = overflowChannel;
                this.packet = this._findPacket();
            }
        }

        private void addStaticBytes(byte[] staticBytes) throws FixtureOutputException {
            if (staticBytes == null || staticBytes.length == 0) {
                return;
            }
            this.checkUniverseOverflow(0, false);
            int offset = 0;
            int remaining = staticBytes.length;
            int available = this.availableBytes();
            while (available < remaining) {
                this._addStaticSegment(Arrays.copyOfRange(staticBytes, offset, offset + available));
                offset += available;
                remaining -= available;
                this.checkUniverseOverflow(0, false);
                available = this.availableBytes();
            }
            this._addStaticSegment(Arrays.copyOfRange(staticBytes, offset, offset + remaining));
        }

        private void _addStaticSegment(byte[] staticBytes) {
            this.packet.addStaticSegment(staticBytes, this.channel, this.output.fps);
            this.channel += staticBytes.length;
        }

        private void addDynamicSegment(LXFixture.Segment segment) throws FixtureOutputException {
            if (segment.length == 0) {
                return;
            }
            this.checkUniverseOverflow(0, false);
            int availableBytes = this.availableBytes();
            int chunkStart = 0;
            int chunkLength = segment.length;
            while (availableBytes < segment.getRequiredBytes(chunkLength)) {
                int padding = segment.outputStride - segment.byteEncoder.getNumBytes();
                int chunkLimit = (availableBytes + padding) / segment.outputStride;
                int overflowChannel = 0;
                if (chunkLimit > 0) {
                    this._addDynamicSegment(segment, chunkStart, chunkLimit);
                    if (this.channel > this.output.protocol.maxChannels) {
                        overflowChannel = this.channel % this.output.protocol.maxChannels;
                    }
                    chunkStart += chunkLimit;
                    chunkLength -= chunkLimit;
                }
                this.checkUniverseOverflow(overflowChannel, true);
                availableBytes = this.availableBytes();
            }
            this._addDynamicSegment(segment, chunkStart, chunkLength);
        }

        private void _addDynamicSegment(LXFixture.Segment segment, int chunkStart, int chunkLength) {
            this.packet.addDynamicSegment(segment, this.channel, chunkStart, chunkLength, this.output.fps);
            this.channel += chunkLength * segment.outputStride;
        }

        private Packet _findPacket() {
            return LXStructureOutput.this.findPacket(this.output.protocol, this.output.transport, this.output.address, this.output.port, this.universe, this.output.priority, this.output.sequenceEnabled, this.output.kinetVersion);
        }
    }

    private class Packet {
        private final LXFixture.Protocol protocol;
        private final LXFixture.Transport transport;
        private final InetAddress address;
        private final int port;
        private final int universe;
        private int priority;
        private boolean sequenceEnabled;
        private final KinetDatagram.Version kinetVersion;
        private float fps = 0.0f;
        private final int[] collisionMask;
        private final List<IndexBuffer.Segment> segments = new ArrayList<IndexBuffer.Segment>();

        private Packet(LXFixture.Protocol protocol, LXFixture.Transport transport, InetAddress address, int port, int universe, int priority, boolean sequenceEnabled, KinetDatagram.Version kinetVersion) {
            this.protocol = protocol;
            this.transport = transport;
            this.address = address;
            this.port = port;
            this.universe = universe;
            this.priority = priority;
            this.sequenceEnabled = sequenceEnabled;
            this.kinetVersion = kinetVersion;
            this.collisionMask = new int[(int)Math.ceil(protocol.maxChannels / 32)];
        }

        private void segmentCollision(int collisionStart, int collisionEnd) {
            String err = this.protocol.toString() + this.address.toString() + " - collisions in ";
            switch (this.protocol) {
                case ARTNET: 
                case SACN: {
                    err = err + "univ " + this.universe + (collisionStart == collisionEnd ? " channel " + collisionStart : " channels " + collisionStart + "-" + collisionEnd);
                    break;
                }
                case KINET: {
                    err = err + "port " + this.universe + (collisionStart == collisionEnd ? " channel " + collisionStart : " channels " + collisionStart + "-" + collisionEnd);
                    break;
                }
                case DDP: {
                    err = err + "data offset " + this.universe + (collisionStart == collisionEnd ? " + [" + collisionStart + "]" : " + [" + collisionStart + "-" + collisionEnd + "]");
                    break;
                }
                case OPC: {
                    err = err + "channel " + this.universe + (collisionStart == collisionEnd ? " offset " + collisionStart : " offsets " + collisionStart + "-" + collisionEnd);
                    break;
                }
            }
            LXStructureOutput.this.outputErrors.add(err);
        }

        private void checkSegmentCollisions(IndexBuffer.Segment segment) {
            int minCollision = -1;
            int maxCollision = -1;
            int outputStride = 1;
            int bytesPerIndex = 1;
            if (segment.byteEncoder != null) {
                bytesPerIndex = segment.byteEncoder.getNumBytes();
                outputStride = segment.outputStride;
            }
            if (bytesPerIndex != outputStride) {
                int indexChannel = segment.startChannel;
                int i = 0;
                while (i < segment.indices.length) {
                    int j = 0;
                    while (j < bytesPerIndex) {
                        int channel = indexChannel + j;
                        int bucket = channel / 32;
                        int mask = 1 << channel % 32;
                        if ((this.collisionMask[bucket] & mask) != 0) {
                            if (minCollision < 0) {
                                minCollision = channel;
                            }
                            maxCollision = channel;
                        }
                        int n = bucket;
                        this.collisionMask[n] = this.collisionMask[n] | mask;
                        ++j;
                    }
                    indexChannel += outputStride;
                    ++i;
                }
            } else {
                int requiredChannels = segment.getRequiredChannels();
                int channel = segment.startChannel;
                while (channel < requiredChannels) {
                    int bucket = channel / 32;
                    int mask = 1 << channel % 32;
                    if ((this.collisionMask[bucket] & mask) != 0) {
                        if (minCollision < 0) {
                            minCollision = channel;
                        }
                        maxCollision = channel;
                    }
                    int n = bucket;
                    this.collisionMask[n] = this.collisionMask[n] | mask;
                    ++channel;
                }
            }
            if (minCollision >= 0) {
                this.segmentCollision(minCollision, maxCollision);
            }
        }

        private void addStaticSegment(byte[] staticBytes, int startChannel, float fps) {
            IndexBuffer.Segment segment = new IndexBuffer.Segment(staticBytes, startChannel);
            this.checkSegmentCollisions(segment);
            this.segments.add(segment);
            if (fps > 0.0f && (this.fps == 0.0f || fps < this.fps)) {
                this.fps = fps;
            }
        }

        private void addDynamicSegment(LXFixture.Segment segment, int startChannel, int chunkStart, int chunkLength, float fps) {
            IndexBuffer.Segment indexSegment = new IndexBuffer.Segment(segment.toIndexBuffer(chunkStart, chunkLength), segment.byteEncoder, startChannel, segment.outputStride, segment.getBrightness());
            this.checkSegmentCollisions(indexSegment);
            this.segments.add(indexSegment);
            if (fps > 0.0f && (this.fps == 0.0f || fps < this.fps)) {
                this.fps = fps;
            }
        }

        private IndexBuffer toIndexBuffer() {
            return new IndexBuffer(this.segments);
        }

        private LXOutput toOutput() {
            LXBufferOutput output = null;
            switch (this.protocol) {
                case ARTNET: {
                    output = new ArtNetDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), this.universe).setSequenceEnabled(this.sequenceEnabled);
                    break;
                }
                case SACN: {
                    output = new StreamingACNDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), this.universe).setPriority(this.priority);
                    break;
                }
                case KINET: {
                    output = new KinetDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), this.universe, this.kinetVersion);
                    break;
                }
                case OPC: {
                    if (this.transport == LXFixture.Transport.TCP) {
                        output = new OPCSocket(LXStructureOutput.this.lx, this.toIndexBuffer(), (byte)this.universe);
                        break;
                    }
                    output = new OPCDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), (byte)this.universe);
                    break;
                }
                case DDP: {
                    output = new DDPDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), this.universe);
                    break;
                }
            }
            if (output instanceof LXOutput.InetOutput) {
                ((LXOutput.InetOutput)((Object)output)).setAddress(this.address).setPort(this.port);
            }
            if (output != null && this.fps > 0.0f) {
                output.framesPerSecond.setValue(this.fps);
            }
            return output;
        }
    }
}

