/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.structure.LXBasicFixture;
import heronarts.lx.transform.LXMatrix;
import java.util.List;
import java.util.Map;

@LXCategory(value="Core")
public class StripFixture
extends LXBasicFixture {
    public static final int MAX_POINTS = 4096;
    public final DiscreteParameter numPoints = new DiscreteParameter("Num", 30, 1, 4097).setUnits(LXParameter.Units.INTEGER).setDescription("Number of points in the strip");
    public final BoundedParameter spacing = new BoundedParameter("Spacing", 10.0, 0.0, 1000000.0).setDescription("Spacing between points in the strip");

    public StripFixture(LX lx) {
        super(lx, "Strip");
        this.addMetricsParameter("numPoints", this.numPoints);
        this.addGeometryParameter("spacing", this.spacing);
    }

    @Override
    protected void computePointGeometry(LXMatrix transform, List<LXPoint> points) {
        float spacing = this.spacing.getValuef();
        for (LXPoint p : points) {
            p.set(transform);
            transform.translateX(spacing);
        }
    }

    @Override
    protected int size() {
        return this.numPoints.getValuei();
    }

    @Override
    public String[] getDefaultTags() {
        return new String[]{"strip"};
    }

    @Override
    public void addModelMetaData(Map<String, String> metaData) {
        metaData.put("numPoints", String.valueOf(this.numPoints.getValuei()));
        metaData.put("spacing", String.valueOf(this.spacing.getValue()));
    }
}

