/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure.view;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXPath;
import heronarts.lx.LXSerializable;
import heronarts.lx.model.LXModel;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.structure.view.LXViewDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class LXViewEngine
extends LXComponent
implements LX.Listener {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<LXViewDefinition> mutableViews = new ArrayList<LXViewDefinition>();
    public final List<LXViewDefinition> views = Collections.unmodifiableList(this.mutableViews);
    private final String DEFAULT_VIEW = "Default";
    private LXViewDefinition[] selectorObjectsNormal = new LXViewDefinition[1];
    private String[] selectorOptionsNormal = new String[]{"Default"};
    private LXViewDefinition[] selectorObjectsPriority = new LXViewDefinition[1];
    private String[] selectorOptionsPriority = new String[]{"Default"};
    private final List<Selector> selectorsNormal = new ArrayList<Selector>();
    private final List<Selector> selectorsPriority = new ArrayList<Selector>();
    private static final String KEY_VIEWS = "views";

    public LXViewEngine(LX lx) {
        super(lx);
        this.addArray("view", this.views);
        lx.addListener(this);
    }

    private void rebuildViews() {
        for (LXViewDefinition view : this.views) {
            view.rebuild();
        }
    }

    @Override
    public void modelGenerationChanged(LX lx, LXModel model) {
        this.rebuildViews();
    }

    public LXViewEngine addListener(Listener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXViewEngine.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public LXViewEngine removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LXViewEngine.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXViewDefinition addView() {
        LXViewDefinition view = new LXViewDefinition(this.lx);
        view.label.setValue("View-" + (this.views.size() + 1));
        view.modulationColor.setValue(this.views.size());
        return this.addView(view, -1);
    }

    public LXViewDefinition addView(JsonObject viewObj, int index) {
        LXViewDefinition saved = new LXViewDefinition(this.lx);
        saved.load(this.lx, viewObj);
        return this.addView(saved, index);
    }

    private LXViewDefinition addView(LXViewDefinition view, int index) {
        if (index < 0) {
            this.mutableViews.add(view);
        } else {
            this.mutableViews.add(index, view);
        }
        this._reindexViews();
        for (Listener listener : this.listeners) {
            listener.viewAdded(this, view);
        }
        this.updateSelectors();
        return view;
    }

    public LXViewEngine removeView(LXViewDefinition view) {
        if (!this.views.contains(view)) {
            throw new IllegalStateException("Cannot remove view not in LXViewEngine: " + String.valueOf(view));
        }
        this.mutableViews.remove(view);
        this._reindexViews();
        for (Listener listener : this.listeners) {
            listener.viewRemoved(this, view);
        }
        this.updateSelectors();
        LX.dispose(view);
        return this;
    }

    public LXViewEngine moveView(LXViewDefinition view, int index) {
        if (index < 0 || index >= this.mutableViews.size()) {
            throw new IllegalArgumentException("Cannot move view to invalid index: " + index);
        }
        this.mutableViews.remove(view);
        this.mutableViews.add(index, view);
        this._reindexViews();
        for (Listener listener : this.listeners) {
            listener.viewMoved(this, view);
        }
        this.updateSelectors();
        return this;
    }

    private void _reindexViews() {
        int i = 0;
        for (LXViewDefinition view : this.views) {
            view.setIndex(i++);
        }
    }

    public void reset() {
        int i = this.views.size() - 1;
        while (i >= 0) {
            this.removeView(this.views.get(i));
            --i;
        }
    }

    private void updateSelectors() {
        this.updatePrioritySelectors();
        int numOptions = 1 + this.views.size();
        this.selectorObjectsNormal = new LXViewDefinition[numOptions];
        this.selectorOptionsNormal = new String[numOptions];
        this.selectorObjectsNormal[0] = null;
        this.selectorOptionsNormal[0] = "Default";
        int i = 1;
        Iterator<LXPath> iterator = this.views.iterator();
        while (iterator.hasNext()) {
            LXViewDefinition view;
            this.selectorObjectsNormal[i] = view = iterator.next();
            this.selectorOptionsNormal[i] = view.getLabel();
            ++i;
        }
        for (Selector selector : this.selectorsNormal) {
            LXViewDefinition selected = (LXViewDefinition)selector.getObject();
            selector.setObjects(this.selectorObjectsNormal, this.selectorOptionsNormal);
            if (selected == selector.getObject() || !this.views.contains(selected)) continue;
            selector.setValue(selected);
        }
    }

    private void updatePrioritySelectors() {
        ArrayList<LXViewDefinition> validObjects = new ArrayList<LXViewDefinition>();
        ArrayList<String> validOptions = new ArrayList<String>();
        validObjects.add(null);
        validOptions.add("Default");
        for (LXViewDefinition view : this.views) {
            if (!view.priority.isOn()) continue;
            validObjects.add(view);
            validOptions.add(view.getLabel());
        }
        this.selectorObjectsPriority = validObjects.toArray(new LXViewDefinition[0]);
        this.selectorOptionsPriority = validOptions.toArray(new String[0]);
        for (Selector selector : this.selectorsPriority) {
            LXViewDefinition selected = (LXViewDefinition)selector.getObject();
            selector.setObjects(this.selectorObjectsPriority, this.selectorOptionsPriority);
            if (selected == null || !selected.priority.isOn() || !this.views.contains(selected)) continue;
            selector.setValue(selected);
        }
    }

    void viewRenamed(LXViewDefinition view) {
        if (this.views.contains(view)) {
            this.updateSelectors();
        }
    }

    void viewStateChanged(LXViewDefinition view) {
        for (Selector selector : this.selectorsNormal) {
            if (selector.getObject() != view) continue;
            selector.bang();
        }
        for (Selector selector : this.selectorsPriority) {
            if (selector.getObject() != view) continue;
            selector.bang();
        }
    }

    void viewPriorityChanged(LXViewDefinition view) {
        if (this.views.contains(view)) {
            this.updatePrioritySelectors();
        }
    }

    public SelectorNormal newViewSelector(String label, String description) {
        return (SelectorNormal)new SelectorNormal(label).setDescription(description);
    }

    public SelectorPriority newViewSelectorPriority(String label, String description) {
        return (SelectorPriority)new SelectorPriority(label).setDescription(description);
    }

    @Override
    public void dispose() {
        this.lx.removeListener(this);
        super.dispose();
        this.listeners.forEach(listener -> LX.warning("Stranded LXViewEngine.Listener: " + String.valueOf(listener)));
        this.listeners.clear();
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_VIEWS, (JsonElement)LXSerializable.Utils.toArray(lx, this.views));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.reset();
        this.addViews(lx, obj);
    }

    public List<LXViewDefinition> addViews(LX lx, JsonObject obj) {
        ArrayList<LXViewDefinition> added = new ArrayList<LXViewDefinition>();
        if (obj.has(KEY_VIEWS)) {
            JsonArray viewArr = obj.get(KEY_VIEWS).getAsJsonArray();
            for (JsonElement swatchElem : viewArr) {
                added.add(this.addView(swatchElem.getAsJsonObject(), -1));
            }
        }
        super.load(lx, obj);
        return added;
    }

    public static interface Listener {
        public void viewAdded(LXViewEngine var1, LXViewDefinition var2);

        public void viewRemoved(LXViewEngine var1, LXViewDefinition var2);

        public void viewMoved(LXViewEngine var1, LXViewDefinition var2);
    }

    public static class Selector
    extends ObjectParameter<LXViewDefinition> {
        private Selector(String label, LXViewDefinition[] objects, String[] options) {
            super(label, (T[])objects, options);
        }
    }

    public class SelectorNormal
    extends Selector {
        public SelectorNormal(String label) {
            super(label, LXViewEngine.this.selectorObjectsNormal, LXViewEngine.this.selectorOptionsNormal);
            LXViewEngine.this.selectorsNormal.add(this);
        }

        @Override
        public void dispose() {
            LXViewEngine.this.selectorsNormal.remove(this);
            super.dispose();
        }
    }

    public class SelectorPriority
    extends Selector {
        public SelectorPriority(String label) {
            super(label, LXViewEngine.this.selectorObjectsPriority, LXViewEngine.this.selectorOptionsPriority);
            LXViewEngine.this.selectorsPriority.add(this);
        }

        @Override
        public void dispose() {
            LXViewEngine.this.selectorsPriority.remove(this);
            super.dispose();
        }
    }
}

