/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.transform;

import heronarts.lx.model.LXPoint;
import heronarts.lx.utils.LXUtils;
import java.nio.FloatBuffer;

public class LXMatrix {
    private static final float[] IDENTITY = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public float m11 = 1.0f;
    public float m12 = 0.0f;
    public float m13 = 0.0f;
    public float m14 = 0.0f;
    public float m21 = 0.0f;
    public float m22 = 1.0f;
    public float m23 = 0.0f;
    public float m24 = 0.0f;
    public float m31 = 0.0f;
    public float m32 = 0.0f;
    public float m33 = 1.0f;
    public float m34 = 0.0f;
    public float m41 = 0.0f;
    public float m42 = 0.0f;
    public float m43 = 0.0f;
    public float m44 = 1.0f;

    public LXMatrix() {
    }

    public LXMatrix(float[] m) {
        this.set(m);
    }

    public LXMatrix(float m11, float m12, float m13, float m14, float m21, float m22, float m23, float m24, float m31, float m32, float m33, float m34, float m41, float m42, float m43, float m44) {
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m14 = m14;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m24 = m24;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
        this.m34 = m34;
        this.m41 = m41;
        this.m42 = m42;
        this.m43 = m43;
        this.m44 = m44;
    }

    public LXMatrix(LXMatrix that) {
        this.m11 = that.m11;
        this.m12 = that.m12;
        this.m13 = that.m13;
        this.m14 = that.m14;
        this.m21 = that.m21;
        this.m22 = that.m22;
        this.m23 = that.m23;
        this.m24 = that.m24;
        this.m31 = that.m31;
        this.m32 = that.m32;
        this.m33 = that.m33;
        this.m34 = that.m34;
        this.m41 = that.m41;
        this.m42 = that.m42;
        this.m43 = that.m43;
        this.m44 = that.m44;
    }

    public LXMatrix multiply(LXMatrix m) {
        return this.multiply(m.m11, m.m12, m.m13, m.m14, m.m21, m.m22, m.m23, m.m24, m.m31, m.m32, m.m33, m.m34, m.m41, m.m42, m.m43, m.m44);
    }

    public LXMatrix multiply(float b11, float b12, float b13, float b14, float b21, float b22, float b23, float b24, float b31, float b32, float b33, float b34, float b41, float b42, float b43, float b44) {
        float a11 = this.m11 * b11 + this.m12 * b21 + this.m13 * b31 + this.m14 * b41;
        float a12 = this.m11 * b12 + this.m12 * b22 + this.m13 * b32 + this.m14 * b42;
        float a13 = this.m11 * b13 + this.m12 * b23 + this.m13 * b33 + this.m14 * b43;
        float a14 = this.m11 * b14 + this.m12 * b24 + this.m13 * b34 + this.m14 * b44;
        float a21 = this.m21 * b11 + this.m22 * b21 + this.m23 * b31 + this.m24 * b41;
        float a22 = this.m21 * b12 + this.m22 * b22 + this.m23 * b32 + this.m24 * b42;
        float a23 = this.m21 * b13 + this.m22 * b23 + this.m23 * b33 + this.m24 * b43;
        float a24 = this.m21 * b14 + this.m22 * b24 + this.m23 * b34 + this.m24 * b44;
        float a31 = this.m31 * b11 + this.m32 * b21 + this.m33 * b31 + this.m34 * b41;
        float a32 = this.m31 * b12 + this.m32 * b22 + this.m33 * b32 + this.m34 * b42;
        float a33 = this.m31 * b13 + this.m32 * b23 + this.m33 * b33 + this.m34 * b43;
        float a34 = this.m31 * b14 + this.m32 * b24 + this.m33 * b34 + this.m34 * b44;
        float a41 = this.m41 * b11 + this.m42 * b21 + this.m43 * b31 + this.m44 * b41;
        float a42 = this.m41 * b12 + this.m42 * b22 + this.m43 * b32 + this.m44 * b42;
        float a43 = this.m41 * b13 + this.m42 * b23 + this.m43 * b33 + this.m44 * b43;
        float a44 = this.m41 * b14 + this.m42 * b24 + this.m43 * b34 + this.m44 * b44;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m14 = a14;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.m24 = a24;
        this.m31 = a31;
        this.m32 = a32;
        this.m33 = a33;
        this.m34 = a34;
        this.m41 = a41;
        this.m42 = a42;
        this.m43 = a43;
        this.m44 = a44;
        return this;
    }

    public LXMatrix invert() {
        return this.setInverse(this);
    }

    public LXMatrix setInverse(LXMatrix that) {
        float xx = that.m11;
        float xy = that.m12;
        float xz = that.m13;
        float xw = that.m14;
        float yx = that.m21;
        float yy = that.m22;
        float yz = that.m23;
        float yw = that.m24;
        float zx = that.m31;
        float zy = that.m32;
        float zz = that.m33;
        float zw = that.m34;
        float wx = that.m41;
        float wy = that.m42;
        float wz = that.m43;
        float ww = that.m44;
        float determinant = 0.0f;
        determinant += xx * (yy * (zz * ww - zw * wz) - yz * (zy * ww - zw * wy) + yw * (zy * wz - zz * wy));
        determinant -= xy * (yx * (zz * ww - zw * wz) - yz * (zx * ww - zw * wx) + yw * (zx * wz - zz * wx));
        determinant += xz * (yx * (zy * ww - zw * wy) - yy * (zx * ww - zw * wx) + yw * (zx * wy - zy * wx));
        float inverseDeterminant = 1.0f / (determinant -= xw * (yx * (zy * wz - zz * wy) - yy * (zx * wz - zz * wx) + yz * (zx * wy - zy * wx)));
        return this.set((yy * (zz * ww - wz * zw) - yz * (zy * ww - wy * zw) + yw * (zy * wz - wy * zz)) * inverseDeterminant, -(xy * (zz * ww - wz * zw) - xz * (zy * ww - wy * zw) + xw * (zy * wz - wy * zz)) * inverseDeterminant, (xy * (yz * ww - wz * yw) - xz * (yy * ww - wy * yw) + xw * (yy * wz - wy * yz)) * inverseDeterminant, -(xy * (yz * zw - zz * yw) - xz * (yy * zw - zy * yw) + xw * (yy * zz - zy * yz)) * inverseDeterminant, -(yx * (zz * ww - wz * zw) - yz * (zx * ww - wx * zw) + yw * (zx * wz - wx * zz)) * inverseDeterminant, (xx * (zz * ww - wz * zw) - xz * (zx * ww - wx * zw) + xw * (zx * wz - wx * zz)) * inverseDeterminant, -(xx * (yz * ww - wz * yw) - xz * (yx * ww - wx * yw) + xw * (yx * wz - wx * yz)) * inverseDeterminant, (xx * (yz * zw - zz * yw) - xz * (yx * zw - zx * yw) + xw * (yx * zz - zx * yz)) * inverseDeterminant, (yx * (zy * ww - wy * zw) - yy * (zx * ww - wx * zw) + yw * (zx * wy - wx * zy)) * inverseDeterminant, -(xx * (zy * ww - wy * zw) - xy * (zx * ww - wx * zw) + xw * (zx * wy - wx * zy)) * inverseDeterminant, (xx * (yy * ww - wy * yw) - xy * (yx * ww - wx * yw) + xw * (yx * wy - wx * yy)) * inverseDeterminant, -(xx * (yy * zw - zy * yw) - xy * (yx * zw - zx * yw) + xw * (yx * zy - zx * yy)) * inverseDeterminant, -(yx * (zy * wz - wy * zz) - yy * (zx * wz - wx * zz) + yz * (zx * wy - wx * zy)) * inverseDeterminant, (xx * (zy * wz - wy * zz) - xy * (zx * wz - wx * zz) + xz * (zx * wy - wx * zy)) * inverseDeterminant, -(xx * (yy * wz - wy * yz) - xy * (yx * wz - wx * yz) + xz * (yx * wy - wx * yy)) * inverseDeterminant, (xx * (yy * zz - zy * yz) - xy * (yx * zz - zx * yz) + xz * (yx * zy - zx * yy)) * inverseDeterminant);
    }

    public float x() {
        return this.m14;
    }

    public float y() {
        return this.m24;
    }

    public float z() {
        return this.m34;
    }

    public float x(LXPoint p) {
        return this.m11 * p.x + this.m12 * p.y + this.m13 * p.z + this.m14;
    }

    public float y(LXPoint p) {
        return this.m21 * p.x + this.m22 * p.y + this.m23 * p.z + this.m24;
    }

    public float z(LXPoint p) {
        return this.m31 * p.x + this.m32 * p.y + this.m33 * p.z + this.m34;
    }

    public float xn(LXPoint p) {
        return this.m11 * p.xn + this.m12 * p.yn + this.m13 * p.zn + this.m14;
    }

    public float yn(LXPoint p) {
        return this.m21 * p.xn + this.m22 * p.yn + this.m23 * p.zn + this.m24;
    }

    public float zn(LXPoint p) {
        return this.m31 * p.xn + this.m32 * p.yn + this.m33 * p.zn + this.m34;
    }

    public LXMatrix scale(float sv) {
        return this.scale(sv, sv, sv);
    }

    public LXMatrix scaleX(float sx) {
        return this.scale(sx, 1.0f, 1.0f);
    }

    public LXMatrix scaleY(float sy) {
        return this.scale(1.0f, sy, 1.0f);
    }

    public LXMatrix scaleZ(float sz) {
        return this.scale(1.0f, 1.0f, sz);
    }

    public LXMatrix scale(float sx, float sy, float sz) {
        return this.multiply(sx, 0.0f, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 0.0f, sz, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix translateX(float tx) {
        return this.translate(tx, 0.0f, 0.0f);
    }

    public LXMatrix translateY(float ty) {
        return this.translate(0.0f, ty, 0.0f);
    }

    public LXMatrix translateZ(float tz) {
        return this.translate(0.0f, 0.0f, tz);
    }

    public LXMatrix translate(float tx, float ty, float tz) {
        return this.multiply(1.0f, 0.0f, 0.0f, tx, 0.0f, 1.0f, 0.0f, ty, 0.0f, 0.0f, 1.0f, tz, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix rotateX(float rx) {
        return this.rotateX((double)rx);
    }

    public LXMatrix rotateY(float ry) {
        return this.rotateY((double)ry);
    }

    public LXMatrix rotateZ(float rz) {
        return this.rotateZ((double)rz);
    }

    public LXMatrix rotateX(double rx) {
        float cos = LXUtils.cosf(rx);
        float sin = LXUtils.sinf(rx);
        return this.multiply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, cos, -sin, 0.0f, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix rotateY(double ry) {
        float cos = LXUtils.cosf(ry);
        float sin = LXUtils.sinf(ry);
        return this.multiply(cos, 0.0f, sin, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -sin, 0.0f, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix rotateZ(double rz) {
        float cos = LXUtils.cosf(rz);
        float sin = LXUtils.sinf(rz);
        return this.multiply(cos, -sin, 0.0f, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix shearXY(float rz) {
        float c = 1.0f / LXUtils.tanf(1.5707963267948966 + (double)rz);
        return this.multiply(1.0f, c, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix shearYX(float rz) {
        float c = 1.0f / LXUtils.tanf(1.5707963267948966 + (double)rz);
        return this.multiply(1.0f, 0.0f, 0.0f, 0.0f, c, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix shearYZ(float rx) {
        float c = 1.0f / LXUtils.tanf(1.5707963267948966 + (double)rx);
        return this.multiply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, c, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix shearZY(float rx) {
        float c = 1.0f / LXUtils.tanf(1.5707963267948966 + (double)rx);
        return this.multiply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, c, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix shearZX(float ry) {
        float c = 1.0f / LXUtils.tanf(1.5707963267948966 + (double)ry);
        return this.multiply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, c, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix shearXZ(float ry) {
        float c = 1.0f / LXUtils.tanf(1.5707963267948966 + (double)ry);
        return this.multiply(1.0f, 0.0f, c, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public LXMatrix set(LXMatrix that) {
        this.m11 = that.m11;
        this.m12 = that.m12;
        this.m13 = that.m13;
        this.m14 = that.m14;
        this.m21 = that.m21;
        this.m22 = that.m22;
        this.m23 = that.m23;
        this.m24 = that.m24;
        this.m31 = that.m31;
        this.m32 = that.m32;
        this.m33 = that.m33;
        this.m34 = that.m34;
        this.m41 = that.m41;
        this.m42 = that.m42;
        this.m43 = that.m43;
        this.m44 = that.m44;
        return this;
    }

    public LXMatrix set(float ... m) {
        if (m.length != 16) {
            throw new IllegalArgumentException("LXMatrix.set() must have 16 values");
        }
        this.m11 = m[0];
        this.m12 = m[1];
        this.m13 = m[2];
        this.m14 = m[3];
        this.m21 = m[4];
        this.m22 = m[5];
        this.m23 = m[6];
        this.m24 = m[7];
        this.m31 = m[8];
        this.m32 = m[9];
        this.m33 = m[10];
        this.m34 = m[11];
        this.m41 = m[12];
        this.m42 = m[13];
        this.m43 = m[14];
        this.m44 = m[15];
        return this;
    }

    public LXMatrix identity() {
        return this.set(IDENTITY);
    }

    public FloatBuffer put(FloatBuffer buffer) {
        return this.put(buffer, BufferOrder.ROW_MAJOR);
    }

    public FloatBuffer put(FloatBuffer buffer, BufferOrder bufferOrder) {
        switch (bufferOrder) {
            case COLUMN_MAJOR: {
                buffer.put(0, this.m11).put(1, this.m21).put(2, this.m31).put(3, this.m41).put(4, this.m12).put(5, this.m22).put(6, this.m32).put(7, this.m42).put(8, this.m13).put(9, this.m23).put(10, this.m33).put(11, this.m43).put(12, this.m14).put(13, this.m24).put(14, this.m34).put(15, this.m44);
                break;
            }
            case ROW_MAJOR: {
                buffer.put(0, this.m11).put(1, this.m12).put(2, this.m13).put(3, this.m14).put(4, this.m21).put(5, this.m22).put(6, this.m23).put(7, this.m24).put(8, this.m31).put(9, this.m32).put(10, this.m33).put(11, this.m34).put(12, this.m41).put(13, this.m42).put(14, this.m43).put(15, this.m44);
            }
        }
        return buffer;
    }

    public String toString() {
        return "[[" + this.m11 + " " + this.m12 + " " + this.m13 + " " + this.m14 + "][" + this.m21 + " " + this.m22 + " " + this.m23 + " " + this.m24 + "][" + this.m31 + " " + this.m32 + " " + this.m33 + " " + this.m34 + "][" + this.m41 + " " + this.m42 + " " + this.m43 + " " + this.m44 + "]]";
    }

    public static enum BufferOrder {
        ROW_MAJOR,
        COLUMN_MAJOR;

    }
}

