/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.transform;

import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.transform.LXVector;
import java.util.Arrays;
import java.util.Iterator;

public class LXProjection
implements Iterable<LXVector> {
    private final LXVector[] vectors;
    private final LXModel model;

    @Override
    public Iterator<LXVector> iterator() {
        return Arrays.asList(this.vectors).iterator();
    }

    public LXProjection(LXModel model) {
        this.vectors = new LXVector[model.points.length];
        int i = 0;
        LXPoint[] lXPointArray = model.points;
        int n = model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint point = lXPointArray[n2];
            this.vectors[i++] = new LXVector(point);
            ++n2;
        }
        this.model = model;
    }

    public LXProjection reset() {
        int i = 0;
        LXPoint[] lXPointArray = this.model.points;
        int n = this.model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint point = lXPointArray[n2];
            this.vectors[i].x = point.x;
            this.vectors[i].y = point.y;
            this.vectors[i].z = point.z;
            ++i;
            ++n2;
        }
        return this;
    }

    public LXProjection scale(float sx, float sy, float sz) {
        LXVector[] lXVectorArray = this.vectors;
        int n = this.vectors.length;
        int n2 = 0;
        while (n2 < n) {
            LXVector v = lXVectorArray[n2];
            v.x *= sx;
            v.y *= sy;
            v.z *= sz;
            ++n2;
        }
        return this;
    }

    public LXProjection translate(float tx, float ty, float tz) {
        LXVector[] lXVectorArray = this.vectors;
        int n = this.vectors.length;
        int n2 = 0;
        while (n2 < n) {
            LXVector v = lXVectorArray[n2];
            v.x += tx;
            v.y += ty;
            v.z += tz;
            ++n2;
        }
        return this;
    }

    public LXProjection center() {
        return this.translate(-this.model.cx, -this.model.cy, -this.model.cz);
    }

    public LXProjection translateCenter(float tx, float ty, float tz) {
        return this.translate(-this.model.cx + tx, -this.model.cy + ty, -this.model.cz + tz);
    }

    public LXProjection reflectX() {
        LXVector[] lXVectorArray = this.vectors;
        int n = this.vectors.length;
        int n2 = 0;
        while (n2 < n) {
            LXVector v = lXVectorArray[n2];
            v.x = -v.x;
            ++n2;
        }
        return this;
    }

    public LXProjection reflectY() {
        LXVector[] lXVectorArray = this.vectors;
        int n = this.vectors.length;
        int n2 = 0;
        while (n2 < n) {
            LXVector v = lXVectorArray[n2];
            v.y = -v.y;
            ++n2;
        }
        return this;
    }

    public LXProjection reflectZ() {
        LXVector[] lXVectorArray = this.vectors;
        int n = this.vectors.length;
        int n2 = 0;
        while (n2 < n) {
            LXVector v = lXVectorArray[n2];
            v.z = -v.z;
            ++n2;
        }
        return this;
    }

    public LXProjection rotate(float angle, float l, float m, float n) {
        float ss = l * l + m * m + n * n;
        if (ss != 1.0f) {
            float sr = (float)Math.sqrt(ss);
            l /= sr;
            m /= sr;
            n /= sr;
        }
        float sinv = (float)Math.sin(angle);
        float cosv = (float)Math.cos(angle);
        float a1 = l * l * (1.0f - cosv) + cosv;
        float a2 = l * m * (1.0f - cosv) - n * sinv;
        float a3 = l * n * (1.0f - cosv) + m * sinv;
        float b1 = l * m * (1.0f - cosv) + n * sinv;
        float b2 = m * m * (1.0f - cosv) + cosv;
        float b3 = m * n * (1.0f - cosv) - l * sinv;
        float c1 = l * n * (1.0f - cosv) - m * sinv;
        float c2 = m * n * (1.0f - cosv) + l * sinv;
        float c3 = n * n * (1.0f - cosv) + cosv;
        LXVector[] lXVectorArray = this.vectors;
        int n2 = this.vectors.length;
        int n3 = 0;
        while (n3 < n2) {
            LXVector v = lXVectorArray[n3];
            float xp = v.x * a1 + v.y * a2 + v.z * a3;
            float yp = v.x * b1 + v.y * b2 + v.z * b3;
            float zp = v.x * c1 + v.y * c2 + v.z * c3;
            v.x = xp;
            v.y = yp;
            v.z = zp;
            ++n3;
        }
        return this;
    }

    public LXProjection rotateX(float angle) {
        return this.rotate(angle, 1.0f, 0.0f, 0.0f);
    }

    public LXProjection rotateY(float angle) {
        return this.rotate(angle, 0.0f, 1.0f, 0.0f);
    }

    public LXProjection rotateZ(float angle) {
        return this.rotate(angle, 0.0f, 0.0f, 1.0f);
    }
}

