/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.transform;

import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXVector;
import java.util.Stack;

public class LXTransform {
    private final Stack<LXMatrix> matrices = new Stack();

    public LXTransform() {
        this(new LXMatrix());
    }

    public LXTransform(LXMatrix matrix) {
        this.matrices.push(matrix);
    }

    public LXMatrix getMatrix() {
        return this.matrices.peek();
    }

    public int size() {
        return this.matrices.size();
    }

    public LXTransform push() {
        this.matrices.push(new LXMatrix(this.matrices.peek()));
        return this;
    }

    public LXTransform pop() {
        this.matrices.pop();
        return this;
    }

    public LXTransform reset(LXMatrix matrix) {
        this.matrices.clear();
        this.matrices.push(new LXMatrix(matrix));
        return this;
    }

    public LXTransform reset() {
        return this.reset(new LXMatrix());
    }

    public LXVector vector() {
        LXMatrix m = this.getMatrix();
        return new LXVector(m.m14, m.m24, m.m34);
    }

    public float x() {
        return this.getMatrix().m14;
    }

    public float y() {
        return this.getMatrix().m24;
    }

    public float z() {
        return this.getMatrix().m34;
    }

    public LXTransform translateX(float tx) {
        return this.translate(tx, 0.0f, 0.0f);
    }

    public LXTransform translateY(float ty) {
        return this.translate(0.0f, ty, 0.0f);
    }

    public LXTransform translateZ(float tz) {
        return this.translate(0.0f, 0.0f, tz);
    }

    public LXTransform translate(float tx, float ty) {
        return this.translate(tx, ty, 0.0f);
    }

    public LXTransform translate(float tx, float ty, float tz) {
        this.getMatrix().translate(tx, ty, tz);
        return this;
    }

    public LXTransform multiply(LXMatrix m) {
        this.getMatrix().multiply(m);
        return this;
    }

    public LXTransform scale(float sv) {
        return this.scale(sv, sv, sv);
    }

    public LXTransform scaleX(float sx) {
        return this.scale(sx, 1.0f, 1.0f);
    }

    public LXTransform scaleY(float sy) {
        return this.scale(1.0f, sy, 1.0f);
    }

    public LXTransform scaleZ(float sz) {
        return this.scale(1.0f, 1.0f, sz);
    }

    public LXTransform scale(float sx, float sy, float sz) {
        this.getMatrix().scale(sx, sy, sz);
        return this;
    }

    public LXTransform rotateX(float rx) {
        this.getMatrix().rotateX(rx);
        return this;
    }

    public LXTransform rotateX(double rx) {
        return this.rotateX((float)rx);
    }

    public LXTransform rotateY(float ry) {
        this.getMatrix().rotateY(ry);
        return this;
    }

    public LXTransform rotateY(double ry) {
        return this.rotateY((float)ry);
    }

    public LXTransform rotateZ(float rz) {
        this.getMatrix().rotateZ(rz);
        return this;
    }

    public LXTransform rotateZ(double rz) {
        return this.rotateZ((float)rz);
    }
}

