/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.transform;

import heronarts.lx.model.LXPoint;
import heronarts.lx.utils.LXUtils;

public class LXVector {
    public float x;
    public float y;
    public float z;
    public final LXPoint point;
    public final int index;

    public LXVector() {
        this(0.0f, 0.0f, 0.0f);
    }

    public LXVector(LXPoint point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
        this.point = point;
        this.index = point.index;
    }

    public LXVector(LXVector that) {
        this.x = that.x;
        this.y = that.y;
        this.z = that.z;
        this.point = that.point;
        this.index = that.index;
    }

    public LXVector(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.point = null;
        this.index = -1;
    }

    public LXVector set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public LXVector set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public LXVector set(LXVector that) {
        this.x = that.x;
        this.y = that.y;
        this.z = that.z;
        return this;
    }

    public LXVector set(LXPoint that) {
        this.x = that.x;
        this.y = that.y;
        this.z = that.z;
        return this;
    }

    public LXVector copy() {
        return new LXVector(this);
    }

    public LXVector add(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public LXVector add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public LXVector add(LXVector that) {
        this.x += that.x;
        this.y += that.y;
        this.z += that.z;
        return this;
    }

    public LXVector add(LXVector that, float amount) {
        this.x += that.x * amount;
        this.y += that.y * amount;
        this.z += that.z * amount;
        return this;
    }

    public LXVector sub(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public LXVector sub(float x, float y, float z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public LXVector sub(LXVector that) {
        this.x -= that.x;
        this.y -= that.y;
        this.z -= that.z;
        return this;
    }

    public LXVector mult(float n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
        return this;
    }

    public LXVector mult(LXVector that) {
        this.x *= that.x;
        this.y *= that.y;
        this.z *= that.z;
        return this;
    }

    public LXVector div(float n) {
        this.x /= n;
        this.y /= n;
        this.z /= n;
        return this;
    }

    public float mag() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float magSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float dist(LXVector that) {
        float dx = this.x - that.x;
        float dy = this.y - that.y;
        float dz = this.z - that.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float dot(LXVector that) {
        return this.x * that.x + this.y * that.y + this.z * that.z;
    }

    public LXVector cross(LXVector that) {
        return this.cross(that.x, that.y, that.z);
    }

    public LXVector cross(float x, float y, float z) {
        float cx = this.y * z - this.z * y;
        float cy = this.z * x - this.x * z;
        float cz = this.x * y - this.y * x;
        return this.set(cx, cy, cz);
    }

    public LXVector normalize() {
        float m = this.mag();
        if (m != 0.0f && m != 1.0f) {
            this.div(m);
        }
        return this;
    }

    public LXVector limit(float max) {
        float mag2 = this.magSq();
        if (mag2 > max * max) {
            this.mult(max / (float)Math.sqrt(mag2));
        }
        return this;
    }

    public LXVector setMag(float mag) {
        this.normalize();
        return this.mult(mag);
    }

    public LXVector lerp(LXVector that, float amt) {
        return this.set(LXUtils.lerpf(this.x, that.x, amt), LXUtils.lerpf(this.y, that.y, amt), LXUtils.lerpf(this.z, that.z, amt));
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public LXVector rotate(float theta) {
        float xx = this.x;
        this.x = (float)((double)xx * Math.cos(theta) - (double)this.y * Math.sin(theta));
        this.y = (float)((double)xx * Math.sin(theta) + (double)this.y * Math.cos(theta));
        return this;
    }

    public LXVector rotate(float theta, float l, float m, float n) {
        float ss = l * l + m * m + n * n;
        if (ss != 1.0f) {
            float sr = (float)Math.sqrt(ss);
            l /= sr;
            m /= sr;
            n /= sr;
        }
        float sinv = (float)Math.sin(theta);
        float cosv = (float)Math.cos(theta);
        float a1 = l * l * (1.0f - cosv) + cosv;
        float a2 = l * m * (1.0f - cosv) - n * sinv;
        float a3 = l * n * (1.0f - cosv) + m * sinv;
        float b1 = l * m * (1.0f - cosv) + n * sinv;
        float b2 = m * m * (1.0f - cosv) + cosv;
        float b3 = m * n * (1.0f - cosv) - l * sinv;
        float c1 = l * n * (1.0f - cosv) - m * sinv;
        float c2 = m * n * (1.0f - cosv) + l * sinv;
        float c3 = n * n * (1.0f - cosv) + cosv;
        float xp = this.x * a1 + this.y * a2 + this.z * a3;
        float yp = this.x * b1 + this.y * b2 + this.z * b3;
        float zp = this.x * c1 + this.y * c2 + this.z * c3;
        this.x = xp;
        this.y = yp;
        this.z = zp;
        return this;
    }

    public static float angleBetween(LXVector v1, LXVector v2) {
        double v2mag;
        if (v1.x == 0.0f && v1.y == 0.0f && v1.z == 0.0f) {
            return 0.0f;
        }
        if (v2.x == 0.0f && v2.y == 0.0f && v2.z == 0.0f) {
            return 0.0f;
        }
        double dot = v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
        double v1mag = Math.sqrt(v1.x * v1.x + v1.y * v1.y + v1.z * v1.z);
        double amt = dot / (v1mag * (v2mag = Math.sqrt(v2.x * v2.x + v2.y * v2.y + v2.z * v2.z)));
        if (amt <= -1.0) {
            return (float)Math.PI;
        }
        if (amt >= 1.0) {
            return 0.0f;
        }
        return (float)Math.acos(amt);
    }

    public String toString() {
        return "[ " + this.x + ", " + this.y + ", " + this.z + " ]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof LXVector)) {
            return false;
        }
        LXVector that = (LXVector)o;
        return this.x == that.x && this.y == that.y && this.z == that.z && this.point == that.point && this.index == that.index;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }
}

