/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.utils;

import heronarts.lx.parameter.MutableParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicReference;

public class LXEngineThreadArrayList<T>
implements List<T>,
RandomAccess {
    private final ArrayList<T> engineList = new ArrayList();
    private final AtomicReference<List<T>> uiList = new AtomicReference();
    private int semaphore = 0;
    private boolean needsSet = false;
    public final MutableParameter changed = new MutableParameter();

    public LXEngineThreadArrayList() {
        this._setUIThreadList(false);
    }

    public LXEngineThreadArrayList<T> begin() {
        ++this.semaphore;
        return this;
    }

    public LXEngineThreadArrayList<T> commit() {
        if (this.semaphore <= 0) {
            throw new IllegalStateException("LXEngineArrayList may not commit changes when semaphore already 0");
        }
        --this.semaphore;
        if (this.semaphore == 0 && this.needsSet) {
            this.needsSet = false;
            this.setUIThreadList();
        }
        return this;
    }

    public void set(List<T> contents) {
        this.begin();
        this.clear();
        this.addAll((Collection<? extends T>)contents);
        this.commit();
    }

    private void setUIThreadList() {
        if (this.semaphore == 0) {
            this._setUIThreadList(true);
        } else {
            this.needsSet = true;
        }
    }

    private void _setUIThreadList(boolean notify) {
        this.uiList.set(Collections.unmodifiableList(new ArrayList<T>(this.engineList)));
        if (notify) {
            this.changed.bang();
        }
    }

    public List<T> getUIThreadList() {
        return this.uiList.get();
    }

    @Override
    public int size() {
        return this.engineList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.engineList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.engineList.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.engineList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.engineList.toArray();
    }

    @Override
    public <V> V[] toArray(V[] a) {
        return this.engineList.toArray(a);
    }

    @Override
    public boolean add(T e) {
        boolean ret = this.engineList.add(e);
        this.setUIThreadList();
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        if (this.engineList.remove(o)) {
            this.setUIThreadList();
            return true;
        }
        return false;
    }

    public void removeRange(int fromIndex, int toIndex) {
        this.engineList.subList(fromIndex, toIndex).clear();
        this.setUIThreadList();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.engineList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.engineList.addAll(c)) {
            this.setUIThreadList();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this.engineList.addAll(index, c)) {
            this.setUIThreadList();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.engineList.removeAll(c)) {
            this.setUIThreadList();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.engineList.retainAll(c)) {
            this.setUIThreadList();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.engineList.clear();
        this.setUIThreadList();
    }

    @Override
    public T get(int index) {
        return this.engineList.get(index);
    }

    @Override
    public T set(int index, T element) {
        T ret = this.engineList.set(index, element);
        this.setUIThreadList();
        return ret;
    }

    @Override
    public void add(int index, T element) {
        this.engineList.add(index, element);
        this.setUIThreadList();
    }

    @Override
    public T remove(int index) {
        T ret = this.engineList.remove(index);
        this.setUIThreadList();
        return ret;
    }

    @Override
    public int indexOf(Object o) {
        return this.engineList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.engineList.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.engineList.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.engineList.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.engineList.subList(fromIndex, toIndex);
    }
}

