/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.utils;

import heronarts.lx.utils.Noise;

public class LXUtils {
    private LXUtils() {
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int min(int a, int b, int c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static int max(int a, int b) {
        return a < b ? b : a;
    }

    public static int max(int a, int b, int c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static float minf(float a, float b) {
        return a < b ? a : b;
    }

    public static float minf(float a, float b, float c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static float maxf(float a, float b) {
        return a < b ? b : a;
    }

    public static float maxf(float a, float b, float c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static double min(double a, double b, double c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static double max(double a, double b) {
        return a < b ? b : a;
    }

    public static double max(double a, double b, double c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clampf(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static long clampl(long value, long min, long max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double constrain(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float constrainf(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int constrain(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static long constrainl(long value, long min, long max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double wrapn(double value) {
        if (value > 1.0) {
            return value % 1.0;
        }
        if (value < 0.0) {
            return 1.0 + value % 1.0;
        }
        return value;
    }

    public static float wrapnf(float value) {
        if (value > 1.0f) {
            return value % 1.0f;
        }
        if (value < 0.0f) {
            return 1.0f + value % 1.0f;
        }
        return value;
    }

    public static int wrap(int value, int min, int max) {
        if (value > max) {
            return min + (value - max) % (max - min);
        }
        if (value < min) {
            return max + (value - min) % (max - min);
        }
        return value;
    }

    public static double wrap(double value, double min, double max) {
        if (value > max) {
            return min + (value - max) % (max - min);
        }
        if (value < min) {
            return max + (value - min) % (max - min);
        }
        return value;
    }

    public static float wrapf(float value, float min, float max) {
        if (value > max) {
            return min + (value - max) % (max - min);
        }
        if (value < min) {
            return max + (value - min) % (max - min);
        }
        return value;
    }

    public static int randomi(int max) {
        return LXUtils.randomi(0, max);
    }

    public static int randomi(int min, int max) {
        return (int)LXUtils.constrain(LXUtils.random(min, max + 1), (double)min, (double)max);
    }

    public static double random(double max) {
        return LXUtils.random(0.0, max);
    }

    public static double random(double min, double max) {
        return min + Math.random() * (max - min);
    }

    public static float randomf(float max) {
        return LXUtils.randomf(0.0f, max);
    }

    public static float randomf(float min, float max) {
        return min + (float)Math.random() * (max - min);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static double lerp(double v1, double v2, double amt) {
        return v1 + (v2 - v1) * amt;
    }

    public static float lerpf(float v1, float v2, float amt) {
        return v1 + (v2 - v1) * amt;
    }

    public static int lerpi(int v1, int v2, float amt) {
        return Math.round((float)v1 + (float)(v2 - v1) * amt);
    }

    public static boolean inRange(int val, int min, int max) {
        return val >= min && val <= max;
    }

    public static boolean inRange(float val, float min, float max) {
        return val >= min && val <= max;
    }

    public static boolean inRange(double val, double min, double max) {
        return val >= min && val <= max;
    }

    public static float ilerpf(float amt, float v1, float v2) {
        return (amt - v1) / (v2 - v1);
    }

    public static double ilerp(double amt, double v1, double v2) {
        return (amt - v1) / (v2 - v1);
    }

    public static double tri(double t) {
        if ((t -= Math.floor(t)) < 0.25) {
            return t * 4.0;
        }
        if (t < 0.75) {
            return 1.0 - 4.0 * (t - 0.25);
        }
        return -1.0 + 4.0 * (t - 0.75);
    }

    public static float trif(float t) {
        return (float)LXUtils.tri(t);
    }

    public static double avg(double v1, double v2) {
        return (v1 + v2) / 2.0;
    }

    public static float avgf(float v1, float v2) {
        return (v1 + v2) / 2.0f;
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static float distf(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
    }

    public static float distf(float x1, float y1, float z1, float x2, float y2, float z2) {
        return (float)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
    }

    public static double wrapdist(double v1, double v2, double modulus) {
        if (v1 < v2) {
            return Math.min(v2 - v1, v1 + modulus - v2);
        }
        return Math.min(v1 - v2, v2 + modulus - v1);
    }

    public static float wrapdistf(float v1, float v2, float modulus) {
        if (v1 < v2) {
            return Math.min(v2 - v1, v1 + modulus - v2);
        }
        return Math.min(v1 - v2, v2 + modulus - v1);
    }

    public static float round2f(float val) {
        return (float)Math.round((double)val * 100.0) * 0.01f;
    }

    public static float sinf(double radians) {
        return (float)Math.round(Math.sin(radians) * 1.0E8) / 1.0E8f;
    }

    public static float cosf(double radians) {
        return (float)Math.round(Math.cos(radians) * 1.0E8) / 1.0E8f;
    }

    public static float atan2pf(float y, float x) {
        return (float)((Math.PI * 2 + Math.atan2(y, x)) % (Math.PI * 2));
    }

    public static float tanf(double radians) {
        return (float)Math.round(Math.tan(radians) * 1.0E8) / 1.0E8f;
    }

    public static float noise(float x, float y, float z) {
        return Noise.stb_perlin_noise3(x, y, z, 0, 0, 0);
    }

    public static float noise(float x, float y, float z, int seed) {
        return Noise.stb_perlin_noise3_seed(x, y, z, 0, 0, 0, seed);
    }

    public static float noiseRidge(float x, float y, float z, float lacunarity, float gain, float offset, int octaves) {
        return Noise.stb_perlin_ridge_noise3(x, y, z, lacunarity, gain, offset, octaves);
    }

    public static float noiseFBM(float x, float y, float z, float lacunarity, float gain, int octaves) {
        return Noise.stb_perlin_fbm_noise3(x, y, z, lacunarity, gain, octaves);
    }

    public static float noiseTurbulence(float x, float y, float z, float lacunarity, float gain, int octaves) {
        return Noise.stb_perlin_turbulence_noise3(x, y, z, lacunarity, gain, octaves);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static class LookupTable {
        protected final int tableSize;
        protected float[] values;

        public LookupTable(int tableSize, Function function) {
            this.tableSize = tableSize;
            this.values = new float[tableSize + 1];
            int i = 0;
            while (i <= tableSize) {
                this.values[i] = function.compute(i, tableSize);
                ++i;
            }
        }

        public float get(float basis) {
            return this.values[Math.round(basis * (float)this.tableSize)];
        }

        public float get(double basis) {
            return this.values[(int)Math.round(basis * (double)this.tableSize)];
        }

        public static class Cos
        extends LookupTable {
            public Cos(int tableSize) {
                super(tableSize, Function.COS);
            }

            public float cos(float radians) {
                int index = (int)Math.round((double)Math.abs(radians) / (Math.PI * 2) * (double)this.tableSize);
                return this.values[index % this.values.length];
            }
        }

        public static interface Function {
            public static final Function SIN = (i, tableSize) -> (float)Math.sin((double)i * (Math.PI * 2) / (double)tableSize);
            public static final Function COS = (i, tableSize) -> (float)Math.cos((double)i * (Math.PI * 2) / (double)tableSize);
            public static final Function TAN = (i, tableSize) -> (float)Math.tan((double)i * (Math.PI * 2) / (double)tableSize);

            public float compute(int var1, int var2);
        }

        public static class Sin
        extends LookupTable {
            public Sin(int tableSize) {
                super(tableSize, Function.SIN);
            }

            public float sin(float radians) {
                int index = (int)Math.round((double)Math.abs(radians) / (Math.PI * 2) * (double)this.tableSize);
                float val = this.values[index % this.values.length];
                return radians > 0.0f ? val : -val;
            }
        }

        public static class Tan
        extends LookupTable {
            public Tan(int tableSize) {
                super(tableSize, Function.TAN);
            }

            public float tan(float radians) {
                int index = (int)Math.round((double)Math.abs(radians) / (Math.PI * 2) * (double)this.tableSize);
                float val = this.values[index % this.values.length];
                return radians > 0.0f ? val : -val;
            }
        }
    }
}

