/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class ObservableList<T>
implements List<T> {
    private final List<T> list;
    private final List<Listener<T>> listeners;

    public ObservableList() {
        this(new ArrayList());
    }

    public ObservableList(List<T> list) {
        this.list = list;
        this.listeners = new ArrayList<Listener<T>>();
    }

    private ObservableList(ObservableList<T> list) {
        this.list = Collections.unmodifiableList(list.list);
        this.listeners = list.listeners;
    }

    public ObservableList<T> asUnmodifiableList() {
        return new ObservableList<T>(this);
    }

    public ObservableList<T> addListener(Listener<T> listener) {
        Objects.requireNonNull(listener, "May not add null Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public ObservableList<T> removeListener(Listener<T> listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    private void notifyAdded(T item) {
        for (Listener<T> listener : this.listeners) {
            listener.itemAdded(item);
        }
    }

    private void notifyAdded(Collection<? extends T> items) {
        for (T item : items) {
            this.notifyAdded(item);
        }
    }

    private void notifyRemoved(T item) {
        for (Listener<T> listener : this.listeners) {
            listener.itemRemoved(item);
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> iterator = this.list.iterator();
        return new Iterator<T>(){
            T current = null;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                this.current = iterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                iterator.remove();
                ObservableList.this.notifyRemoved(this.current);
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T item) {
        this.list.add(item);
        this.notifyAdded(item);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (this.list.remove(o)) {
            this.notifyRemoved(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.list.addAll(c)) {
            this.notifyAdded(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this.list.addAll(index, c)) {
            this.notifyAdded(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            boolean itemRemoved = this.list.remove(o);
            if (itemRemoved) {
                this.notifyRemoved(o);
            }
            boolean bl = removed = removed || itemRemoved;
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        ArrayList<T> removed = new ArrayList<T>(this.list);
        this.list.clear();
        for (Object item : removed) {
            this.notifyRemoved(item);
        }
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T item) {
        T existing = this.list.get(index);
        if (existing != item) {
            this.list.set(index, item);
            this.notifyRemoved(existing);
            this.notifyAdded(item);
        }
        return existing;
    }

    @Override
    public void add(int index, T item) {
        this.list.add(index, item);
        this.notifyAdded(item);
    }

    @Override
    public T remove(int index) {
        T removed = this.list.remove(index);
        this.notifyRemoved(removed);
        return removed;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("ListIterator not supported in ObservableList");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("ListIterator not supported in ObservableList");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public static interface Listener<T> {
        default public void itemAdded(T item) {
        }

        default public void itemRemoved(T item) {
        }
    }
}

