/*
 * Decompiled with CFR 0.152.
 */
package com.hexadevlabs.gpt4all;

import com.hexadevlabs.gpt4all.LLModelLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import jnr.ffi.LibraryLoader;
import jnr.ffi.LibraryOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final CharsetDecoder cs = StandardCharsets.UTF_8.newDecoder();

    public static LLModelLibrary loadSharedLibrary(String librarySearchPath) {
        String libraryName = "llmodel";
        HashMap<LibraryOption, Boolean> libraryOptions = new HashMap<LibraryOption, Boolean>();
        libraryOptions.put(LibraryOption.LoadNow, true);
        libraryOptions.put(LibraryOption.IgnoreError, false);
        if (librarySearchPath != null) {
            HashMap<String, List<String>> searchPaths = new HashMap<String, List<String>>();
            searchPaths.put(libraryName, List.of(librarySearchPath));
            return (LLModelLibrary)LibraryLoader.loadLibrary(LLModelLibrary.class, libraryOptions, searchPaths, (String[])new String[]{libraryName});
        }
        return (LLModelLibrary)LibraryLoader.loadLibrary(LLModelLibrary.class, libraryOptions, (String[])new String[]{libraryName});
    }

    /*
     * WARNING - void declaration
     */
    public static Path copySharedLibraries() {
        try {
            String[] libraryNames;
            String osName = System.getProperty("os.name").toLowerCase();
            boolean isWindows = osName.startsWith("windows");
            boolean isMac = osName.startsWith("mac os x");
            boolean isLinux = osName.startsWith("linux");
            if (isWindows) {
                osName = "windows";
            }
            if (isMac) {
                osName = "macos";
            }
            if (isLinux) {
                osName = "linux";
            }
            Path tempDirectory = Files.createTempDirectory("nativeLibraries", new FileAttribute[0]);
            tempDirectory.toFile().deleteOnExit();
            for (String string : libraryNames = new String[]{"gptj-default", "gptj-avxonly", "llmodel", "mpt-default", "llamamodel-230511-default", "llamamodel-230519-default", "llamamodel-mainline-default", "llamamodel-mainline-metal", "replit-mainline-default", "replit-mainline-metal", "ggml-metal.metal", "falcon-default"}) {
                void var9_10;
                if (!isMac && (string.equals("replit-mainline-metal") || string.equals("llamamodel-mainline-metal") || string.equals("ggml-metal.metal"))) continue;
                if (isWindows) {
                    String string2 = string + ".dll";
                } else if (isMac) {
                    if (!string.equals("ggml-metal.metal")) {
                        String string3 = "lib" + string + ".dylib";
                    }
                } else if (isLinux) {
                    String string4 = "lib" + string + ".so";
                }
                String nativeLibraryPath = "/native/" + osName + "/" + (String)var9_10;
                InputStream in = Util.class.getResourceAsStream(nativeLibraryPath);
                if (in == null) {
                    throw new RuntimeException("Unable to find native library: " + nativeLibraryPath);
                }
                Path tempLibraryPath = tempDirectory.resolve((String)var9_10);
                Files.copy(in, tempLibraryPath, StandardCopyOption.REPLACE_EXISTING);
                in.close();
            }
            if (!isWindows) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        Files.walk(tempDirectory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(file -> {
                            try {
                                Files.delete(file.toPath());
                            }
                            catch (IOException e) {
                                logger.error("Deleting temp library file", (Throwable)e);
                            }
                        });
                    }
                    catch (IOException e) {
                        logger.error("Deleting temp directory for libraries", (Throwable)e);
                    }
                }));
            }
            return tempDirectory;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load native libraries", e);
        }
    }

    public static String getValidUtf8(byte[] bytes) {
        try {
            return cs.decode(ByteBuffer.wrap(bytes)).toString();
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }
}

