/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core;

import com.hexagonkt.core.Jvm;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\n\u0010\t\u001a\u00020\n*\u00020\f\u001a\n\u0010\t\u001a\u00020\n*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u000b*\u00020\n\u001a\n\u0010\u000e\u001a\u00020\u000b*\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\f*\u00020\n\u001a\n\u0010\u000f\u001a\u00020\f*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0003\u001a\n\u0010\u0012\u001a\u00020\u0003*\u00020\u000b\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u0012\u001a\u00020\u0003*\u00020\u0011\u001a\u0014\u0010\u0013\u001a\u00020\r*\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DATE_OFFSET", "", "HOUR_OFFSET", "", "MINUTE_OFFSET", "MONTH_OFFSET", "NANO_OFFSET", "SECOND_OFFSET", "YEAR_OFFSET", "toDate", "Ljava/util/Date;", "Ljava/time/LocalDate;", "Ljava/time/LocalDateTime;", "Ljava/time/ZonedDateTime;", "toLocalDate", "toLocalDateTime", "toLocalTime", "Ljava/time/LocalTime;", "toNumber", "withZone", "zoneId", "Ljava/time/ZoneId;", "core"})
public final class DatesKt {
    private static final long DATE_OFFSET = 1000000000L;
    private static final int YEAR_OFFSET = 10000;
    private static final int MONTH_OFFSET = 100;
    private static final int HOUR_OFFSET = 10000000;
    private static final int MINUTE_OFFSET = 100000;
    private static final int SECOND_OFFSET = 1000;
    private static final int NANO_OFFSET = 1000000;

    public static final long toNumber(@NotNull LocalDateTime $this$toNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$toNumber, (String)"<this>");
        LocalDate localDate = $this$toNumber.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"this.toLocalDate()");
        long l = (long)DatesKt.toNumber(localDate) * 1000000000L;
        LocalTime localTime = $this$toNumber.toLocalTime();
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"this.toLocalTime()");
        return l + (long)DatesKt.toNumber(localTime);
    }

    public static final int toNumber(@NotNull LocalDate $this$toNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$toNumber, (String)"<this>");
        return $this$toNumber.getYear() * 10000 + $this$toNumber.getMonthValue() * 100 + $this$toNumber.getDayOfMonth();
    }

    public static final int toNumber(@NotNull LocalTime $this$toNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$toNumber, (String)"<this>");
        return $this$toNumber.getHour() * 10000000 + $this$toNumber.getMinute() * 100000 + $this$toNumber.getSecond() * 1000 + $this$toNumber.getNano() / 1000000;
    }

    @NotNull
    public static final ZonedDateTime withZone(@NotNull LocalDateTime $this$withZone, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)$this$withZone, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime zonedDateTime = ZonedDateTime.of($this$withZone, zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(this, zoneId)");
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime withZone$default(LocalDateTime localDateTime, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneId zoneId2 = Jvm.INSTANCE.getTimeZone().toZoneId();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"Jvm.timeZone.toZoneId()");
            zoneId = zoneId2;
        }
        return DatesKt.withZone(localDateTime, zoneId);
    }

    @NotNull
    public static final LocalDateTime toLocalDateTime(long $this$toLocalDateTime) {
        if (!($this$toLocalDateTime >= 0L)) {
            boolean bl = false;
            String string = "Number representing timestamp must be positive (format: YYYYMMDDHHmmss)";
            throw new IllegalArgumentException(string.toString());
        }
        LocalDateTime localDateTime = DatesKt.toLocalDate((int)($this$toLocalDateTime / 1000000000L)).atTime(DatesKt.toLocalTime((int)($this$toLocalDateTime % 1000000000L)));
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"this / DATE_OFFSET)\n    \u2026T).toInt().toLocalTime())");
        return localDateTime;
    }

    @NotNull
    public static final LocalDate toLocalDate(int $this$toLocalDate) {
        if (!($this$toLocalDate >= 0)) {
            boolean bl = false;
            String string = "Number representing date must be positive (format: YYYYMMDD)";
            throw new IllegalArgumentException(string.toString());
        }
        LocalDate localDate = LocalDate.of($this$toLocalDate / 10000, $this$toLocalDate % 10000 / 100, $this$toLocalDate % 100);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(\n        this / YEAR_\u2026this % MONTH_OFFSET\n    )");
        return localDate;
    }

    @NotNull
    public static final LocalTime toLocalTime(int $this$toLocalTime) {
        if (!($this$toLocalTime >= 0)) {
            boolean bl = false;
            String string = "Number representing time must be positive (format: HHmmssSSS)";
            throw new IllegalArgumentException(string.toString());
        }
        LocalTime localTime = LocalTime.of($this$toLocalTime / 10000000, $this$toLocalTime % 10000000 / 100000, $this$toLocalTime % 100000 / 1000, $this$toLocalTime % 1000 * 1000000);
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"of(\n        (this / HOUR\u2026 // Millis to nanos\n    )");
        return localTime;
    }

    @NotNull
    public static final Date toDate(@NotNull ZonedDateTime $this$toDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        Date date = Date.from($this$toDate.toInstant());
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(this.toInstant())");
        return date;
    }

    @NotNull
    public static final Date toDate(@NotNull LocalDateTime $this$toDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        ZonedDateTime zonedDateTime = $this$toDate.atZone(Jvm.INSTANCE.getTimeZone().toZoneId());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"this.atZone(Jvm.timeZone.toZoneId())");
        return DatesKt.toDate(zonedDateTime);
    }

    @NotNull
    public static final Date toDate(@NotNull LocalDate $this$toDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        ZonedDateTime zonedDateTime = $this$toDate.atStartOfDay(Jvm.INSTANCE.getTimeZone().toZoneId());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"this.atStartOfDay(Jvm.timeZone.toZoneId())");
        return DatesKt.toDate(zonedDateTime);
    }

    @NotNull
    public static final LocalDateTime toLocalDateTime(@NotNull Date $this$toLocalDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"<this>");
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli($this$toLocalDateTime.getTime()), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(Instant.ofEpoc\u2026, ZoneId.systemDefault())");
        return localDateTime;
    }

    @NotNull
    public static final LocalDate toLocalDate(@NotNull Date $this$toLocalDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDate, (String)"<this>");
        LocalDate localDate = DatesKt.toLocalDateTime($this$toLocalDate).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"this.toLocalDateTime().toLocalDate()");
        return localDate;
    }
}

