/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core;

import com.hexagonkt.core.Jvm;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u00103\u001a\u00020\u0014J\u000e\u00104\u001a\u0002052\u0006\u0010&\u001a\u00020\u0014J\"\u00106\u001a\u0002H7\"\n\b\u0000\u00107\u0018\u0001*\u00020\u00012\u0006\u0010&\u001a\u00020\u0014H\u0086\b\u00a2\u0006\u0002\u00108J+\u00106\u001a\u0002H7\"\b\b\u0000\u00107*\u00020\u00012\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70:2\u0006\u0010&\u001a\u00020\u0014\u00a2\u0006\u0002\u0010;J$\u0010<\u001a\u0004\u0018\u0001H7\"\n\b\u0000\u00107\u0018\u0001*\u00020\u00012\u0006\u0010&\u001a\u00020\u0014H\u0086\b\u00a2\u0006\u0002\u00108J-\u0010<\u001a\u0004\u0018\u0001H7\"\b\b\u0000\u00107*\u00020\u00012\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70:2\u0006\u0010&\u001a\u00020\u0014\u00a2\u0006\u0002\u0010;J\u0012\u0010=\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0006\u0010>\u001a\u00020\u0014J\u0006\u0010?\u001a\u00020\u0014R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\b\u001a\u0004\b\u0019\u0010\u0016R\u001b\u0010\u001b\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\b\u001a\u0004\b\u001c\u0010\u0016R\u001b\u0010\u001e\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\b\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\b\u001a\u0004\b$\u0010\u0016R\u001b\u0010&\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\b\u001a\u0004\b'\u0010\u0016R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001b\u0010-\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\b\u001a\u0004\b.\u0010\u0016R\u001b\u00100\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\b\u001a\u0004\b1\u0010\u0016\u00a8\u0006@"}, d2={"Lcom/hexagonkt/core/Jvm;", "", "()V", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "charset$delegate", "Lkotlin/Lazy;", "cpuCount", "", "getCpuCount", "()I", "cpuCount$delegate", "heap", "Ljava/lang/management/MemoryUsage;", "getHeap", "()Ljava/lang/management/MemoryUsage;", "heap$delegate", "hostname", "", "getHostname", "()Ljava/lang/String;", "hostname$delegate", "id", "getId", "id$delegate", "ip", "getIp", "ip$delegate", "locale", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "locale$delegate", "localeCode", "getLocaleCode", "localeCode$delegate", "name", "getName", "name$delegate", "timeZone", "Ljava/util/TimeZone;", "getTimeZone", "()Ljava/util/TimeZone;", "timezone", "getTimezone", "timezone$delegate", "version", "getVersion", "version$delegate", "initialMemory", "systemFlag", "", "systemSetting", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;Ljava/lang/String;)Ljava/lang/Object;", "systemSettingOrNull", "systemSettingRaw", "uptime", "usedMemory", "core"})
public final class Jvm {
    @NotNull
    public static final Jvm INSTANCE = new Jvm();
    @NotNull
    private static final TimeZone timeZone;
    @NotNull
    private static final Lazy charset$delegate;
    @NotNull
    private static final Lazy locale$delegate;
    @NotNull
    private static final Lazy hostname$delegate;
    @NotNull
    private static final Lazy ip$delegate;
    @NotNull
    private static final Lazy id$delegate;
    @NotNull
    private static final Lazy name$delegate;
    @NotNull
    private static final Lazy version$delegate;
    @NotNull
    private static final Lazy cpuCount$delegate;
    @NotNull
    private static final Lazy timezone$delegate;
    @NotNull
    private static final Lazy localeCode$delegate;
    @NotNull
    private static final Lazy heap$delegate;

    private Jvm() {
    }

    @NotNull
    public final TimeZone getTimeZone() {
        return timeZone;
    }

    @NotNull
    public final Charset getCharset() {
        Lazy lazy = charset$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-charset>(...)");
        return (Charset)object;
    }

    @NotNull
    public final Locale getLocale() {
        Lazy lazy = locale$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-locale>(...)");
        return (Locale)object;
    }

    @NotNull
    public final String getHostname() {
        Lazy lazy = hostname$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-hostname>(...)");
        return (String)object;
    }

    @NotNull
    public final String getIp() {
        Lazy lazy = ip$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ip>(...)");
        return (String)object;
    }

    @NotNull
    public final String getId() {
        Lazy lazy = id$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-id>(...)");
        return (String)object;
    }

    @NotNull
    public final String getName() {
        Lazy lazy = name$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-name>(...)");
        return (String)object;
    }

    @NotNull
    public final String getVersion() {
        Lazy lazy = version$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-version>(...)");
        return (String)object;
    }

    public final int getCpuCount() {
        Lazy lazy = cpuCount$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final String getTimezone() {
        Lazy lazy = timezone$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-timezone>(...)");
        return (String)object;
    }

    @NotNull
    public final String getLocaleCode() {
        Lazy lazy = localeCode$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String initialMemory() {
        String string = "%,d";
        Object[] objectArray = new Object[]{this.getHeap().getInit() / (long)1024};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    @NotNull
    public final String usedMemory() {
        String string = "%,d";
        Object[] objectArray = new Object[]{this.getHeap().getUsed() / (long)1024};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    @NotNull
    public final String uptime() {
        String string = "%01.3f";
        Object[] objectArray = new Object[]{(double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final <T> T systemSettingOrNull(@NotNull KClass<T> type, @NotNull String name2) {
        Boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string = this.systemSettingRaw(name2);
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            KClass<T> kClass = type;
            if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                object = StringsKt.toBooleanStrictOrNull((String)it);
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                object = StringsKt.toIntOrNull((String)it);
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                object = StringsKt.toLongOrNull((String)it);
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                object = StringsKt.toFloatOrNull((String)it);
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                object = StringsKt.toDoubleOrNull((String)it);
            } else {
                if (!Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) throw new IllegalStateException(("Setting: '" + name2 + "' has unsupported type: " + type.getQualifiedName()).toString());
                object = it;
            }
        } else {
            object = bl = null;
        }
        if (object != null) return (T)bl;
        bl = null;
        return (T)bl;
    }

    @NotNull
    public final <T> T systemSetting(@NotNull KClass<T> type, @NotNull String name2) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        T t = this.systemSettingOrNull(type, name2);
        if (t == null) {
            throw new IllegalStateException(("Required '" + type.getSimpleName() + "' system setting '" + name2 + "' not found").toString());
        }
        return t;
    }

    public final boolean systemFlag(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Boolean bl = (Boolean)this.systemSettingOrNull(Reflection.getOrCreateKotlinClass(Boolean.TYPE), name2);
        return bl != null ? bl : false;
    }

    public final /* synthetic */ <T> T systemSettingOrNull(String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        boolean $i$f$systemSettingOrNull = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.systemSettingOrNull(Reflection.getOrCreateKotlinClass(Object.class), name2);
    }

    public final /* synthetic */ <T> T systemSetting(String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        boolean $i$f$systemSetting = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.systemSetting(Reflection.getOrCreateKotlinClass(Object.class), name2);
    }

    private final MemoryUsage getHeap() {
        Lazy lazy = heap$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-heap>(...)");
        return (MemoryUsage)object;
    }

    private final String systemSettingRaw(String name2) {
        if (!(!StringsKt.isBlank((CharSequence)name2))) {
            boolean bl = false;
            String string = "Setting name can not be blank";
            throw new IllegalArgumentException(string.toString());
        }
        String string = System.getProperty(name2);
        if (string == null) {
            string = System.getenv(name2);
        }
        return string;
    }

    static {
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault()");
        Jvm.timeZone = timeZone;
        charset$delegate = LazyKt.lazy((Function0)charset.2.INSTANCE);
        locale$delegate = LazyKt.lazy((Function0)locale.2.INSTANCE);
        hostname$delegate = LazyKt.lazy((Function0)hostname.2.INSTANCE);
        ip$delegate = LazyKt.lazy((Function0)ip.2.INSTANCE);
        id$delegate = LazyKt.lazy((Function0)id.2.INSTANCE);
        name$delegate = LazyKt.lazy((Function0)name.2.INSTANCE);
        version$delegate = LazyKt.lazy((Function0)version.2.INSTANCE);
        cpuCount$delegate = LazyKt.lazy((Function0)cpuCount.2.INSTANCE);
        timezone$delegate = LazyKt.lazy((Function0)timezone.2.INSTANCE);
        localeCode$delegate = LazyKt.lazy((Function0)localeCode.2.INSTANCE);
        heap$delegate = LazyKt.lazy((Function0)heap.2.INSTANCE);
    }
}

