/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.args;

import com.hexagonkt.core.args.InvalidOptionException;
import com.hexagonkt.core.args.InvalidOptionSyntaxException;
import com.hexagonkt.core.args.Option;
import com.hexagonkt.core.args.OptionNeedsAValueException;
import com.hexagonkt.core.args.UnsupportedArgumentTypeException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\tH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002JJ\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0002\b\u00030\u00140\u00132\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u001c\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00042\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"Lcom/hexagonkt/core/args/OptionParser;", "", "()V", "BOOLEAN", "", "LONG_NAME_REGEX", "Lkotlin/text/Regex;", "SHORT_NAME_REGEX", "SUPPORTED_TYPES", "", "Lkotlin/reflect/KClass;", "hasUnsupportedParameters", "", "options", "Lcom/hexagonkt/core/args/Option;", "hasValidSyntax", "arg", "isOption", "parse", "Lkotlin/Result;", "", "args", "", "parse-gIAlu-s", "(Ljava/util/List;[Ljava/lang/String;)Ljava/lang/Object;", "removePrefixedDashes", "resolveParamValue", "option", "core"})
public final class OptionParser {
    @NotNull
    public static final OptionParser INSTANCE = new OptionParser();
    @NotNull
    private static final Regex LONG_NAME_REGEX = new Regex("--[a-z]+-?[a-z]+=?[a-zA-Z\\d.]*");
    @NotNull
    private static final Regex SHORT_NAME_REGEX = new Regex("-[a-z]+");
    @NotNull
    private static final List<KClass<? extends Object>> SUPPORTED_TYPES;
    @NotNull
    private static final String BOOLEAN = "kotlin.Boolean";

    private OptionParser() {
    }

    @NotNull
    public final Object parse-gIAlu-s(@NotNull List<? extends Option<?>> options, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (this.hasUnsupportedParameters(options)) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)UnsupportedArgumentTypeException.INSTANCE));
        }
        Map result = new LinkedHashMap();
        for (String arg : args) {
            if (!this.isOption(arg)) continue;
            if (!this.hasValidSyntax(arg)) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)InvalidOptionSyntaxException.INSTANCE));
            }
            boolean isLong = StringsKt.startsWith$default((String)arg, (String)"--", (boolean)false, (int)2, null);
            String optionWithoutPrefixedDashes = this.removePrefixedDashes(arg);
            if (isLong) {
                Object object;
                Option option;
                Iterable iterable;
                List split;
                block13: {
                    String[] stringArray = new String[]{"="};
                    split = StringsKt.split$default((CharSequence)optionWithoutPrefixedDashes, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    Iterable iterable2 = options;
                    for (Iterable iterable3 : iterable2) {
                        Option it = (Option)((Object)iterable3);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)CollectionsKt.first((List)split), (Object)it.getLongName())) continue;
                        iterable = iterable3;
                        break block13;
                    }
                    iterable = null;
                }
                if ((Option)((Object)iterable) == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)InvalidOptionException.INSTANCE));
                }
                Map map = result;
                if (split.size() > 1) {
                    object = this.resolveParamValue((String)split.get(1), option);
                } else if (Intrinsics.areEqual((Object)option.getType().getQualifiedName(), (Object)BOOLEAN)) {
                    object = true;
                } else {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)OptionNeedsAValueException.INSTANCE));
                }
                Object object2 = object;
                map.put(option, object2);
                continue;
            }
            CharSequence $this$forEach$iv = optionWithoutPrefixedDashes;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                Option option;
                Object v2;
                block14: {
                    char element$iv;
                    Iterable iterable3;
                    char shortName = element$iv = $this$forEach$iv.charAt(i);
                    boolean bl = false;
                    iterable3 = options;
                    for (Object t : iterable3) {
                        Option it = (Option)t;
                        boolean bl2 = false;
                        if (!(it.getShortName() == shortName)) continue;
                        v2 = t;
                        break block14;
                    }
                    v2 = null;
                }
                if ((Option)v2 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)InvalidOptionSyntaxException.INSTANCE));
                }
                result.put(option, true);
            }
        }
        return Result.constructor-impl((Object)result);
    }

    private final boolean hasUnsupportedParameters(List<? extends Option<?>> options) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = options;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Option it = (Option)element$iv;
                    boolean bl2 = false;
                    if (!(!SUPPORTED_TYPES.contains(it.getType()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isOption(String arg) {
        return StringsKt.startsWith$default((String)arg, (String)"-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)arg, (String)"--", (boolean)false, (int)2, null);
    }

    private final boolean hasValidSyntax(String arg) {
        return LONG_NAME_REGEX.matches((CharSequence)arg) || SHORT_NAME_REGEX.matches((CharSequence)arg);
    }

    private final String removePrefixedDashes(String arg) {
        String result = arg;
        while (StringsKt.startsWith$default((String)result, (String)"-", (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)result.substring(1), (String)"this as java.lang.String).substring(startIndex)");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object resolveParamValue(String arg, Option<?> option) {
        String string = option.getType().getQualifiedName();
        if (string == null) throw new IllegalStateException("not supported type".toString());
        int n = -1;
        switch (string.hashCode()) {
            case 411999259: {
                if (string.equals(BOOLEAN)) {
                    n = 1;
                }
                break;
            }
            case -2133280414: {
                if (string.equals("kotlin.Int")) {
                    n = 2;
                }
                break;
            }
            case -67829378: {
                if (string.equals("kotlin.Double")) {
                    n = 3;
                }
                break;
            }
            case 366142910: {
                if (string.equals("kotlin.String")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                Object object = Boolean.parseBoolean(arg);
                return object;
            }
            case 3: {
                Object object = Double.parseDouble(arg);
                return object;
            }
            case 2: {
                Object object = Integer.parseInt(arg);
                return object;
            }
            case 4: {
                Object object = arg;
                return object;
            }
            default: {
                throw new IllegalStateException("not supported type".toString());
            }
        }
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class), Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE)};
        SUPPORTED_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }
}

