/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.logging;

import com.hexagonkt.core.logging.Logger;
import com.hexagonkt.core.logging.LoggerPort;
import com.hexagonkt.core.logging.LoggingLevel;
import com.hexagonkt.core.logging.LoggingManager;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 /2\u00020\u0001:\u0001/B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J9\u0010\u0012\u001a\u00020\u000f\"\b\b\u0000\u0010\u0013*\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00132\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u0001H\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eJ\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020\u001eJ\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#J1\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u0011\u00a2\u0006\u0002\u0010*J)\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u0011\u00a2\u0006\u0002\u0010+J \u0010'\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u001b2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J\u0016\u0010-\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J\u0016\u0010.\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J9\u0010.\u001a\u00020\u000f\"\b\b\u0000\u0010\u0013*\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00132\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u0001H\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00060"}, d2={"Lcom/hexagonkt/core/logging/Logger;", "", "type", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "name", "", "(Ljava/lang/String;)V", "log", "Lcom/hexagonkt/core/logging/LoggerPort;", "getLog$core", "()Lcom/hexagonkt/core/logging/LoggerPort;", "getName", "()Ljava/lang/String;", "debug", "", "message", "Lkotlin/Function0;", "error", "E", "", "exception", "Lkotlin/Function1;", "(Ljava/lang/Throwable;Lkotlin/jvm/functions/Function1;)V", "flare", "formatNanos", "nanoseconds", "", "info", "isDebugEnabled", "", "isErrorEnabled", "isInfoEnabled", "isLoggerLevelEnabled", "level", "Lcom/hexagonkt/core/logging/LoggingLevel;", "isTraceEnabled", "isWarnEnabled", "setLoggerLevel", "time", "T", "block", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "startNanos", "trace", "warn", "Companion", "core"})
public final class Logger {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final LoggerPort log;
    @Deprecated
    @NotNull
    public static final String FLARE_PREFIX = ">>>>>>>>";

    public Logger(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.log = LoggingManager.INSTANCE.getAdapter().createLogger(this.name);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final LoggerPort getLog$core() {
        return this.log;
    }

    public Logger(@NotNull KClass<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String string = type.getQualifiedName();
        if (string == null) {
            throw new IllegalStateException("Cannot get qualified name of type".toString());
        }
        this(string);
    }

    public final void trace(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.log.log(LoggingLevel.TRACE, message);
    }

    public final void debug(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.log.log(LoggingLevel.DEBUG, message);
    }

    public final void info(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.log.log(LoggingLevel.INFO, message);
    }

    public final void warn(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.log.log(LoggingLevel.WARN, message);
    }

    public final void error(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.log.log(LoggingLevel.ERROR, message);
    }

    public final <E extends Throwable> void warn(@Nullable E exception, @NotNull Function1<? super E, ? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (exception == null) {
            this.log.log(LoggingLevel.WARN, (Function0<? extends Object>)((Function0)new Function0<Object>(message){
                final /* synthetic */ Function1<E, Object> $message;
                {
                    this.$message = $message;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$message.invoke(null);
                }
            }));
        } else {
            this.log.log(LoggingLevel.WARN, exception, message);
        }
    }

    public static /* synthetic */ void warn$default(Logger logger2, Throwable throwable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = warn.1.INSTANCE;
        }
        logger2.warn(throwable, function1);
    }

    public final <E extends Throwable> void error(@Nullable E exception, @NotNull Function1<? super E, ? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (exception == null) {
            this.log.log(LoggingLevel.ERROR, (Function0<? extends Object>)((Function0)new Function0<Object>(message){
                final /* synthetic */ Function1<E, Object> $message;
                {
                    this.$message = $message;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$message.invoke(null);
                }
            }));
        } else {
            this.log.log(LoggingLevel.ERROR, exception, message);
        }
    }

    public static /* synthetic */ void error$default(Logger logger2, Throwable throwable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = error.1.INSTANCE;
        }
        logger2.error(throwable, function1);
    }

    public final void flare(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.log.log(LoggingLevel.TRACE, (Function0<? extends Object>)((Function0)new Function0<Object>(message){
            final /* synthetic */ Function0<Object> $message;
            {
                this.$message = $message;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "\u001b[1m\u001b[5m>>>>>>>>\u001b[0m " + this.$message.invoke();
            }
        }));
    }

    public static /* synthetic */ void flare$default(Logger logger2, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = flare.1.INSTANCE;
        }
        logger2.flare((Function0<? extends Object>)function0);
    }

    public final void time(long startNanos, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.log.log(LoggingLevel.TRACE, (Function0<? extends Object>)((Function0)new Function0<Object>(message, this, startNanos){
            final /* synthetic */ Function0<Object> $message;
            final /* synthetic */ Logger this$0;
            final /* synthetic */ long $startNanos;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                this.$startNanos = $startNanos;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                StringBuilder stringBuilder = new StringBuilder();
                Object object = this.$message.invoke();
                if (object == null) {
                    object = "TIME";
                }
                return stringBuilder.append(object).append(" : ").append(Logger.access$formatNanos(this.this$0, System.nanoTime() - this.$startNanos)).toString();
            }
        }));
    }

    public static /* synthetic */ void time$default(Logger logger2, long l, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = time.1.INSTANCE;
        }
        logger2.time(l, (Function0<? extends Object>)function0);
    }

    public final <T> T time(@NotNull Function0<? extends Object> message, @NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long start = System.nanoTime();
        Object it = object = block.invoke();
        boolean bl = false;
        this.time(start, message);
        return (T)object;
    }

    public static /* synthetic */ Object time$default(Logger logger2, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = time.3.INSTANCE;
        }
        return logger2.time((Function0<? extends Object>)function0, function02);
    }

    public final <T> T time(@Nullable Object message, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.time((Function0<? extends Object>)((Function0)new Function0<Object>(message){
            final /* synthetic */ Object $message;
            {
                this.$message = $message;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$message;
            }
        }), block);
    }

    public final void setLoggerLevel(@NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        LoggingManager.INSTANCE.setLoggerLevel(this.name, level);
    }

    public final boolean isLoggerLevelEnabled(@NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return LoggingManager.INSTANCE.isLoggerLevelEnabled(this.name, level);
    }

    public final boolean isTraceEnabled() {
        return this.isLoggerLevelEnabled(LoggingLevel.TRACE);
    }

    public final boolean isDebugEnabled() {
        return this.isLoggerLevelEnabled(LoggingLevel.DEBUG);
    }

    public final boolean isInfoEnabled() {
        return this.isLoggerLevelEnabled(LoggingLevel.INFO);
    }

    public final boolean isWarnEnabled() {
        return this.isLoggerLevelEnabled(LoggingLevel.WARN);
    }

    public final boolean isErrorEnabled() {
        return this.isLoggerLevelEnabled(LoggingLevel.ERROR);
    }

    private final String formatNanos(long nanoseconds) {
        String string = "%1.3f ms";
        Object[] objectArray = new Object[]{(double)nanoseconds / 1000000.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    public static final /* synthetic */ String access$formatNanos(Logger $this, long nanoseconds) {
        return $this.formatNanos(nanoseconds);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/hexagonkt/core/logging/Logger$Companion;", "", "()V", "FLARE_PREFIX", "", "core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

