/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.logging;

import com.hexagonkt.core.logging.LoggingLevel;
import com.hexagonkt.core.logging.LoggingPort;
import com.hexagonkt.core.logging.jul.JulLoggingAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0016\u001a\u00020\u00112\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u001d\u001a\u00020\n2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u001e\u001a\u00020\u001f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/hexagonkt/core/logging/LoggingManager;", "", "()V", "adapter", "Lcom/hexagonkt/core/logging/LoggingPort;", "getAdapter", "()Lcom/hexagonkt/core/logging/LoggingPort;", "setAdapter", "(Lcom/hexagonkt/core/logging/LoggingPort;)V", "value", "", "defaultLoggerName", "getDefaultLoggerName", "()Ljava/lang/String;", "setDefaultLoggerName", "(Ljava/lang/String;)V", "useColor", "", "getUseColor", "()Z", "setUseColor", "(Z)V", "isLoggerLevelEnabled", "level", "Lcom/hexagonkt/core/logging/LoggingLevel;", "instance", "name", "type", "Lkotlin/reflect/KClass;", "qualifiedName", "setLoggerLevel", "", "core"})
public final class LoggingManager {
    @NotNull
    public static final LoggingManager INSTANCE = new LoggingManager();
    private static boolean useColor = true;
    @NotNull
    private static LoggingPort adapter = new JulLoggingAdapter(false, 1, null);
    @NotNull
    private static String defaultLoggerName = "com.hexagonkt.core.logging";

    private LoggingManager() {
    }

    public final boolean getUseColor() {
        return useColor;
    }

    public final void setUseColor(boolean bl) {
        useColor = bl;
    }

    @NotNull
    public final LoggingPort getAdapter() {
        return adapter;
    }

    public final void setAdapter(@NotNull LoggingPort loggingPort) {
        Intrinsics.checkNotNullParameter((Object)loggingPort, (String)"<set-?>");
        adapter = loggingPort;
    }

    @NotNull
    public final String getDefaultLoggerName() {
        return defaultLoggerName;
    }

    public final void setDefaultLoggerName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(((CharSequence)value).length() > 0)) {
            boolean bl = false;
            String string = "Default logger name cannot be empty string";
            throw new IllegalArgumentException(string.toString());
        }
        defaultLoggerName = value;
    }

    public final void setLoggerLevel(@NotNull String name2, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        adapter.setLoggerLevel(name2, level);
    }

    public final void setLoggerLevel(@NotNull Object instance, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.setLoggerLevel(Reflection.getOrCreateKotlinClass(instance.getClass()), level);
    }

    public final void setLoggerLevel(@NotNull KClass<?> type, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.setLoggerLevel(this.qualifiedName(type), level);
    }

    public final void setLoggerLevel(@NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.setLoggerLevel("", level);
    }

    public final boolean isLoggerLevelEnabled(@NotNull String name2, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return adapter.isLoggerLevelEnabled(name2, level);
    }

    public final boolean isLoggerLevelEnabled(@NotNull Object instance, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.isLoggerLevelEnabled(Reflection.getOrCreateKotlinClass(instance.getClass()), level);
    }

    public final boolean isLoggerLevelEnabled(@NotNull KClass<?> type, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.isLoggerLevelEnabled(this.qualifiedName(type), level);
    }

    public final boolean isLoggerLevelEnabled(@NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.isLoggerLevelEnabled("", level);
    }

    private final String qualifiedName(KClass<?> type) {
        String string = type.getQualifiedName();
        if (string == null) {
            throw new IllegalStateException("Cannot get qualified name of type".toString());
        }
        return string;
    }
}

