/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.logging.jul;

import com.hexagonkt.core.StringsKt;
import com.hexagonkt.core.logging.LoggerPort;
import com.hexagonkt.core.logging.LoggingLevel;
import com.hexagonkt.core.logging.LoggingManager;
import com.hexagonkt.core.logging.LoggingPort;
import com.hexagonkt.core.logging.jul.PatternFormat;
import com.hexagonkt.core.logging.jul.SystemOutHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/hexagonkt/core/logging/jul/JulLoggingAdapter;", "Lcom/hexagonkt/core/logging/LoggingPort;", "useColor", "", "(Z)V", "createLogger", "Lcom/hexagonkt/core/logging/LoggerPort;", "name", "", "isLoggerLevelEnabled", "level", "Lcom/hexagonkt/core/logging/LoggingLevel;", "mapLevel", "Ljava/util/logging/Level;", "mapLevel$core", "setLoggerLevel", "", "core"})
public final class JulLoggingAdapter
implements LoggingPort {
    private final boolean useColor;

    public JulLoggingAdapter(boolean useColor) {
        this.useColor = useColor;
        LoggingManager.INSTANCE.setUseColor(this.useColor);
        Logger root = Logger.getLogger("");
        Handler[] handlerArray = root.getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"root.handlers");
        for (Handler hnd : handlerArray) {
            root.removeHandler(hnd);
        }
        root.addHandler(new SystemOutHandler(new PatternFormat(this.useColor)));
        root.setLevel(Level.INFO);
    }

    public /* synthetic */ JulLoggingAdapter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = LoggingManager.INSTANCE.getUseColor();
        }
        this(bl);
    }

    @Override
    public void setLoggerLevel(@NotNull String name2, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Logger.getLogger(name2).setLevel(this.mapLevel$core(level));
    }

    @Override
    @NotNull
    public LoggerPort createLogger(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new LoggerPort(name2, this){
            @NotNull
            private final Logger log;
            final /* synthetic */ JulLoggingAdapter this$0;
            {
                this.this$0 = $receiver;
                Logger logger2 = Logger.getLogger($name);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(name)");
                this.log = logger2;
            }

            @NotNull
            public final Logger getLog() {
                return this.log;
            }

            public void log(@NotNull LoggingLevel level, @NotNull Function0<? extends Object> message) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                Intrinsics.checkNotNullParameter(message, (String)"message");
                Level julLevel = this.this$0.mapLevel$core(level);
                if (this.log.isLoggable(julLevel)) {
                    this.log.log(julLevel, this.color(String.valueOf(message.invoke())));
                }
            }

            public <E extends Throwable> void log(@NotNull LoggingLevel level, @NotNull E exception, @NotNull Function1<? super E, ? extends Object> message) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                Intrinsics.checkNotNullParameter(exception, (String)"exception");
                Intrinsics.checkNotNullParameter(message, (String)"message");
                Level julLevel = this.this$0.mapLevel$core(level);
                if (this.log.isLoggable(julLevel)) {
                    this.log.log(julLevel, this.color(String.valueOf(message.invoke(exception))), exception);
                }
            }

            private final String color(String message) {
                return JulLoggingAdapter.access$getUseColor$p(this.this$0) ? message : StringsKt.stripAnsi(message);
            }
        };
    }

    @Override
    public boolean isLoggerLevelEnabled(@NotNull String name2, @NotNull LoggingLevel level) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return Logger.getLogger(name2).isLoggable(this.mapLevel$core(level));
    }

    @NotNull
    public final Level mapLevel$core(@NotNull LoggingLevel level) {
        Level level2;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                Level level3 = Level.FINER;
                level2 = level3;
                Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"FINER");
                break;
            }
            case 2: {
                Level level4 = Level.FINE;
                level2 = level4;
                Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"FINE");
                break;
            }
            case 3: {
                Level level5 = Level.INFO;
                level2 = level5;
                Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"INFO");
                break;
            }
            case 4: {
                Level level6 = Level.WARNING;
                level2 = level6;
                Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"WARNING");
                break;
            }
            case 5: {
                Level level7 = Level.SEVERE;
                level2 = level7;
                Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"SEVERE");
                break;
            }
            case 6: {
                Level level8 = Level.OFF;
                level2 = level8;
                Intrinsics.checkNotNullExpressionValue((Object)level8, (String)"OFF");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return level2;
    }

    public JulLoggingAdapter() {
        this(false, 1, null);
    }

    public static final /* synthetic */ boolean access$getUseColor$p(JulLoggingAdapter $this) {
        return $this.useColor;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoggingLevel.values().length];
            nArray[LoggingLevel.TRACE.ordinal()] = 1;
            nArray[LoggingLevel.DEBUG.ordinal()] = 2;
            nArray[LoggingLevel.INFO.ordinal()] = 3;
            nArray[LoggingLevel.WARN.ordinal()] = 4;
            nArray[LoggingLevel.ERROR.ordinal()] = 5;
            nArray[LoggingLevel.OFF.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

