/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.logging.jul;

import com.hexagonkt.core.HelpersKt;
import com.hexagonkt.core.StringsKt;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/hexagonkt/core/logging/jul/PatternFormat;", "Ljava/util/logging/Formatter;", "useColor", "", "(Z)V", "levelColors", "", "Ljava/util/logging/Level;", "", "levelNames", "pattern", "format", "record", "Ljava/util/logging/LogRecord;", "Companion", "core"})
public final class PatternFormat
extends Formatter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean useColor;
    @NotNull
    private final String pattern;
    @NotNull
    private final Map<Level, String> levelColors;
    @NotNull
    private final Map<Level, String> levelNames;
    @Deprecated
    @NotNull
    public static final String TIMESTAMP = "%tH:%<tM:%<tS,%<tL";
    @Deprecated
    @NotNull
    public static final String LEVEL = "%-5s";
    @Deprecated
    @NotNull
    public static final String THREAD = "[%-15s]";
    @Deprecated
    @NotNull
    public static final String LOGGER = "%-30s";
    @Deprecated
    @NotNull
    public static final String PATTERN = "%tH:%<tM:%<tS,%<tL %-5s [%-15s] %-30s | %s%n";
    @Deprecated
    @NotNull
    public static final String COLOR_PATTERN = "\u001b[90m%tH:%<tM:%<tS,%<tL %s%-5s\u001b[0m \u001b[35m[%-15s] \u001b[36m%-30s\u001b[0m | %s%n";

    public PatternFormat(boolean useColor) {
        this.useColor = useColor;
        this.pattern = this.useColor ? COLOR_PATTERN : PATTERN;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Level.FINER, (Object)"\u001b[39m"), TuplesKt.to((Object)Level.FINE, (Object)"\u001b[39m"), TuplesKt.to((Object)Level.INFO, (Object)"\u001b[34m"), TuplesKt.to((Object)Level.WARNING, (Object)"\u001b[33m"), TuplesKt.to((Object)Level.SEVERE, (Object)"\u001b[31m\u001b[1m")};
        this.levelColors = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)Level.FINER, (Object)"TRACE"), TuplesKt.to((Object)Level.FINE, (Object)"DEBUG"), TuplesKt.to((Object)Level.INFO, (Object)"INFO"), TuplesKt.to((Object)Level.WARNING, (Object)"WARN"), TuplesKt.to((Object)Level.SEVERE, (Object)"ERROR")};
        this.levelNames = MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String format(@NotNull LogRecord record) {
        String string;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Instant instant = Instant.ofEpochMilli(record.getMillis());
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        Throwable thrown = record.getThrown();
        String trace2 = thrown == null ? "" : (this.useColor ? kotlin.text.StringsKt.replace$default((String)(StringsKt.getEol() + HelpersKt.toText$default(thrown, null, 1, null)), (String)"\n", (String)"\n\u001b[31m", (boolean)false, (int)4, null) : StringsKt.getEol() + HelpersKt.toText$default(thrown, null, 1, null));
        Level level = record.getLevel();
        String string2 = this.levelNames.get(level);
        if (string2 == null) {
            HelpersKt.getFail();
            throw new KotlinNothingValueException();
        }
        String levelName = string2;
        String string3 = this.levelColors.get(level);
        if (string3 == null) {
            string3 = "\u001b[34m";
        }
        String levelColor = string3;
        String message = record.getMessage();
        String loggerName = record.getLoggerName();
        String threadName = Thread.currentThread().getName();
        if (this.useColor) {
            String string4 = this.pattern;
            Object[] objectArray = new Object[]{dateTime, levelColor, levelName, threadName, loggerName, message + trace2};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
        } else {
            String string6 = this.pattern;
            Object[] objectArray = new Object[]{dateTime, levelName, threadName, loggerName, message + trace2};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(this, *args)");
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/hexagonkt/core/logging/jul/PatternFormat$Companion;", "", "()V", "COLOR_PATTERN", "", "LEVEL", "LOGGER", "PATTERN", "THREAD", "TIMESTAMP", "core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

