/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.media;

import com.hexagonkt.core.HelpersKt;
import com.hexagonkt.core.media.MediaType;
import com.hexagonkt.core.media.MediaTypeGroup;
import com.hexagonkt.core.media.MediaTypesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/hexagonkt/core/media/CustomMedia;", "Lcom/hexagonkt/core/media/MediaType;", "group", "Lcom/hexagonkt/core/media/MediaTypeGroup;", "type", "", "(Lcom/hexagonkt/core/media/MediaTypeGroup;Ljava/lang/String;)V", "fullType", "getFullType", "()Ljava/lang/String;", "getGroup", "()Lcom/hexagonkt/core/media/MediaTypeGroup;", "getType", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "core"})
public final class CustomMedia
implements MediaType {
    @NotNull
    private final MediaTypeGroup group;
    @NotNull
    private final String type;
    @NotNull
    private final String fullType;

    public CustomMedia(@NotNull MediaTypeGroup group, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.group = group;
        this.type = type;
        this.fullType = this.getGroup().getText() + '/' + this.getType();
        if (!HelpersKt.getDisableChecks()) {
            CharSequence charSequence = this.getType();
            if (!MediaTypesKt.getMediaTypeFormat().matches(charSequence)) {
                boolean bl = false;
                String string = "Type must match '" + MediaTypesKt.getMediaTypeFormat() + "': " + this.getType();
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @Override
    @NotNull
    public MediaTypeGroup getGroup() {
        return this.group;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getFullType() {
        return this.fullType;
    }

    @NotNull
    public final MediaTypeGroup component1() {
        return this.getGroup();
    }

    @NotNull
    public final String component2() {
        return this.getType();
    }

    @NotNull
    public final CustomMedia copy(@NotNull MediaTypeGroup group, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new CustomMedia(group, type);
    }

    public static /* synthetic */ CustomMedia copy$default(CustomMedia customMedia, MediaTypeGroup mediaTypeGroup, String string, int n, Object object) {
        if ((n & 1) != 0) {
            mediaTypeGroup = customMedia.getGroup();
        }
        if ((n & 2) != 0) {
            string = customMedia.getType();
        }
        return customMedia.copy(mediaTypeGroup, string);
    }

    @NotNull
    public String toString() {
        return "CustomMedia(group=" + (Object)((Object)this.getGroup()) + ", type=" + this.getType() + ')';
    }

    public int hashCode() {
        int result = this.getGroup().hashCode();
        result = result * 31 + this.getType().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CustomMedia)) {
            return false;
        }
        CustomMedia customMedia = (CustomMedia)other;
        if (this.getGroup() != customMedia.getGroup()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getType(), (Object)customMedia.getType());
    }
}

