/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.media;

import com.hexagonkt.core.media.ApplicationMedia;
import com.hexagonkt.core.media.AudioMedia;
import com.hexagonkt.core.media.CustomMedia;
import com.hexagonkt.core.media.FontMedia;
import com.hexagonkt.core.media.ImageMedia;
import com.hexagonkt.core.media.MediaType;
import com.hexagonkt.core.media.MediaTypeGroup;
import com.hexagonkt.core.media.TextMedia;
import com.hexagonkt.core.media.VideoMedia;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0006\u001a\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\" \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"defaultMediaType", "Lcom/hexagonkt/core/media/MediaType;", "getDefaultMediaType", "()Lcom/hexagonkt/core/media/MediaType;", "extensions", "", "", "getExtensions", "()Ljava/util/Map;", "mediaTypeFormat", "Lkotlin/text/Regex;", "getMediaTypeFormat", "()Lkotlin/text/Regex;", "mediaTypeOf", "file", "Ljava/io/File;", "url", "Ljava/net/URL;", "extension", "mediaTypeOfOrNull", "parseMediaType", "fullType", "pathExtension", "path", "core"})
public final class MediaTypesKt {
    @NotNull
    private static final Regex mediaTypeFormat = new Regex("[\\w+.-]+");
    @NotNull
    private static final MediaType defaultMediaType = ApplicationMedia.OCTET_STREAM;
    @NotNull
    private static final Map<String, MediaType> extensions;

    @NotNull
    public static final MediaType parseMediaType(@NotNull String fullType) {
        Intrinsics.checkNotNullParameter((Object)fullType, (String)"fullType");
        String[] stringArray = new String[]{"/"};
        List groupType = StringsKt.split$default((CharSequence)fullType, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!(groupType.size() == 2)) {
            boolean $i$a$-require-MediaTypesKt$parseMediaType$22 = false;
            String $i$a$-require-MediaTypesKt$parseMediaType$22 = "Media type format must be <type>/<subtype>: " + fullType;
            throw new IllegalArgumentException($i$a$-require-MediaTypesKt$parseMediaType$22.toString());
        }
        String string = ((String)CollectionsKt.first((List)groupType)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String groupText = string;
        MediaTypeGroup group = MediaTypeGroup.valueOf(groupText);
        String type = (String)CollectionsKt.last((List)groupType);
        return new CustomMedia(group, type);
    }

    @NotNull
    public static final Regex getMediaTypeFormat() {
        return mediaTypeFormat;
    }

    @NotNull
    public static final MediaType getDefaultMediaType() {
        return defaultMediaType;
    }

    @Nullable
    public static final MediaType mediaTypeOfOrNull(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.file");
        return MediaTypesKt.mediaTypeOfOrNull(MediaTypesKt.pathExtension(string));
    }

    @Nullable
    public static final MediaType mediaTypeOfOrNull(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MediaTypesKt.mediaTypeOfOrNull(FilesKt.getExtension((File)file));
    }

    @Nullable
    public static final MediaType mediaTypeOfOrNull(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return extensions.get(extension);
    }

    @NotNull
    public static final MediaType mediaTypeOf(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        MediaType mediaType = MediaTypesKt.mediaTypeOfOrNull(url);
        if (mediaType == null) {
            throw new IllegalStateException(("Media type not found for: '" + url + "' URL").toString());
        }
        return mediaType;
    }

    @NotNull
    public static final MediaType mediaTypeOf(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MediaType mediaType = MediaTypesKt.mediaTypeOfOrNull(file);
        if (mediaType == null) {
            throw new IllegalStateException(("Media type not found for: '" + file + "' file").toString());
        }
        return mediaType;
    }

    @NotNull
    public static final MediaType mediaTypeOf(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        MediaType mediaType = MediaTypesKt.mediaTypeOfOrNull(extension);
        if (mediaType == null) {
            throw new IllegalStateException(("Media type not found for: '" + extension + "' extension").toString());
        }
        return mediaType;
    }

    private static final String pathExtension(String path) {
        return StringsKt.substringAfterLast$default((String)path, (char)'.', null, (int)2, null);
    }

    @NotNull
    public static final Map<String, MediaType> getExtensions() {
        return extensions;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"avro", (Object)ApplicationMedia.AVRO), TuplesKt.to((Object)"cbor", (Object)ApplicationMedia.CBOR), TuplesKt.to((Object)"json", (Object)ApplicationMedia.JSON), TuplesKt.to((Object)"yaml", (Object)ApplicationMedia.YAML), TuplesKt.to((Object)"yml", (Object)ApplicationMedia.YAML), TuplesKt.to((Object)"xml", (Object)ApplicationMedia.XML), TuplesKt.to((Object)"bin", (Object)ApplicationMedia.OCTET_STREAM), TuplesKt.to((Object)"lha", (Object)ApplicationMedia.OCTET_STREAM), TuplesKt.to((Object)"lzh", (Object)ApplicationMedia.OCTET_STREAM), TuplesKt.to((Object)"exe", (Object)ApplicationMedia.OCTET_STREAM), TuplesKt.to((Object)"so", (Object)ApplicationMedia.OCTET_STREAM), TuplesKt.to((Object)"class", (Object)ApplicationMedia.OCTET_STREAM), TuplesKt.to((Object)"pdf", (Object)ApplicationMedia.PDF), TuplesKt.to((Object)"ai", (Object)ApplicationMedia.POSTSCRIPT), TuplesKt.to((Object)"eps", (Object)ApplicationMedia.POSTSCRIPT), TuplesKt.to((Object)"ps", (Object)ApplicationMedia.POSTSCRIPT), TuplesKt.to((Object)"rtf", (Object)ApplicationMedia.RTF), TuplesKt.to((Object)"z", (Object)ApplicationMedia.COMPRESS), TuplesKt.to((Object)"csh", (Object)ApplicationMedia.X_CSH), TuplesKt.to((Object)"gtar", (Object)ApplicationMedia.X_GTAR), TuplesKt.to((Object)"gz", (Object)ApplicationMedia.GZIP), TuplesKt.to((Object)"gzip", (Object)ApplicationMedia.GZIP), TuplesKt.to((Object)"latex", (Object)ApplicationMedia.X_LATEX), TuplesKt.to((Object)"sh", (Object)ApplicationMedia.X_SH), TuplesKt.to((Object)"tar", (Object)ApplicationMedia.X_TAR), TuplesKt.to((Object)"tcl", (Object)ApplicationMedia.X_TCL), TuplesKt.to((Object)"tex", (Object)ApplicationMedia.X_TEX), TuplesKt.to((Object)"texinfo", (Object)ApplicationMedia.X_TEXINFO), TuplesKt.to((Object)"texi", (Object)ApplicationMedia.X_TEXINFO), TuplesKt.to((Object)"zip", (Object)ApplicationMedia.ZIP), TuplesKt.to((Object)"epub", (Object)ApplicationMedia.EPUB_ZIP), TuplesKt.to((Object)"jar", (Object)ApplicationMedia.JAVA_ARCHIVE), TuplesKt.to((Object)"ogx", (Object)ApplicationMedia.OGG), TuplesKt.to((Object)"rar", (Object)ApplicationMedia.RAR), TuplesKt.to((Object)"7z", (Object)ApplicationMedia.A7Z), TuplesKt.to((Object)"bz", (Object)ApplicationMedia.BZIP), TuplesKt.to((Object)"bz2", (Object)ApplicationMedia.BZIP2), TuplesKt.to((Object)"cda", (Object)ApplicationMedia.CDF), TuplesKt.to((Object)"php", (Object)ApplicationMedia.PHP), TuplesKt.to((Object)"xhtml", (Object)ApplicationMedia.XHTML), TuplesKt.to((Object)"webmanifest", (Object)ApplicationMedia.WEB_MANIFEST), TuplesKt.to((Object)"toml", (Object)ApplicationMedia.TOML), TuplesKt.to((Object)"au", (Object)AudioMedia.BASIC), TuplesKt.to((Object)"snd", (Object)AudioMedia.BASIC), TuplesKt.to((Object)"mpga", (Object)AudioMedia.MPEG), TuplesKt.to((Object)"mp2", (Object)AudioMedia.MPEG), TuplesKt.to((Object)"mp2a", (Object)AudioMedia.MPEG), TuplesKt.to((Object)"mp3", (Object)AudioMedia.MPEG), TuplesKt.to((Object)"m2a", (Object)AudioMedia.MPEG), TuplesKt.to((Object)"m3a", (Object)AudioMedia.MPEG), TuplesKt.to((Object)"wav", (Object)AudioMedia.WAV), TuplesKt.to((Object)"aac", (Object)AudioMedia.AAC), TuplesKt.to((Object)"mid", (Object)AudioMedia.MIDI), TuplesKt.to((Object)"midi", (Object)AudioMedia.MIDI), TuplesKt.to((Object)"oga", (Object)AudioMedia.OGG), TuplesKt.to((Object)"opus", (Object)AudioMedia.OPUS), TuplesKt.to((Object)"weba", (Object)AudioMedia.WEBM), TuplesKt.to((Object)"otf", (Object)FontMedia.OTF), TuplesKt.to((Object)"ttf", (Object)FontMedia.TTF), TuplesKt.to((Object)"woff", (Object)FontMedia.WOFF), TuplesKt.to((Object)"woff2", (Object)FontMedia.WOFF2), TuplesKt.to((Object)"gif", (Object)ImageMedia.GIF), TuplesKt.to((Object)"jpeg", (Object)ImageMedia.JPEG), TuplesKt.to((Object)"jpg", (Object)ImageMedia.JPEG), TuplesKt.to((Object)"png", (Object)ImageMedia.PNG), TuplesKt.to((Object)"tiff", (Object)ImageMedia.TIFF), TuplesKt.to((Object)"tif", (Object)ImageMedia.TIFF), TuplesKt.to((Object)"svg", (Object)ImageMedia.SVG), TuplesKt.to((Object)"ico", (Object)ImageMedia.ICO), TuplesKt.to((Object)"webp", (Object)ImageMedia.WEBP), TuplesKt.to((Object)"csv", (Object)TextMedia.CSV), TuplesKt.to((Object)"properties", (Object)TextMedia.X_JAVA_PROPERTIES), TuplesKt.to((Object)"js", (Object)TextMedia.JAVASCRIPT), TuplesKt.to((Object)"css", (Object)TextMedia.CSS), TuplesKt.to((Object)"html", (Object)TextMedia.HTML), TuplesKt.to((Object)"htm", (Object)TextMedia.HTML), TuplesKt.to((Object)"md", (Object)TextMedia.MARKDOWN), TuplesKt.to((Object)"txt", (Object)TextMedia.PLAIN), TuplesKt.to((Object)"log", (Object)TextMedia.PLAIN), TuplesKt.to((Object)"rtx", (Object)TextMedia.RICHTEXT), TuplesKt.to((Object)"tsv", (Object)TextMedia.TAB_SEPARATED_VALUES), TuplesKt.to((Object)"ics", (Object)TextMedia.CALENDAR), TuplesKt.to((Object)"mpeg", (Object)VideoMedia.MPEG), TuplesKt.to((Object)"mpg", (Object)VideoMedia.MPEG), TuplesKt.to((Object)"mpe", (Object)VideoMedia.MPEG), TuplesKt.to((Object)"m1v", (Object)VideoMedia.MPEG), TuplesKt.to((Object)"m2v", (Object)VideoMedia.MPEG), TuplesKt.to((Object)"qt", (Object)VideoMedia.QUICKTIME), TuplesKt.to((Object)"mov", (Object)VideoMedia.QUICKTIME), TuplesKt.to((Object)"avi", (Object)VideoMedia.X_MSVIDEO), TuplesKt.to((Object)"mp4", (Object)VideoMedia.MP4), TuplesKt.to((Object)"ogv", (Object)VideoMedia.OGG), TuplesKt.to((Object)"webm", (Object)VideoMedia.WEBM)};
        extensions = MapsKt.mapOf((Pair[])pairArray);
    }
}

