/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.security;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0001\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"chainHmac", "", "algorithm", "", "fields", "", "(Ljava/lang/String;[Ljava/lang/String;)[B", "hash", "data", "hmac", "key", "sign", "core"})
public final class CryptoKt {
    @NotNull
    public static final byte[] hmac(@NotNull String algorithm, @NotNull byte[] data2, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        byte[] byArray = mac.doFinal(data2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mac.doFinal(data)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] chainHmac(@NotNull String algorithm, String ... fields) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        String[] $this$map$iv = fields;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo2 = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var10_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean $i$f$chainHmac$toByteArray = false;
            boolean bl = false;
            byte[] byArray = p0.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            collection.add(byArray);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void field;
            byte[] $i$f$mapTo2 = (byte[])iterator$iv.next();
            byte[] data2 = (byte[])accumulator$iv;
            boolean bl = false;
            accumulator$iv = CryptoKt.hmac(algorithm, (byte[])field, data2);
        }
        return (byte[])accumulator$iv;
    }

    @NotNull
    public static final byte[] hash(@NotNull String algorithm, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(data2);
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest()");
        return byArray;
    }

    @NotNull
    public static final byte[] hash(@NotNull String algorithm, @NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string = data2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return CryptoKt.hash(algorithm, byArray);
    }

    @NotNull
    public static final byte[] sign(@NotNull String algorithm, @NotNull String data2, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = data2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return CryptoKt.hmac(algorithm, byArray, key);
    }
}

