/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.core.security;

import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"loadKeyStore", "Ljava/security/KeyStore;", "resource", "Ljava/net/URL;", "password", "", "getPrivateKey", "Ljava/security/interfaces/RSAPrivateKey;", "alias", "getPublicKey", "Ljava/security/interfaces/RSAPublicKey;", "core"})
public final class KeyStoresKt {
    @NotNull
    public static final KeyStore loadKeyStore(@NotNull URL resource, @NotNull String password) {
        KeyStore keyStore;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        KeyStore $this$loadKeyStore_u24lambda_u2d0 = keyStore = KeyStore.getInstance("PKCS12");
        boolean bl = false;
        InputStream inputStream = resource.openStream();
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        $this$loadKeyStore_u24lambda_u2d0.load(inputStream, cArray);
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"getInstance(\"PKCS12\").ap\u2026word.toCharArray())\n    }");
        return keyStore2;
    }

    @NotNull
    public static final RSAPrivateKey getPrivateKey(@NotNull KeyStore $this$getPrivateKey, @NotNull String alias, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrivateKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        Key key = $this$getPrivateKey.getKey(alias, cArray);
        if (key == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        }
        return (RSAPrivateKey)key;
    }

    @NotNull
    public static final RSAPublicKey getPublicKey(@NotNull KeyStore $this$getPublicKey, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)$this$getPublicKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        PublicKey publicKey = $this$getPublicKey.getCertificate(alias).getPublicKey();
        if (publicKey == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        }
        return (RSAPublicKey)publicKey;
    }
}

