/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http;

import com.hexagonkt.core.HelpersKt;
import com.hexagonkt.core.Jvm;
import com.hexagonkt.core.media.MediaType;
import com.hexagonkt.http.HttpKt;
import com.hexagonkt.http.model.ContentType;
import com.hexagonkt.http.model.Header;
import com.hexagonkt.http.model.HttpField;
import com.hexagonkt.http.model.HttpFields;
import com.hexagonkt.http.model.QueryParameter;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u0014\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002\u001a\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00142\u0006\u0010\u001d\u001a\u00020\u0002\u001a\n\u0010\u001e\u001a\u00020\u0002*\u00020\u001f\u001a\n\u0010\u001e\u001a\u00020\u0002*\u00020 \u001a\n\u0010!\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\"\u001a\u00020\u0002*\u00020\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"checkedHeaders", "", "", "getCheckedHeaders", "()Ljava/util/List;", "gmtZone", "Ljava/time/ZoneId;", "getGmtZone", "()Ljava/time/ZoneId;", "httpDateFormatter", "Ljava/time/format/DateTimeFormatter;", "getHttpDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "bodyToBytes", "", "body", "", "checkHeaders", "", "headers", "Lcom/hexagonkt/http/model/HttpFields;", "Lcom/hexagonkt/http/model/Header;", "formatQueryString", "parameters", "Lcom/hexagonkt/http/model/QueryParameter;", "parseContentType", "Lcom/hexagonkt/http/model/ContentType;", "contentType", "parseQueryString", "query", "toHttpFormat", "Ljava/time/Instant;", "Ljava/time/LocalDateTime;", "urlDecode", "urlEncode", "http"})
public final class HttpKt {
    @NotNull
    private static final List<String> checkedHeaders;
    @NotNull
    private static final ZoneId gmtZone;
    @NotNull
    private static final DateTimeFormatter httpDateFormatter;

    @NotNull
    public static final List<String> getCheckedHeaders() {
        return checkedHeaders;
    }

    @NotNull
    public static final ZoneId getGmtZone() {
        return gmtZone;
    }

    @NotNull
    public static final DateTimeFormatter getHttpDateFormatter() {
        return httpDateFormatter;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkHeaders(@NotNull HttpFields<Header> headers) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        Set<String> headersKeys;
        block9: {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            if (HelpersKt.getDisableChecks()) {
                return;
            }
            headersKeys = headers.getHttpFields().keySet();
            Iterable $this$all$iv = headersKeys;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    boolean bl2;
                    block8: {
                        String key = (String)element$iv2;
                        boolean bl3 = false;
                        CharSequence $this$all$iv2 = key;
                        boolean $i$f$all2 = false;
                        for (int i = 0; i < $this$all$iv2.length(); ++i) {
                            char element$iv3;
                            char it = element$iv3 = $this$all$iv2.charAt(i);
                            boolean bl4 = false;
                            if (Character.isLowerCase(it) || Character.isDigit(it) || it == '-') continue;
                            bl2 = false;
                            break block8;
                        }
                        bl2 = true;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-check-HttpKt$checkHeaders$42 = false;
            String invalidHeaders2 = CollectionsKt.joinToString$default((Iterable)headersKeys, (CharSequence)",", null, null, (int)0, null, (Function1)checkHeaders.2.invalidHeaders.1.INSTANCE, (int)30, null);
            String $i$a$-check-HttpKt$checkHeaders$42 = "Header names must be lower-case and contain only letters, digits or '-': " + invalidHeaders2;
            throw new IllegalStateException($i$a$-check-HttpKt$checkHeaders$42.toString());
        }
        Iterable $this$filter$iv = checkedHeaders;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl5 = false;
            if (!headers.getHttpFields().containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invalidHeaders3 = (List)destination$iv$iv;
        if (!invalidHeaders3.isEmpty()) {
            boolean bl6 = false;
            String invalidHeadersText2 = CollectionsKt.joinToString$default((Iterable)invalidHeaders3, (CharSequence)",", null, null, (int)0, null, (Function1)checkHeaders.3.invalidHeadersText.1.INSTANCE, (int)30, null);
            String string = StringsKt.trimIndent((String)("\n        Special headers should be handled with their respective properties (i.e.: contentType)\n        instead setting them in the headers map. Ignored headers: " + invalidHeadersText2 + "\n        "));
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpFields<QueryParameter> parseQueryString(@NotNull String query) {
        HttpFields httpFields;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (StringsKt.isBlank((CharSequence)query)) {
            httpFields = new HttpFields((HttpField[])new QueryParameter[0]);
        } else {
            Object $this$mapValuesTo$iv$iv;
            Object value$iv$iv$iv;
            Object $this$getOrPut$iv$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable p0;
            Pair it;
            boolean bl;
            Object object;
            Object object2;
            Iterable $this$mapTo$iv$iv;
            CharSequence charSequence = query;
            Regex regex = new Regex("&");
            int n = 0;
            Object $this$map$iv = regex.split(charSequence, n);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                object2 = (String)t;
                object = destination$iv$iv;
                bl = false;
                String[] stringArray = new String[]{"="};
                Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    String string = (String)item$iv$iv2;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)((Object)p0)))).toString());
                }
                List keyValue = (List)destination$iv$iv2;
                String key = (String)keyValue.get(0);
                String value = keyValue.size() == 2 ? (String)keyValue.get(1) : "";
                object.add(TuplesKt.to((Object)HttpKt.urlDecode(key), (Object)HttpKt.urlDecode(value)));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                it = (Pair)t;
                bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it.getFirst()));
                if (!bl2) continue;
                destination$iv$iv.add(t);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object3;
                Object t = iterator.next();
                it = (Pair)t;
                bl = false;
                key$iv$iv = (String)it.getFirst();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(t);
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean bl3 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapTo$iv$iv3;
                void pair;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean bl4 = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = $this$getOrPut$iv$iv$iv;
                boolean bl5 = false;
                Iterable $this$map$iv3 = (Iterable)pair.getValue();
                boolean $i$f$map3 = false;
                p0 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it2;
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add((String)it2.getSecond());
                }
                List list = (List)destination$iv$iv3;
                object.put(k, list);
            }
            $this$map$iv = destination$iv$iv;
            $i$f$map = false;
            $this$mapValuesTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                object2 = entry;
                object = destination$iv$iv;
                boolean bl5 = false;
                String k = (String)object2.getKey();
                List v = (List)object2.getValue();
                object.add(new QueryParameter(k, v));
            }
            List list = (List)destination$iv$iv;
            httpFields = new HttpFields(list);
        }
        return httpFields;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String formatQueryString(@NotNull HttpFields<QueryParameter> parameters2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Iterable $this$filter$iv = parameters2.getAllPairs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it.getFirst()));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, (Function1)formatQueryString.2.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String urlDecode(@NotNull String $this$urlDecode) {
        Intrinsics.checkNotNullParameter((Object)$this$urlDecode, (String)"<this>");
        String string = URLDecoder.decode($this$urlDecode, Jvm.INSTANCE.getCharset().name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(this, Jvm.charset.name())");
        return string;
    }

    @NotNull
    public static final String urlEncode(@NotNull String $this$urlEncode) {
        Intrinsics.checkNotNullParameter((Object)$this$urlEncode, (String)"<this>");
        String string = URLEncoder.encode($this$urlEncode, Jvm.INSTANCE.getCharset().name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(this, Jvm.charset.name())");
        return string;
    }

    @NotNull
    public static final String toHttpFormat(@NotNull LocalDateTime $this$toHttpFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toHttpFormat, (String)"<this>");
        String string = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.of($this$toHttpFormat, gmtZone));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RFC_1123_DATE_TIME.forma\u2026teTime.of(this, gmtZone))");
        return string;
    }

    @NotNull
    public static final String toHttpFormat(@NotNull Instant $this$toHttpFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toHttpFormat, (String)"<this>");
        String string = httpDateFormatter.format($this$toHttpFormat);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpDateFormatter.format(this)");
        return string;
    }

    @NotNull
    public static final ContentType parseContentType(@NotNull String contentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        String[] stringArray = new String[]{";"};
        List typeParameter = StringsKt.split$default((CharSequence)contentType, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String fullType = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)typeParameter)))).toString();
        MediaType mimeType = MediaType.Companion.invoke(fullType);
        block0 : switch (typeParameter.size()) {
            case 1: {
                contentType2 = new ContentType(mimeType, null, null, null, 14, null);
                break;
            }
            case 2: {
                String parameter = (String)CollectionsKt.last((List)typeParameter);
                String[] stringArray2 = new String[]{"="};
                List nameValue = StringsKt.split$default((CharSequence)parameter, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                if (nameValue.size() != 2) {
                    throw new IllegalStateException(("Invalid content type format: " + contentType).toString());
                }
                String name = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)nameValue)))).toString();
                String value = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.last((List)nameValue)))).toString();
                String string = ((Object)StringsKt.trim((CharSequence)name)).toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                switch (string) {
                    case "boundary": {
                        contentType2 = new ContentType(mimeType, value, null, null, 12, null);
                        break block0;
                    }
                    case "charset": {
                        contentType2 = new ContentType(mimeType, null, Charset.forName(value), null, 10, null);
                        break block0;
                    }
                    case "q": {
                        contentType2 = new ContentType(mimeType, null, null, Double.parseDouble(value), 6, null);
                        break block0;
                    }
                }
                throw new IllegalStateException(("Invalid content type format: " + contentType).toString());
            }
            default: {
                throw new IllegalStateException(("Invalid content type format: " + contentType).toString());
            }
        }
        return contentType2;
    }

    @NotNull
    public static final byte[] bodyToBytes(@NotNull Object body) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Object object = body;
        if (object instanceof String) {
            String string = (String)body;
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        } else if (object instanceof byte[]) {
            byArray = (byte[])body;
        } else if (object instanceof Integer) {
            byte[] byArray3 = BigInteger.valueOf(((Number)body).intValue()).toByteArray();
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"valueOf(body.toLong()).toByteArray()");
        } else if (object instanceof Long) {
            byte[] byArray4 = BigInteger.valueOf(((Number)body).longValue()).toByteArray();
            byArray = byArray4;
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"valueOf(body).toByteArray()");
        } else {
            throw new IllegalStateException(("Unsupported body type: " + body.getClass().getSimpleName()).toString());
        }
        return byArray;
    }

    static {
        Object[] objectArray = new String[]{"content-type", "accept", "set-cookie"};
        checkedHeaders = CollectionsKt.listOf((Object[])objectArray);
        ZoneId zoneId = ZoneId.of("GMT");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(\"GMT\")");
        gmtZone = zoneId;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC)");
        httpDateFormatter = dateTimeFormatter;
    }
}

