/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http.model;

import com.hexagonkt.core.HelpersKt;
import com.hexagonkt.http.model.HttpStatus;
import com.hexagonkt.http.model.HttpStatusType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/hexagonkt/http/model/CustomStatus;", "Lcom/hexagonkt/http/model/HttpStatus;", "code", "", "type", "Lcom/hexagonkt/http/model/HttpStatusType;", "(ILcom/hexagonkt/http/model/HttpStatusType;)V", "getCode", "()I", "getType", "()Lcom/hexagonkt/http/model/HttpStatusType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "http"})
public final class CustomStatus
implements HttpStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int code;
    @NotNull
    private final HttpStatusType type;
    @NotNull
    public static final String INVALID_CODE_ERROR_MESSAGE = "Error code is not in any HTTP status range (100..599): ";

    public CustomStatus(int code, @NotNull HttpStatusType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.code = code;
        this.type = type;
        if (!HelpersKt.getDisableChecks()) {
            int n = this.getCode();
            if (!(100 <= n ? n < 600 : false)) {
                boolean bl = false;
                String string = INVALID_CODE_ERROR_MESSAGE + this.getCode();
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ CustomStatus(int n, HttpStatusType httpStatusType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            HttpStatusType httpStatusType2;
            int n3 = n;
            boolean bl = 100 <= n3 ? n3 < 200 : false;
            if (bl) {
                httpStatusType2 = HttpStatusType.INFORMATION;
            } else {
                boolean bl2 = 200 <= n3 ? n3 < 300 : false;
                if (bl2) {
                    httpStatusType2 = HttpStatusType.SUCCESS;
                } else {
                    boolean bl3 = 300 <= n3 ? n3 < 400 : false;
                    if (bl3) {
                        httpStatusType2 = HttpStatusType.REDIRECTION;
                    } else {
                        boolean bl4 = 400 <= n3 ? n3 < 500 : false;
                        if (bl4) {
                            httpStatusType2 = HttpStatusType.CLIENT_ERROR;
                        } else {
                            boolean bl5 = 500 <= n3 ? n3 < 600 : false;
                            if (bl5) {
                                httpStatusType2 = HttpStatusType.SERVER_ERROR;
                            } else {
                                throw new IllegalArgumentException(INVALID_CODE_ERROR_MESSAGE + n);
                            }
                        }
                    }
                }
            }
            httpStatusType = httpStatusType2;
        }
        this(n, httpStatusType);
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    @NotNull
    public HttpStatusType getType() {
        return this.type;
    }

    public final int component1() {
        return this.getCode();
    }

    @NotNull
    public final HttpStatusType component2() {
        return this.getType();
    }

    @NotNull
    public final CustomStatus copy(int code, @NotNull HttpStatusType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new CustomStatus(code, type);
    }

    public static /* synthetic */ CustomStatus copy$default(CustomStatus customStatus, int n, HttpStatusType httpStatusType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = customStatus.getCode();
        }
        if ((n2 & 2) != 0) {
            httpStatusType = customStatus.getType();
        }
        return customStatus.copy(n, httpStatusType);
    }

    @NotNull
    public String toString() {
        return "CustomStatus(code=" + this.getCode() + ", type=" + (Object)((Object)this.getType()) + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.getCode());
        result = result * 31 + this.getType().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CustomStatus)) {
            return false;
        }
        CustomStatus customStatus = (CustomStatus)other;
        if (this.getCode() != customStatus.getCode()) {
            return false;
        }
        return this.getType() == customStatus.getType();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/hexagonkt/http/model/CustomStatus$Companion;", "", "()V", "INVALID_CODE_ERROR_MESSAGE", "", "http"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

