/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http.patterns;

import com.hexagonkt.http.patterns.PathPattern;
import com.hexagonkt.http.patterns.PathPatternsKt;
import com.hexagonkt.http.patterns.RegexPathPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/hexagonkt/http/patterns/RegexPathPattern;", "Lcom/hexagonkt/http/patterns/PathPattern;", "regex", "Lkotlin/text/Regex;", "(Lkotlin/text/Regex;)V", "parameters", "", "", "getParameters", "()Ljava/util/List;", "pattern", "getPattern", "()Ljava/lang/String;", "prefix", "", "getPrefix", "()Z", "getRegex", "()Lkotlin/text/Regex;", "addPrefix", "component1", "copy", "equals", "other", "", "extractParameters", "", "requestUrl", "hashCode", "", "matches", "toString", "Companion", "http"})
public final class RegexPathPattern
implements PathPattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex regex;
    @NotNull
    private final String pattern;
    private final boolean prefix;
    @NotNull
    private final List<String> parameters;
    @NotNull
    private static final Regex PARAMETER_REGEX = new Regex("\\(\\?<\\w+>");

    public RegexPathPattern(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.regex = regex;
        this.pattern = this.regex.getPattern();
        this.prefix = !StringsKt.endsWith$default((String)this.regex.getPattern(), (String)"$", (boolean)false, (int)2, null);
        Object[] objectArray = new String[]{"(.*?)", "$"};
        PathPatternsKt.checkPathPatternPrefix(this.getPattern(), CollectionsKt.listOf((Object[])objectArray));
        this.parameters = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)PARAMETER_REGEX, (CharSequence)this.getPattern(), (int)0, (int)2, null), (Function1)parameters.1.INSTANCE));
    }

    @NotNull
    public final Regex getRegex() {
        return this.regex;
    }

    @Override
    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final List<String> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public PathPattern addPrefix(@Nullable String prefix) {
        return prefix == null ? (PathPattern)this : (PathPattern)this.copy(new Regex(prefix + this.getPattern()));
    }

    @Override
    public boolean matches(@NotNull String requestUrl) {
        Intrinsics.checkNotNullParameter((Object)requestUrl, (String)"requestUrl");
        return this.getPrefix() ? this.regex.matchesAt((CharSequence)requestUrl, 0) : this.regex.matches((CharSequence)requestUrl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> extractParameters(@NotNull String requestUrl) {
        Map map;
        Object object;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)requestUrl, (String)"requestUrl");
        MatchResult result = this.regex.matchEntire((CharSequence)requestUrl);
        if (!(result != null)) {
            boolean $i$a$-require-RegexPathPattern$extractParameters$22 = false;
            String $i$a$-require-RegexPathPattern$extractParameters$22 = "URL '" + requestUrl + "' does not match path";
            throw new IllegalArgumentException($i$a$-require-RegexPathPattern$extractParameters$22.toString());
        }
        Iterable $i$a$-require-RegexPathPattern$extractParameters$22 = CollectionsKt.drop((Iterable)result.getGroupValues(), (int)1);
        boolean $i$f$mapIndexed = false;
        void var6_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void v;
            void ii;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(TuplesKt.to((Object)String.valueOf((int)ii), (Object)v));
        }
        Map allValues2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        MatchNamedGroupCollection resultGroups = (MatchNamedGroupCollection)result.getGroups();
        if (this.parameters.isEmpty()) {
            map = allValues2;
        } else {
            Iterable $this$associateWith$iv = this.parameters;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Object object2 = resultGroups.get((String)it);
                if (object2 == null || (object2 = object2.getValue()) == null) {
                    object2 = "";
                }
                Object object3 = object2;
                object.put(t, object3);
            }
            map = MapsKt.plus((Map)result$iv, (Map)allValues2);
        }
        return map;
    }

    @Override
    @NotNull
    public String describe() {
        return PathPattern.DefaultImpls.describe(this);
    }

    @NotNull
    public final Regex component1() {
        return this.regex;
    }

    @NotNull
    public final RegexPathPattern copy(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return new RegexPathPattern(regex);
    }

    public static /* synthetic */ RegexPathPattern copy$default(RegexPathPattern regexPathPattern, Regex regex, int n, Object object) {
        if ((n & 1) != 0) {
            regex = regexPathPattern.regex;
        }
        return regexPathPattern.copy(regex);
    }

    @NotNull
    public String toString() {
        return "RegexPathPattern(regex=" + this.regex + ')';
    }

    public int hashCode() {
        return this.regex.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegexPathPattern)) {
            return false;
        }
        RegexPathPattern regexPathPattern = (RegexPathPattern)other;
        return Intrinsics.areEqual((Object)this.regex, (Object)regexPathPattern.regex);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/hexagonkt/http/patterns/RegexPathPattern$Companion;", "", "()V", "PARAMETER_REGEX", "Lkotlin/text/Regex;", "getPARAMETER_REGEX", "()Lkotlin/text/Regex;", "http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getPARAMETER_REGEX() {
            return PARAMETER_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

