/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http.client;

import com.hexagonkt.http.client.HttpClientPort;
import com.hexagonkt.http.client.HttpClientSettings;
import com.hexagonkt.http.client.model.HttpClientRequest;
import com.hexagonkt.http.client.model.HttpClientResponse;
import com.hexagonkt.http.model.ContentType;
import com.hexagonkt.http.model.Header;
import com.hexagonkt.http.model.HttpCookie;
import com.hexagonkt.http.model.HttpField;
import com.hexagonkt.http.model.HttpFields;
import com.hexagonkt.http.model.HttpMethod;
import java.io.Closeable;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\f0\u0016J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ6\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001e\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J6\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ&\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ&\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ&\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u0014J\u0006\u0010,\u001a\u00020\u0014J&\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lcom/hexagonkt/http/client/HttpClient;", "Ljava/io/Closeable;", "adapter", "Lcom/hexagonkt/http/client/HttpClientPort;", "baseUrl", "Ljava/net/URL;", "settings", "Lcom/hexagonkt/http/client/HttpClientSettings;", "(Lcom/hexagonkt/http/client/HttpClientPort;Ljava/net/URL;Lcom/hexagonkt/http/client/HttpClientSettings;)V", "(Lcom/hexagonkt/http/client/HttpClientPort;Lcom/hexagonkt/http/client/HttpClientSettings;)V", "cookies", "", "Lcom/hexagonkt/http/model/HttpCookie;", "getCookies", "()Ljava/util/List;", "setCookies", "(Ljava/util/List;)V", "getSettings", "()Lcom/hexagonkt/http/client/HttpClientSettings;", "close", "", "cookiesMap", "", "", "delete", "Lcom/hexagonkt/http/client/model/HttpClientResponse;", "path", "body", "", "contentType", "Lcom/hexagonkt/http/model/ContentType;", "get", "headers", "Lcom/hexagonkt/http/model/HttpFields;", "Lcom/hexagonkt/http/model/Header;", "head", "options", "patch", "post", "put", "send", "request", "Lcom/hexagonkt/http/client/model/HttpClientRequest;", "start", "stop", "trace", "http_client"})
public final class HttpClient
implements Closeable {
    @NotNull
    private final HttpClientPort adapter;
    @NotNull
    private final HttpClientSettings settings;
    @NotNull
    private List<HttpCookie> cookies;

    public HttpClient(@NotNull HttpClientPort adapter, @NotNull HttpClientSettings settings) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.adapter = adapter;
        this.settings = settings;
        this.cookies = CollectionsKt.emptyList();
    }

    public /* synthetic */ HttpClient(HttpClientPort httpClientPort, HttpClientSettings httpClientSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            httpClientSettings = new HttpClientSettings(null, null, false, null, false, null, 63, null);
        }
        this(httpClientPort, httpClientSettings);
    }

    @NotNull
    public final HttpClientSettings getSettings() {
        return this.settings;
    }

    public HttpClient(@NotNull HttpClientPort adapter, @NotNull URL baseUrl, @NotNull HttpClientSettings settings) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(adapter, HttpClientSettings.copy$default(settings, baseUrl, null, false, null, false, null, 62, null));
    }

    public /* synthetic */ HttpClient(HttpClientPort httpClientPort, URL uRL, HttpClientSettings httpClientSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uRL = new URL("http://localhost:8080");
        }
        if ((n & 4) != 0) {
            httpClientSettings = new HttpClientSettings(null, null, false, null, false, null, 63, null);
        }
        this(httpClientPort, uRL, httpClientSettings);
    }

    @NotNull
    public final List<HttpCookie> getCookies() {
        return this.cookies;
    }

    public final void setCookies(@NotNull List<HttpCookie> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.cookies = list;
    }

    @Override
    public void close() {
        this.stop();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, HttpCookie> cookiesMap() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.cookies;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HttpCookie httpCookie = (HttpCookie)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    public final void start() {
        this.adapter.startUp(this);
    }

    public final void stop() {
        this.adapter.shutDown();
    }

    @NotNull
    public final HttpClientResponse send(@NotNull HttpClientRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.adapter.send(request);
    }

    @NotNull
    public final HttpClientResponse get(@NotNull String path, @NotNull HttpFields<Header> headers, @Nullable Object body, @Nullable ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        HttpMethod httpMethod = HttpMethod.GET;
        Object object = body;
        if (object == null) {
            object = "";
        }
        Object object2 = object;
        return this.send(new HttpClientRequest(httpMethod, null, null, 0, path, null, headers, object2, null, null, null, contentType, null, 5934, null));
    }

    public static /* synthetic */ HttpClientResponse get$default(HttpClient httpClient, String string, HttpFields httpFields, Object object, ContentType contentType, int n, Object object2) {
        if ((n & 2) != 0) {
            httpFields = new HttpFields((HttpField[])new Header[0]);
        }
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            contentType = httpClient.settings.getContentType();
        }
        return httpClient.get(string, (HttpFields<Header>)httpFields, object, contentType);
    }

    @NotNull
    public final HttpClientResponse head(@NotNull String path, @NotNull HttpFields<Header> headers) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        HttpMethod httpMethod = HttpMethod.HEAD;
        byte[] byArray = new byte[]{};
        return this.send(new HttpClientRequest(httpMethod, null, null, 0, path, null, headers, byArray, null, null, null, null, null, 7982, null));
    }

    public static /* synthetic */ HttpClientResponse head$default(HttpClient httpClient, String string, HttpFields httpFields, int n, Object object) {
        if ((n & 2) != 0) {
            httpFields = new HttpFields((HttpField[])new Header[0]);
        }
        return httpClient.head(string, (HttpFields<Header>)httpFields);
    }

    @NotNull
    public final HttpClientResponse post(@NotNull String path, @Nullable Object body, @Nullable ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = body;
        if (object == null) {
            object = "";
        }
        return this.send(new HttpClientRequest(HttpMethod.POST, null, null, 0, path, null, null, object, null, null, null, contentType, null, 5998, null));
    }

    public static /* synthetic */ HttpClientResponse post$default(HttpClient httpClient, String string, Object object, ContentType contentType, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            contentType = httpClient.settings.getContentType();
        }
        return httpClient.post(string, object, contentType);
    }

    @NotNull
    public final HttpClientResponse put(@NotNull String path, @Nullable Object body, @Nullable ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = body;
        if (object == null) {
            object = "";
        }
        return this.send(new HttpClientRequest(HttpMethod.PUT, null, null, 0, path, null, null, object, null, null, null, contentType, null, 5998, null));
    }

    public static /* synthetic */ HttpClientResponse put$default(HttpClient httpClient, String string, Object object, ContentType contentType, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            contentType = httpClient.settings.getContentType();
        }
        return httpClient.put(string, object, contentType);
    }

    @NotNull
    public final HttpClientResponse delete(@NotNull String path, @Nullable Object body, @Nullable ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = body;
        if (object == null) {
            object = "";
        }
        return this.send(new HttpClientRequest(HttpMethod.DELETE, null, null, 0, path, null, null, object, null, null, null, contentType, null, 5998, null));
    }

    public static /* synthetic */ HttpClientResponse delete$default(HttpClient httpClient, String string, Object object, ContentType contentType, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            contentType = httpClient.settings.getContentType();
        }
        return httpClient.delete(string, object, contentType);
    }

    @NotNull
    public final HttpClientResponse trace(@NotNull String path, @Nullable Object body, @Nullable ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = body;
        if (object == null) {
            object = "";
        }
        return this.send(new HttpClientRequest(HttpMethod.TRACE, null, null, 0, path, null, null, object, null, null, null, contentType, null, 5998, null));
    }

    public static /* synthetic */ HttpClientResponse trace$default(HttpClient httpClient, String string, Object object, ContentType contentType, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            contentType = httpClient.settings.getContentType();
        }
        return httpClient.trace(string, object, contentType);
    }

    @NotNull
    public final HttpClientResponse options(@NotNull String path, @Nullable Object body, @NotNull HttpFields<Header> headers, @Nullable ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        HttpMethod httpMethod = HttpMethod.OPTIONS;
        Object object = body;
        if (object == null) {
            object = "";
        }
        Object object2 = object;
        return this.send(new HttpClientRequest(httpMethod, null, null, 0, path, null, headers, object2, null, null, null, contentType, null, 5934, null));
    }

    public static /* synthetic */ HttpClientResponse options$default(HttpClient httpClient, String string, Object object, HttpFields httpFields, ContentType contentType, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            httpFields = new HttpFields((HttpField[])new Header[0]);
        }
        if ((n & 8) != 0) {
            contentType = httpClient.settings.getContentType();
        }
        return httpClient.options(string, object, (HttpFields<Header>)httpFields, contentType);
    }

    @NotNull
    public final HttpClientResponse patch(@NotNull String path, @Nullable Object body, @Nullable ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = body;
        if (object == null) {
            object = "";
        }
        return this.send(new HttpClientRequest(HttpMethod.PATCH, null, null, 0, path, null, null, object, null, null, null, contentType, null, 5998, null));
    }

    public static /* synthetic */ HttpClientResponse patch$default(HttpClient httpClient, String string, Object object, ContentType contentType, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            contentType = httpClient.settings.getContentType();
        }
        return httpClient.patch(string, object, contentType);
    }
}

