/*
 * Decompiled with CFR 0.152.
 */
package com.hiczp.bilibili.live.danmu.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.hiczp.bilibili.live.danmu.api.ILiveDanMuCallback;
import com.hiczp.bilibili.live.danmu.api.LiveDanMuReceiver;
import com.hiczp.bilibili.live.danmu.api.PackageRepository;
import com.hiczp.bilibili.live.danmu.api.Utils;
import com.hiczp.bilibili.live.danmu.api.entity.DanMuMSGEntity;
import com.hiczp.bilibili.live.danmu.api.entity.JSONEntity;
import com.hiczp.bilibili.live.danmu.api.entity.LiveEntity;
import com.hiczp.bilibili.live.danmu.api.entity.PreparingEntity;
import com.hiczp.bilibili.live.danmu.api.entity.RoomAdminsEntity;
import com.hiczp.bilibili.live.danmu.api.entity.SendGiftEntity;
import com.hiczp.bilibili.live.danmu.api.entity.SysGiftEntity;
import com.hiczp.bilibili.live.danmu.api.entity.SysMSGEntity;
import com.hiczp.bilibili.live.danmu.api.entity.WelcomeEntity;
import com.hiczp.bilibili.live.danmu.api.entity.WelcomeGuardEntity;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CallbackDispatchRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CallbackDispatchRunnable.class);
    private LiveDanMuReceiver liveDanMuReceiver;
    private InputStream inputStream;
    private List<ILiveDanMuCallback> callbacks;
    private Boolean printDebugInfo = false;
    private byte[] jsonBytes;

    CallbackDispatchRunnable(LiveDanMuReceiver liveDanMuReceiver, InputStream inputStream, List<ILiveDanMuCallback> callbacks, Boolean printDebugInfo) {
        this.liveDanMuReceiver = liveDanMuReceiver;
        this.inputStream = inputStream;
        this.callbacks = callbacks;
        this.printDebugInfo = printDebugInfo;
    }

    private void dispatch() throws Exception {
        byte[] packageBytes = PackageRepository.readNextPackage(this.inputStream);
        if (this.callbacks.size() == 0) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(packageBytes);
        byteBuffer.position(4);
        byte[] protocolBytes = new byte[12];
        byteBuffer.get(protocolBytes);
        Consumer<ILiveDanMuCallback> consumer = null;
        if (Arrays.equals(protocolBytes, PackageRepository.DAN_MU_DATA_PACKAGE_PROTOCOL_BYTES)) {
            String cmd;
            this.jsonBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(this.jsonBytes);
            if (this.printDebugInfo.booleanValue()) {
                log.debug(new String(this.jsonBytes));
            }
            switch (cmd = ((JSONEntity)JSON.parseObject((byte[])this.jsonBytes, JSONEntity.class, (Feature[])new Feature[0])).cmd) {
                case "LIVE": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onLivePackage((LiveEntity)JSON.parseObject((byte[])this.jsonBytes, LiveEntity.class, (Feature[])new Feature[0]));
                    break;
                }
                case "PREPARING": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onPreparingPackage((PreparingEntity)JSON.parseObject((byte[])this.jsonBytes, PreparingEntity.class, (Feature[])new Feature[0]));
                    break;
                }
                case "DANMU_MSG": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onDanMuMSGPackage((DanMuMSGEntity)JSON.parseObject((byte[])this.jsonBytes, DanMuMSGEntity.class, (Feature[])new Feature[0]));
                    break;
                }
                case "SYS_MSG": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onSysMSGPackage((SysMSGEntity)JSON.parseObject((byte[])this.jsonBytes, SysMSGEntity.class, (Feature[])new Feature[0]));
                    break;
                }
                case "SEND_GIFT": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onSendGiftPackage((SendGiftEntity)JSON.parseObject((byte[])this.jsonBytes, SendGiftEntity.class, (Feature[])new Feature[0]));
                    break;
                }
                case "SYS_GIFT": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onSysGiftPackage((SysGiftEntity)JSON.parseObject((byte[])this.jsonBytes, SysGiftEntity.class, (Feature[])new Feature[0]));
                    break;
                }
                case "WELCOME": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onWelcomePackage((WelcomeEntity)JSON.parseObject((byte[])this.jsonBytes, WelcomeEntity.class, (Feature[])new Feature[0]));
                    break;
                }
                case "WELCOME_GUARD": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onWelcomeGuardPackage((WelcomeGuardEntity)JSON.parseObject((byte[])this.jsonBytes, WelcomeGuardEntity.class, (Feature[])new Feature[0]));
                    break;
                }
                case "ROOM_ADMINS": {
                    consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onRoomAdminsPackage((RoomAdminsEntity)JSON.parseObject((byte[])this.jsonBytes, RoomAdminsEntity.class, (Feature[])new Feature[0]));
                }
                default: {
                    if (this.printDebugInfo.booleanValue()) {
                        log.error("Unknown json above");
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (Arrays.equals(protocolBytes, PackageRepository.ONLINE_COUNT_PACKAGE_PROTOCOL_BYTES)) {
            int onlineCount = byteBuffer.getInt();
            if (this.printDebugInfo.booleanValue()) {
                log.debug("Viewers: " + onlineCount);
            }
            consumer = iLiveDanMuCallback -> iLiveDanMuCallback.onOnlineCountPackage(onlineCount);
        } else if (this.printDebugInfo.booleanValue()) {
            log.error("Unknown package below");
            Utils.printBytes(packageBytes);
        }
        if (consumer != null) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                try {
                    consumer.accept(this.callbacks.get(i));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.dispatch();
                }
            }
            catch (IOException e) {
                if (!this.liveDanMuReceiver.getSocket().isClosed()) continue;
            }
            catch (JSONException e) {
                log.error("Wrong JSON: " + new String(this.jsonBytes));
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        try {
            this.liveDanMuReceiver.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                try {
                    this.callbacks.get(i).onDisconnect();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

