/*
 * Decompiled with CFR 0.152.
 */
package com.hiczp.bilibili.live.danmu.api;

import com.hiczp.bilibili.live.danmu.api.CallbackDispatchRunnable;
import com.hiczp.bilibili.live.danmu.api.HeartBeatRunnable;
import com.hiczp.bilibili.live.danmu.api.ILiveDanMuCallback;
import com.hiczp.bilibili.live.danmu.api.PackageRepository;
import com.hiczp.bilibili.live.danmu.api.ScriptEntity;
import com.hiczp.bilibili.live.danmu.api.Utils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import org.jsoup.Jsoup;
import org.jsoup.parser.Parser;

public class LiveDanMuReceiver
implements Closeable {
    private static final String CID_INFO_URL = "http://live.bilibili.com/api/player?id=cid:";
    private static final int LIVE_SERVER_PORT = 788;
    private static final int SOCKET_TIMEOUT = 40000;
    private int roomId;
    private Long random;
    private Integer roomURL;
    private String urlString;
    private URL url;
    private Socket socket;
    private List<ILiveDanMuCallback> callbacks = new Vector<ILiveDanMuCallback>();
    private Boolean printDebugInfo = false;
    private Thread heartBeatThread;
    private Thread callbackDispatchThread;

    public LiveDanMuReceiver(int roomId) {
        this.roomId = roomId;
    }

    public LiveDanMuReceiver(String url) {
        this.urlString = url;
    }

    public LiveDanMuReceiver(URL url) {
        this.url = url;
    }

    Socket getSocket() {
        return this.socket;
    }

    public LiveDanMuReceiver addCallback(ILiveDanMuCallback liveDanMuCallback) {
        this.callbacks.add(liveDanMuCallback);
        return this;
    }

    public boolean removeCallback(ILiveDanMuCallback liveDanMuCallback) {
        return this.callbacks.remove(liveDanMuCallback);
    }

    public LiveDanMuReceiver connect() throws IOException, IllegalArgumentException {
        String serverAddress;
        if (this.urlString != null) {
            this.url = new URL(this.urlString);
        }
        if (this.url != null) {
            ScriptEntity scriptEntity = Utils.resolveScriptPartInHTML(this.url);
            this.roomId = scriptEntity.roomId;
            this.random = scriptEntity.random;
            this.roomURL = scriptEntity.roomURL;
        }
        try (InputStream inputStream = new URL(CID_INFO_URL + this.roomId).openStream();){
            serverAddress = Jsoup.parse((InputStream)inputStream, (String)StandardCharsets.UTF_8.toString(), (String)"", (Parser)Parser.xmlParser()).select("server").first().text();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Invalid RoomID");
        }
        catch (NullPointerException e) {
            throw new SocketException("Network error");
        }
        this.socket = new Socket(serverAddress, 788);
        this.socket.setSoTimeout(40000);
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(PackageRepository.getJoinPackage(this.roomId));
        outputStream.flush();
        InputStream inputStream = this.socket.getInputStream();
        if (!PackageRepository.readAndValidateJoinSuccessPackage(inputStream)) {
            this.socket.close();
            throw new SocketException("Join live channel failed");
        }
        this.heartBeatThread = new Thread(new HeartBeatRunnable(outputStream));
        this.heartBeatThread.start();
        this.callbackDispatchThread = new Thread(new CallbackDispatchRunnable(this, inputStream, this.callbacks, this.printDebugInfo));
        this.callbackDispatchThread.start();
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onConnect();
        }
        return this;
    }

    public LiveDanMuReceiver setPrintDebugInfo(Boolean printDebugInfo) {
        this.printDebugInfo = printDebugInfo;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.heartBeatThread != null) {
            try {
                this.heartBeatThread.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void waitUntilCallbackDispatchThreadExit() {
        if (this.callbackDispatchThread != null) {
            try {
                this.callbackDispatchThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Optional<URL> getUrl() {
        return this.url == null ? Optional.empty() : Optional.of(this.url);
    }

    public int getRoomId() {
        return this.roomId;
    }

    public Optional<Long> getRandom() {
        return this.random == null ? Optional.empty() : Optional.of(this.random);
    }

    public Optional<Integer> getRoomURL() {
        return this.roomURL == null ? Optional.empty() : Optional.of(this.roomURL);
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }
}

