/*
 * Decompiled with CFR 0.152.
 */
package com.hiczp.bilibili.live.danmu.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hiczp.bilibili.live.danmu.api.ScriptEntity;
import com.hiczp.bilibili.live.danmu.api.Utils;
import com.hiczp.bilibili.live.danmu.api.entity.DanMuResponseEntity;
import com.hiczp.bilibili.live.danmu.api.entity.UserInfoEntity;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import sun.security.rsa.RSAPublicKeyImpl;

public class LiveDanMuSender {
    private String urlString;
    private URL url;
    private Integer roomId;
    private Long random;
    private Integer roomURL;
    private String cookies;

    public LiveDanMuSender(String url) {
        this.urlString = url;
    }

    public LiveDanMuSender(URL url) {
        this.url = url;
    }

    public static String cipherPassword(String password) throws Exception {
        String key;
        String hash;
        try (CloseableHttpClient closeableHttpClient = HttpClients.createMinimal();){
            JSONObject jsonObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)closeableHttpClient.execute((HttpUriRequest)new HttpGet("http://passport.bilibili.com/login?act=getkey")).getEntity()));
            hash = jsonObject.getString("hash");
            key = jsonObject.getString("key");
        }
        RSAPublicKeyImpl rsaPublicKey = new RSAPublicKeyImpl(Base64.getDecoder().decode(key.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("\n", "").getBytes()));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, rsaPublicKey);
        return new String(Base64.getEncoder().encode(cipher.doFinal((hash + password).getBytes())));
    }

    public static boolean testLogin(String cookies) throws IOException {
        return LiveDanMuSender.getUserInfo((String)cookies).code.equals("REPONSE_OK");
    }

    public static UserInfoEntity getUserInfo(String cookies) throws IOException {
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet("http://api.live.bilibili.com/User/getUserInfo");
            httpGet.setHeader("Cookie", cookies);
            UserInfoEntity userInfoEntity = (UserInfoEntity)JSON.parseObject((String)EntityUtils.toString((HttpEntity)closeableHttpClient.execute((HttpUriRequest)httpGet).getEntity()), UserInfoEntity.class);
            return userInfoEntity;
        }
    }

    public boolean testLogin() throws IOException {
        return LiveDanMuSender.testLogin(this.cookies);
    }

    public UserInfoEntity getUserInfo() throws IOException {
        return LiveDanMuSender.getUserInfo(this.cookies);
    }

    private void resolveRoomData() throws IOException, IllegalArgumentException {
        if (this.url == null) {
            this.url = new URL(this.urlString);
        }
        if (this.roomId == null || this.random == null || this.roomURL == null) {
            ScriptEntity scriptEntity = Utils.resolveScriptPartInHTML(this.url);
            this.roomId = scriptEntity.roomId;
            this.random = scriptEntity.random;
            this.roomURL = scriptEntity.roomURL;
        }
    }

    public LiveDanMuSender setCookies(String cookies) {
        this.cookies = cookies;
        return this;
    }

    public LiveDanMuSender setCookies(String DedeUserID, String DedeUserID__ckMd5, String SESSDATA) {
        this.cookies = String.format("%s; %s; %s", DedeUserID, DedeUserID__ckMd5, SESSDATA);
        return this;
    }

    public boolean isCookiesSet() {
        return this.cookies != null;
    }

    public DanMuResponseEntity send(String message) throws IOException, IllegalArgumentException {
        return this.send("16777215", "25", "1", message);
    }

    public DanMuResponseEntity send(String color, String fontSize, String mode, String message) throws IOException, IllegalArgumentException {
        this.resolveRoomData();
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost("http://live.bilibili.com/msg/send");
        httpPost.setHeader("Cookie", this.cookies);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("color", color), new BasicNameValuePair("fontsize", fontSize), new BasicNameValuePair("mode", mode), new BasicNameValuePair("msg", message), new BasicNameValuePair("random", this.random.toString()), new BasicNameValuePair("roomid", this.roomId.toString())), StandardCharsets.UTF_8));
        DanMuResponseEntity danMuResponseEntity = (DanMuResponseEntity)JSON.parseObject((String)EntityUtils.toString((HttpEntity)closeableHttpClient.execute((HttpUriRequest)httpPost).getEntity()), DanMuResponseEntity.class);
        closeableHttpClient.close();
        return danMuResponseEntity;
    }

    public URL getUrl() {
        return this.url;
    }

    public Integer getRoomId() {
        return this.roomId;
    }

    public Long getRandom() {
        return this.random;
    }

    public Integer getRoomURL() {
        return this.roomURL;
    }
}

