/*
 * Decompiled with CFR 0.152.
 */
package com.hiczp.bilibili.live.danmu.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.hiczp.bilibili.live.danmu.api.JoinEntity;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

class PackageRepository {
    static final int PACKAGE_LENGTH_BYTES_LENGTH = 4;
    static final int PACKAGE_PROTOCOL_BYTES_LENGTH = 12;
    static final int PACKAGE_HEAD_BYTES_LENGTH = 16;
    static final byte[] ONLINE_COUNT_PACKAGE_PROTOCOL_BYTES = new byte[]{0, 16, 0, 1, 0, 0, 0, 3, 0, 0, 0, 1};
    static final byte[] DAN_MU_DATA_PACKAGE_PROTOCOL_BYTES = new byte[]{0, 16, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0};
    static final byte[] HEART_BEAT_PACKAGE_BYTES = new byte[]{0, 0, 0, 16, 0, 16, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1};
    static final byte[] JOIN_SUCCESS_PACKAGE_BYTES = new byte[]{0, 0, 0, 16, 0, 16, 0, 1, 0, 0, 0, 8, 0, 0, 0, 1};
    static final byte[] JOIN_PACKAGE_PROTOCOL_BYTES = new byte[]{0, 16, 0, 1, 0, 0, 0, 7, 0, 0, 0, 1};

    PackageRepository() {
    }

    private static byte[] readBytesFormInputStream(InputStream inputStream, int count) throws IOException {
        byte[] bytes = new byte[count];
        for (int readCount = 0; readCount < count; readCount += inputStream.read(bytes, readCount, count - readCount)) {
        }
        return bytes;
    }

    static byte[] readNextPackage(InputStream inputStream) throws IOException {
        byte[] packageLengthBytes = PackageRepository.readBytesFormInputStream(inputStream, 4);
        int packageLength = new BigInteger(packageLengthBytes).intValue();
        if (packageLength < 16) {
            throw new IOException("Package length less than 16 byte");
        }
        return ByteBuffer.allocate(packageLength).put(packageLengthBytes).put(PackageRepository.readBytesFormInputStream(inputStream, packageLength - 4)).array();
    }

    static boolean readAndValidateJoinSuccessPackage(InputStream inputStream) throws IOException {
        return Arrays.equals(PackageRepository.readNextPackage(inputStream), JOIN_SUCCESS_PACKAGE_BYTES);
    }

    static byte[] getJoinPackage(int roomId) {
        byte[] jsonBytes = JSON.toJSONBytes((Object)new JoinEntity(roomId), (SerializerFeature[])new SerializerFeature[0]);
        int packageLength = 16 + jsonBytes.length;
        return ByteBuffer.allocate(packageLength).putInt(packageLength).put(JOIN_PACKAGE_PROTOCOL_BYTES).put(jsonBytes).array();
    }

    static byte[] getHeartBeatPackageBytes() {
        return HEART_BEAT_PACKAGE_BYTES;
    }
}

