/*
 * Decompiled with CFR 0.152.
 */
package com.hiczp.bilibili.live.danmu.api;

import com.hiczp.bilibili.live.danmu.api.ScriptEntity;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;

class Utils {
    Utils() {
    }

    private static byte[][] splitBytes(byte[] bytes, int n) {
        int lineCount = bytes.length % n == 0 ? bytes.length / n : bytes.length / n + 1;
        byte[][] result = new byte[lineCount][];
        for (int line = 1; line <= lineCount; ++line) {
            int to = line != lineCount ? line * n : bytes.length;
            result[line - 1] = Arrays.copyOfRange(bytes, (line - 1) * n, to);
        }
        return result;
    }

    static void printBytes(byte[] bytes) {
        byte[][] data = Utils.splitBytes(bytes, 16);
        for (int i = 0; i < data.length; ++i) {
            int j;
            System.out.printf("%08x  ", i * 16);
            byte[] currentRow = data[i];
            for (j = 0; j < currentRow.length; ++j) {
                System.out.printf("%02x ", currentRow[j]);
                if (j != 7) continue;
                System.out.print(" ");
            }
            if (currentRow.length < 16) {
                for (int k = 0; k < 48 - currentRow.length * 2 - (currentRow.length - 1); ++k) {
                    System.out.print(" ");
                }
            }
            System.out.print(" ");
            for (j = 0; j < currentRow.length; ++j) {
                char c = currentRow[j] < 32 ? (char)'.' : (char)((char)currentRow[j]);
                System.out.print(c);
                if (j != 7) continue;
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    static ScriptEntity resolveScriptPartInHTML(URL url) throws IOException, IllegalArgumentException {
        ScriptEntity scriptEntity = new ScriptEntity();
        String scriptText = Jsoup.parse((URL)url, (int)10000).head().select("script").last().data();
        Matcher matcher = Pattern.compile("var ROOMID = (\\d+);").matcher(scriptText);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid URL");
        }
        scriptEntity.roomId = Integer.valueOf(matcher.group(1));
        matcher = Pattern.compile("var DANMU_RND = (\\d+);").matcher(scriptText);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid URL");
        }
        scriptEntity.random = Long.valueOf(matcher.group(1));
        matcher = Pattern.compile("var ROOMURL = (\\d+);").matcher(scriptText);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid URL");
        }
        scriptEntity.roomURL = Integer.valueOf(matcher.group(1));
        return scriptEntity;
    }
}

