package com.hiczp.jpa.repository.select;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import static com.hiczp.jpa.repository.select.Utils.createSpecification;

@NoRepositoryBean
@Transactional(readOnly = true)
public interface SelectRepository<T> extends JpaSpecificationExecutor<T> {

    default T select(T entity) {
        return findOne(createSpecification(entity));
    }

    default List<T> selectAll(T entity) {
        return findAll(createSpecification(entity));
    }

    default Page<T> selectAll(T entity, Pageable pageable) {
        return findAll(createSpecification(entity), pageable);
    }

    default List<T> selectAll(T entity, Sort sort) {
        return findAll(createSpecification(entity), sort);
    }

    default long count(T entity) {
        return count(createSpecification(entity));
    }
}
