package com.hiczp.jpa.repository.select;

import org.springframework.data.jpa.domain.Specification;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import java.util.Arrays;
import java.util.List;

class Utils {
    static <T> Specification<T> createSpecification(T entity) {
        return (root, criteriaQuery, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            List<Expression<Boolean>> expressions = predicate.getExpressions();

            Arrays.stream(entity.getClass().getDeclaredFields())
                    .filter(field -> field.isAnnotationPresent(Column.class) || field.isAnnotationPresent(Id.class))
                    .forEach(field -> {
                        try {
                            field.setAccessible(true);
                            Object value = field.get(entity);
                            if (value == null || value.equals(0) || value.equals(false)) {
                                return;
                            }
                            expressions.add(criteriaBuilder.equal(root.get(field.getName()), value));
                        } catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    });

            return predicate;
        };
    }
}
