/*
 * Decompiled with CFR 0.152.
 */
package com.hiczp.jpa.repository.select;

import com.hiczp.jpa.repository.select.Utils;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.transaction.annotation.Transactional;

@NoRepositoryBean
@Transactional(readOnly=true)
public interface SelectRepository<T>
extends JpaSpecificationExecutor<T> {
    default public T select(T entity) {
        return (T)this.findOne(Utils.createSpecification(entity));
    }

    default public List<T> selectAll(T entity) {
        return this.findAll(Utils.createSpecification(entity));
    }

    default public Page<T> selectAll(T entity, Pageable pageable) {
        return this.findAll(Utils.createSpecification(entity), pageable);
    }

    default public List<T> selectAll(T entity, Sort sort) {
        return this.findAll(Utils.createSpecification(entity), sort);
    }

    default public long count(T entity) {
        return this.count(Utils.createSpecification(entity));
    }
}

