/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msfscc.fileinformation;

import com.hierynomus.msdtyp.FileTime;
import com.hierynomus.msdtyp.MsDataTypes;
import com.hierynomus.protocol.commons.Charsets;
import com.hierynomus.protocol.commons.buffer.Buffer;

public class VolumeInfo {
    private final FileTime volumeCreationTime;
    private final int volumeSerialNumber;
    private final boolean supportsObjects;
    private final String volumeLabel;

    public static VolumeInfo parseFileFsVolumeInformation(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        FileTime volumeCreationTime = MsDataTypes.readFileTime(buffer);
        int volumeSerialNumber = buffer.readUInt32AsInt();
        long nameLen = buffer.readUInt32();
        boolean supportsObjects = buffer.readBoolean();
        buffer.skip(1);
        String volumeLabel = buffer.readString(Charsets.UTF_16LE, (int)nameLen / 2);
        return new VolumeInfo(volumeCreationTime, volumeSerialNumber, supportsObjects, volumeLabel);
    }

    VolumeInfo(FileTime volumeCreationTime, int volumeSerialNumber, boolean supportsObjects, String volumeLabel) {
        this.volumeCreationTime = volumeCreationTime;
        this.volumeSerialNumber = volumeSerialNumber;
        this.supportsObjects = supportsObjects;
        this.volumeLabel = volumeLabel;
    }

    public FileTime getVolumeCreationTime() {
        return this.volumeCreationTime;
    }

    public int getVolumeSerialNumber() {
        return this.volumeSerialNumber;
    }

    public boolean isSupportsObjects() {
        return this.supportsObjects;
    }

    public String getVolumeLabel() {
        return this.volumeLabel;
    }

    public String toString() {
        return "VolumeInfo{volumeCreationTime=" + this.volumeCreationTime + ", volumeSerialNumber=" + this.volumeSerialNumber + ", supportsObjects=" + this.supportsObjects + ", volumeLabel='" + this.volumeLabel + '\'' + '}';
    }
}

