/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.utils;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.io.InputStreamByteChunkProvider;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;

public class SmbFiles {
    public static long copy(java.io.File source, DiskShare share, String destPath, boolean overwrite) throws IOException {
        long bytesWritten = 0L;
        if (source != null && source.exists() && source.canRead() && source.isFile()) {
            try (FileInputStream is = new FileInputStream(source);){
                bytesWritten = SmbFiles.write(is, share, destPath, overwrite);
            }
        }
        return bytesWritten;
    }

    public static long write(InputStream source, DiskShare share, String destPath, boolean overwrite) {
        long bytesWritten = 0L;
        if (destPath != null && source != null) {
            try (File file = share.openFile(destPath, EnumSet.of(AccessMask.GENERIC_WRITE), EnumSet.of(FileAttributes.FILE_ATTRIBUTE_NORMAL), EnumSet.of(SMB2ShareAccess.FILE_SHARE_WRITE), overwrite ? SMB2CreateDisposition.FILE_OVERWRITE_IF : SMB2CreateDisposition.FILE_CREATE, EnumSet.noneOf(SMB2CreateOptions.class));){
                bytesWritten = file.write(new InputStreamByteChunkProvider(source));
            }
        }
        return bytesWritten;
    }

    public void mkdirs(DiskShare diskShare, String path) throws SMBApiException {
        SmbPath smbPath = new SmbPath(diskShare.getSmbPath(), path);
        this.mkdirs(diskShare, smbPath);
    }

    public void mkdirs(DiskShare diskShare, SmbPath path) throws SMBApiException {
        if (!diskShare.folderExists(path.getPath())) {
            this.mkdirs(diskShare, path.getParent());
            diskShare.mkdir(path.getPath());
        }
    }
}

