/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.kex.DHBase;
import net.schmizz.sshj.transport.kex.SecgUtils;

public class ECDH
extends DHBase {
    private ECParameterSpec ecParameterSpec;

    public ECDH() {
        super("EC", "ECDH");
    }

    @Override
    protected void init(AlgorithmParameterSpec params) throws GeneralSecurityException {
        this.generator.initialize(params);
        KeyPair keyPair = this.generator.generateKeyPair();
        this.agreement.init(keyPair.getPrivate());
        ECPublicKey ecPublicKey = (ECPublicKey)keyPair.getPublic();
        this.ecParameterSpec = ecPublicKey.getParams();
        ECPoint w = ecPublicKey.getW();
        byte[] encoded = SecgUtils.getEncoded(w, this.ecParameterSpec.getCurve());
        this.setE(encoded);
    }

    @Override
    public void computeK(byte[] f) throws GeneralSecurityException {
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EC");
        ECPublicKeySpec keySpec = new ECPublicKeySpec(SecgUtils.getDecoded(f, this.ecParameterSpec.getCurve()), this.ecParameterSpec);
        PublicKey yourPubKey = keyFactory.generatePublic(keySpec);
        this.agreement.doPhase(yourPubKey, true);
        this.setK(new BigInteger(1, this.agreement.generateSecret()));
    }
}

