/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.transport;

import java.io.IOException;
import java.util.Arrays;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentificationStringParser {
    private static final Logger logger = LoggerFactory.getLogger(IdentificationStringParser.class);
    private final Buffer.PlainBuffer buffer;
    private byte[] EXPECTED_START_BYTES = new byte[]{83, 83, 72, 45};

    public IdentificationStringParser(Buffer.PlainBuffer buffer) {
        this.buffer = buffer;
    }

    public String parseIdentificationString() throws IOException {
        while (true) {
            byte b;
            Buffer.PlainBuffer lineBuffer = new Buffer.PlainBuffer();
            int lineStartPos = this.buffer.rpos();
            do {
                if (this.buffer.available() == 0) {
                    this.buffer.rpos(lineStartPos);
                    return "";
                }
                b = this.buffer.readByte();
                lineBuffer.putByte(b);
            } while (b != 10);
            if (this.checkForIdentification(lineBuffer)) {
                return this.readIdentification(lineBuffer);
            }
            this.logHeaderLine(lineBuffer);
        }
    }

    private void logHeaderLine(Buffer.PlainBuffer lineBuffer) {
    }

    private String readIdentification(Buffer.PlainBuffer lineBuffer) throws Buffer.BufferException, TransportException {
        byte[] bytes = new byte[lineBuffer.available()];
        lineBuffer.readRawBytes(bytes);
        if (bytes.length > 255) {
            logger.error("Incorrect identification String received, line was longer than expected: {}", (Object)new String(bytes));
            logger.error("Just for good measure, bytes were: {}", (Object)ByteArrayUtils.printHex(bytes, 0, bytes.length));
            throw new TransportException("Incorrect identification: line too long: " + ByteArrayUtils.printHex(bytes, 0, bytes.length));
        }
        if (bytes[bytes.length - 2] != 13) {
            String ident = new String(bytes, 0, bytes.length - 1);
            logger.warn("Server identification has bad line ending, was expecting a '\\r\\n' however got: '{}' (hex: {})", (Object)Character.valueOf((char)(bytes[bytes.length - 2] & 0xFF)), (Object)Integer.toHexString(bytes[bytes.length - 2] & 0xFF));
            logger.warn("Will treat the identification of this server '{}' leniently", (Object)ident);
            return ident;
        }
        return new String(bytes, 0, bytes.length - 2);
    }

    private boolean checkForIdentification(Buffer.PlainBuffer lineBuffer) throws Buffer.BufferException {
        if (lineBuffer.available() < 4) {
            return false;
        }
        byte[] buf = new byte[4];
        lineBuffer.readRawBytes(buf);
        lineBuffer.rpos(0);
        return Arrays.equals(this.EXPECTED_START_BYTES, buf);
    }
}

