/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SignatureException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;
import net.schmizz.sshj.signature.Signature;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERSequence;

public class SignatureECDSA
extends AbstractSignature {
    private String keyTypeName;

    public SignatureECDSA(String algorithm, String keyTypeName) {
        super(algorithm);
        this.keyTypeName = keyTypeName;
    }

    @Override
    public byte[] encode(byte[] sig) {
        int rIndex = 3;
        int rLen = sig[rIndex++] & 0xFF;
        byte[] r = new byte[rLen];
        System.arraycopy(sig, rIndex, r, 0, r.length);
        int sIndex = rIndex + rLen + 1;
        int sLen = sig[sIndex++] & 0xFF;
        byte[] s = new byte[sLen];
        System.arraycopy(sig, sIndex, s, 0, s.length);
        System.arraycopy(sig, 4, r, 0, rLen);
        System.arraycopy(sig, 6 + rLen, s, 0, sLen);
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
        buf.putMPInt(new BigInteger(r));
        buf.putMPInt(new BigInteger(s));
        return buf.getCompactData();
    }

    @Override
    public boolean verify(byte[] sig) {
        byte[] s;
        byte[] r;
        try {
            Buffer.PlainBuffer sigbuf = new Buffer.PlainBuffer(sig);
            String algo = new String(sigbuf.readBytes());
            if (!this.keyTypeName.equals(algo)) {
                throw new SSHRuntimeException(String.format("Signature :: " + this.keyTypeName + " expected, got %s", algo));
            }
            int rsLen = sigbuf.readUInt32AsInt();
            if (sigbuf.available() != rsLen) {
                throw new SSHRuntimeException("Invalid key length");
            }
            r = sigbuf.readBytes();
            s = sigbuf.readBytes();
        }
        catch (Exception e) {
            throw new SSHRuntimeException(e);
        }
        try {
            return this.signature.verify(this.asnEncode(r, s));
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
        catch (IOException e) {
            throw new SSHRuntimeException(e);
        }
    }

    private byte[] asnEncode(byte[] r, byte[] s) throws IOException {
        int rLen = r.length;
        int sLen = s.length;
        if ((r[0] & 0x80) != 0) {
            ++rLen;
        }
        if ((s[0] & 0x80) != 0) {
            ++sLen;
        }
        int length = 6 + rLen + sLen;
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(r));
        vector.add((ASN1Encodable)new ASN1Integer(s));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        ASN1OutputStream asnOS = new ASN1OutputStream((OutputStream)baos);
        asnOS.writeObject((ASN1Encodable)new DERSequence(vector));
        asnOS.flush();
        return baos.toByteArray();
    }

    public static class Factory521
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA512withECDSA", KeyType.ECDSA521.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA521.toString();
        }
    }

    public static class Factory384
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA384withECDSA", KeyType.ECDSA384.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA384.toString();
        }
    }

    public static class Factory256
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA256withECDSA", KeyType.ECDSA256.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA256.toString();
        }
    }
}

