/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.utils;

import com.highmobility.utils.Base64;
import java.nio.ByteBuffer;
import java.util.UUID;

public class ByteUtils {
    static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String hexFromBytes(byte[] bytes) {
        if (bytes == null) {
            return "(null)";
        }
        if (bytes.length == 0) {
            return "[]";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String hexFromByte(byte value) {
        return ByteUtils.hexFromBytes(new byte[]{value});
    }

    public static byte[] bytesFromHex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] bytesFromHexCheckInput(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        boolean[] hexArrayContains = new boolean[2];
        for (int i = 0; i < len; i += 2) {
            Character hexFirstCharacter = Character.valueOf(Character.toUpperCase(s.charAt(i)));
            Character hexSecondCharacter = Character.valueOf(Character.toUpperCase(s.charAt(i + 1)));
            for (int j = 0; j < hexArray.length; ++j) {
                if (!hexArrayContains[0] && hexFirstCharacter.charValue() == hexArray[j]) {
                    hexArrayContains[0] = true;
                }
                if (hexArrayContains[1] || hexSecondCharacter.charValue() != hexArray[j]) continue;
                hexArrayContains[1] = true;
            }
            if (!hexArrayContains[0] || !hexArrayContains[1]) {
                throw new IllegalArgumentException("Not a hex string.");
            }
            hexArrayContains[0] = false;
            hexArrayContains[1] = false;
            data[i / 2] = (byte)((Character.digit(hexFirstCharacter.charValue(), 16) << 4) + Character.digit(hexSecondCharacter.charValue(), 16));
        }
        return data;
    }

    public static byte[] bytesFromHexOrBase64(String input) {
        try {
            byte[] result = ByteUtils.bytesFromHexCheckInput(input);
            return result;
        }
        catch (Exception e) {
            try {
                byte[] result = Base64.decode(input);
                return result;
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Cannot parse the input string to a byte array: " + e2.getMessage());
            }
        }
    }

    public static byte[] concatBytes(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static byte[] concatBytes(byte[] a, byte b) {
        int aLen = a.length;
        byte[] c = new byte[aLen + 1];
        System.arraycopy(a, 0, c, 0, aLen);
        c[c.length - 1] = b;
        return c;
    }

    public static void setBytes(byte[] inArray, byte[] toBytes, int offset) {
        for (int i = offset; i < offset + toBytes.length; ++i) {
            if (i > inArray.length - 1) {
                return;
            }
            inArray[offset + (i - offset)] = toBytes[i - offset];
        }
    }

    public static boolean getBit(byte fromByte, int bitIndex) {
        return (fromByte >> bitIndex & 1) == 1;
    }

    public static boolean startsWith(byte[] source, byte[] match) {
        return ByteUtils.startsWith(source, 0, match);
    }

    public static boolean startsWith(byte[] source, int offset, byte[] match) {
        if (match.length > source.length - offset) {
            return false;
        }
        for (int i = 0; i < match.length; ++i) {
            if (source[offset + i] == match[i]) continue;
            return false;
        }
        return true;
    }

    public static UUID UUIDFromByteArray(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long high = bb.getLong();
        long low = bb.getLong();
        UUID uuid = new UUID(high, low);
        return uuid;
    }

    public static byte[] bytesFromMacString(String mac) {
        String[] macAddressParts = mac.split(":");
        byte[] macAddressBytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            Integer hex = Integer.parseInt(macAddressParts[i], 16);
            macAddressBytes[i] = hex.byteValue();
        }
        return macAddressBytes;
    }

    public static byte[] trimmedBytes(byte[] bytes, int length) {
        if (bytes.length == length) {
            return bytes;
        }
        byte[] trimmedBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            trimmedBytes[i] = bytes[i];
        }
        return trimmedBytes;
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }
}

