/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.value;

import com.highmobility.utils.Base64;
import com.highmobility.utils.ByteUtils;
import java.util.AbstractList;
import java.util.Arrays;

public class Bytes
extends AbstractList<Byte> {
    protected byte[] bytes;

    public byte[] getByteArray() {
        return this.bytes;
    }

    public int getLength() {
        return this.bytes.length;
    }

    public String getHex() {
        return ByteUtils.hexFromBytes(this.bytes);
    }

    public String getBase64() {
        return Base64.encode(this.bytes);
    }

    public String getBase64UrlSafe() {
        return Base64.encodeUrlSafe(this.bytes);
    }

    public Bytes concat(Bytes bytes) {
        return Bytes.concat(this, bytes);
    }

    public Bytes(String value) {
        this(ByteUtils.bytesFromHexOrBase64(value));
    }

    public Bytes(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        this.bytes = bytes;
    }

    public Bytes(Bytes bytes) {
        this(bytes.getByteArray());
    }

    public Bytes() {
        this.bytes = new byte[0];
    }

    public Bytes(int length) {
        this.bytes = new byte[length];
    }

    @Override
    public Bytes set(int position, byte value) {
        this.bytes[position] = value;
        return this;
    }

    @Override
    public Bytes set(int position, Bytes bytes) {
        this.set(position, bytes.getByteArray());
        return this;
    }

    @Override
    public Bytes set(int position, byte[] bytes) {
        ByteUtils.setBytes(this.bytes, bytes, position);
        return this;
    }

    public Bytes getRange(int from, int to) {
        return new Bytes(Arrays.copyOfRange(this.getByteArray(), from, to));
    }

    public static Bytes concat(Bytes first, Bytes second) {
        return new Bytes(ByteUtils.concatBytes(first.getByteArray(), second.getByteArray()));
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    public Byte get(int index) {
        return this.bytes[index];
    }

    @Override
    public String toString() {
        return ByteUtils.hexFromBytes(this.bytes);
    }

    @Override
    public boolean equals(Object obj) {
        try {
            return obj instanceof Bytes && Arrays.equals(((Bytes)obj).bytes, this.bytes) || obj instanceof byte[] && Arrays.equals((byte[])obj, this.bytes) || obj instanceof String && Arrays.equals(ByteUtils.bytesFromHexOrBase64((String)obj), this.bytes);
        }
        catch (Exception e) {
            return super.equals(obj);
        }
    }
}

