/*
 * Decompiled with CFR 0.152.
 */
package com.highmobility.value;

import com.highmobility.utils.ByteUtils;
import com.highmobility.utils.Range;
import com.highmobility.value.Bytes;

public class BytesWithLength
extends Bytes {
    public BytesWithLength(Bytes value) {
        super(value.getByteArray());
        this.validateBytes();
    }

    public BytesWithLength(String value) {
        super(value);
        this.validateBytes();
    }

    public BytesWithLength(byte[] bytes) {
        super(bytes);
        this.validateBytes();
    }

    public BytesWithLength() {
    }

    void validateBytes() {
        if (this.getExpectedLength() != -1 && this.getExpectedLength() != this.bytes.length || this.getExpectedRange() != null && !this.getExpectedRange().contains(this.bytes.length)) {
            throw new IllegalArgumentException(this.getClass() + ": invalid bytes " + ByteUtils.hexFromBytes(this.bytes) + " for expected length: " + this.getExpectedLength() + " range " + this.getExpectedRange());
        }
    }

    protected int getExpectedLength() {
        return -1;
    }

    protected Range getExpectedRange() {
        return null;
    }
}

