/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.jdbc;

import com.highgo.jdbc.core.Field;
import com.highgo.jdbc.core.Query;
import com.highgo.jdbc.core.ResultCursor;
import com.highgo.jdbc.core.ResultHandlerBase;
import com.highgo.jdbc.core.Tuple;
import com.highgo.jdbc.jdbc.PgResultSet;
import com.highgo.jdbc.jdbc.PgStatement;
import com.highgo.jdbc.jdbc.ResultWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class BulkloadResultHandler
extends ResultHandlerBase {
    private final PgStatement statement;
    private ResultWrapper results;
    private ResultWrapper lastResult;

    public BulkloadResultHandler(PgStatement statement) {
        this.statement = statement;
    }

    public ResultWrapper getResults() {
        return this.results;
    }

    private void append(ResultWrapper newResult) {
        if (this.results == null) {
            this.lastResult = this.results = newResult;
        } else {
            this.lastResult.append(newResult);
        }
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor) {
        try {
            ResultSet rs = this.createResultSet(fromQuery, fields, tuples, cursor);
            this.lastResult = this.results = new ResultWrapper(rs);
        }
        catch (SQLException e) {
            this.handleError(e);
        }
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
        this.append(new ResultWrapper(updateCount, insertOID));
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        this.addWarning(warning);
    }

    public ResultSet createResultSet(Query originalQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor) throws SQLException {
        PgResultSet newResult = new PgResultSet(originalQuery, this.statement, fields, tuples, cursor, this.statement.getMaxRows(), this.statement.getMaxFieldSize(), this.statement.getResultSetType(), this.statement.getResultSetConcurrency(), this.statement.getResultSetHoldability(), this.statement.getAdaptiveFetch());
        newResult.setFetchSize(this.statement.getFetchSize());
        newResult.setFetchDirection(this.statement.getFetchDirection());
        return newResult;
    }

    public void addWarning(SQLWarning warn) {
    }
}

