/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.core;

import com.highgo.jdbc.core.Encoding;
import com.highgo.jdbc.util.GT;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

abstract class OptimizedUTF8Encoder
extends Encoding {
    private static final int MIN_2_BYTES = 128;
    private static final int MIN_3_BYTES = 2048;
    private static final int MIN_4_BYTES = 65536;
    private static final int MAX_CODE_POINT = 0x10FFFF;
    private final int thresholdSize = 8192;
    private char[] decoderArray = new char[1024];

    OptimizedUTF8Encoder() {
        super(StandardCharsets.UTF_8, true);
    }

    char[] getCharArray(int size) {
        if (size <= this.decoderArray.length) {
            return this.decoderArray;
        }
        char[] chars = new char[size];
        if (size <= 8192) {
            this.decoderArray = chars;
        }
        return chars;
    }

    synchronized String charDecode(byte[] encodedString, int offset, int length) throws IOException {
        char[] chars = this.getCharArray(length);
        int out = 0;
        int j = offset + length;
        for (int i = offset; i < j; ++i) {
            if (encodedString[i] < 0) {
                return OptimizedUTF8Encoder.decodeToChars(encodedString, i, j - i, chars, out);
            }
            chars[out++] = (char)encodedString[i];
        }
        return new String(chars, 0, out);
    }

    static String decodeToChars(byte[] data, int offset, int length, char[] chars, int out) throws IOException {
        int in = offset;
        int end = length + offset;
        try {
            while (in < end) {
                int ch;
                if ((ch = data[in++] & 0xFF) >= 128) {
                    if (ch < 192) {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", "10xxxxxx", ch));
                    }
                    if (ch < 224) {
                        ch = (ch & 0x1F) << 6;
                        OptimizedUTF8Encoder.checkByte(data[in], 2, 2);
                        OptimizedUTF8Encoder.checkMinimal(ch |= data[in++] & 0x3F, 128);
                    } else if (ch < 240) {
                        ch = (ch & 0xF) << 12;
                        OptimizedUTF8Encoder.checkByte(data[in], 2, 3);
                        ch |= (data[in++] & 0x3F) << 6;
                        OptimizedUTF8Encoder.checkByte(data[in], 3, 3);
                        OptimizedUTF8Encoder.checkMinimal(ch |= data[in++] & 0x3F, 2048);
                    } else if (ch < 248) {
                        ch = (ch & 7) << 18;
                        OptimizedUTF8Encoder.checkByte(data[in], 2, 4);
                        ch |= (data[in++] & 0x3F) << 12;
                        OptimizedUTF8Encoder.checkByte(data[in], 3, 4);
                        ch |= (data[in++] & 0x3F) << 6;
                        OptimizedUTF8Encoder.checkByte(data[in], 4, 4);
                        OptimizedUTF8Encoder.checkMinimal(ch |= data[in++] & 0x3F, 65536);
                    } else {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", "11111xxx", ch));
                    }
                }
                if (ch > 0x10FFFF) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final value is out of range: {0}", ch));
                }
                if (ch > 65535) {
                    chars[out++] = (char)(55296 + ((ch -= 65536) >> 10));
                    chars[out++] = (char)(56320 + (ch & 0x3FF));
                    continue;
                }
                if (ch >= 55296 && ch < 57344) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final value is a surrogate value: {0}", ch));
                }
                chars[out++] = (char)ch;
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        return new String(chars, 0, out);
    }

    private static void checkByte(int ch, int pos, int len) throws IOException {
        if ((ch & 0xC0) != 128) {
            throw new IOException(GT.tr("Illegal UTF-8 sequence: byte {0} of {1} byte sequence is not 10xxxxxx: {2}", pos, len, ch));
        }
    }

    private static void checkMinimal(int ch, int minValue) throws IOException {
        int expectedLen;
        int actualLen;
        if (ch >= minValue) {
            return;
        }
        switch (minValue) {
            case 128: {
                actualLen = 2;
                break;
            }
            case 2048: {
                actualLen = 3;
                break;
            }
            case 65536: {
                actualLen = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected minValue passed to checkMinimal: " + minValue);
            }
        }
        if (ch < 128) {
            expectedLen = 1;
        } else if (ch < 2048) {
            expectedLen = 2;
        } else if (ch < 65536) {
            expectedLen = 3;
        } else {
            throw new IllegalArgumentException("unexpected ch passed to checkMinimal: " + ch);
        }
        throw new IOException(GT.tr("Illegal UTF-8 sequence: {0} bytes used to encode a {1} byte value: {2}", actualLen, expectedLen, ch));
    }
}

